/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.sidid.SidIdInfo;
import libsidutils.sidid.SidIdV2;

class Prg
extends SidTune {
    protected static final MessageDigest MD5_DIGEST;
    private static final SidIdV2 SID_ID;
    private static final SidIdInfo SID_ID_INFO;
    protected int programOffset;
    protected byte[] program;

    Prg() {
    }

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        if (!PathUtils.getFilenameSuffix(name).equalsIgnoreCase(".prg") || dataBuf.length < 2) {
            throw new SidTuneError("Bad file extension expected: .prg and length > 2");
        }
        Prg prg = new Prg();
        prg.program = dataBuf;
        prg.programOffset = 2;
        prg.info.c64dataLen = dataBuf.length - prg.programOffset;
        prg.info.loadAddr = (dataBuf[0] & 0xFF) + ((dataBuf[1] & 0xFF) << 8);
        prg.info.infoString.add(PathUtils.getFilenameWithoutSuffix(name));
        return prg;
    }

    @Override
    public void save(String filename) throws IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            out.write(this.program);
        }
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem) {
        int start = this.info.loadAddr;
        int end = start + this.info.c64dataLen;
        mem[45] = (byte)(end & 0xFF);
        mem[46] = (byte)(end >> 8);
        mem[47] = (byte)(end & 0xFF);
        mem[48] = (byte)(end >> 8);
        mem[49] = (byte)(end & 0xFF);
        mem[50] = (byte)(end >> 8);
        mem[172] = (byte)(start & 0xFF);
        mem[173] = (byte)(start >> 8);
        mem[174] = (byte)(end & 0xFF);
        mem[175] = (byte)(end >> 8);
        System.arraycopy(this.program, this.programOffset, mem, start, end - start);
        return null;
    }

    @Override
    public Collection<String> identify() {
        return SID_ID.identify(this.program);
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName) {
        return SID_ID_INFO.getPlayerInfo(playerName);
    }

    @Override
    public String getMD5Digest() {
        return null;
    }

    @Override
    protected long getInitDelay() {
        return 2500000L;
    }

    static {
        SID_ID = new SidIdV2();
        SID_ID_INFO = new SidIdInfo();
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
            SID_ID.readconfig();
            SID_ID.setMultiScan(true);
            SID_ID_INFO.readconfig();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

