/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.assembler.KickAssembler;

class PSid
extends Prg {
    private static final String PSIDDRIVER_ASM = "/libsidplay/sidtune/psiddriver.asm";
    private static final int PSID_MUS = 1;
    private static final int PSID_SPECIFIC = 2;
    private static final int PSID_BASIC = 2;
    private static final int SIDTUNE_MAX_SONGS = 256;
    private SidTune.Speed[] songSpeed = new SidTune.Speed[256];
    private final KickAssembler assembler = new KickAssembler();

    PSid() {
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem) {
        super.placeProgramInMemory(mem);
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            mem[780] = (byte)(this.info.currentSong - 1);
            return null;
        }
        return this.psidInstallDriver(mem);
    }

    private int psidInstallDriver(byte[] mem) {
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("pc", String.valueOf(this.info.determinedDriverAddr));
        globals.put("songNum", String.valueOf(this.info.currentSong));
        globals.put("songs", String.valueOf(this.info.songs));
        globals.put("songSpeed", String.valueOf(this.getSongSpeed(this.info.currentSong) == SidTune.Speed.CIA_1A ? 1 : 0));
        globals.put("speed", String.valueOf(this.getSongSpeedWord()));
        globals.put("loadAddr", String.valueOf(this.info.loadAddr));
        globals.put("initAddr", String.valueOf(this.info.initAddr));
        globals.put("playAddr", String.valueOf(this.info.playAddr));
        globals.put("powerOnDelay", String.valueOf((int)(256L + (System.currentTimeMillis() & 0x1FFL))));
        globals.put("initIOMap", String.valueOf(this.info.iomap(this.info.initAddr)));
        globals.put("playIOMap", String.valueOf(this.info.iomap(this.info.playAddr)));
        globals.put("videoMode", String.valueOf(this.info.clockSpeed == SidTune.Clock.PAL ? 1 : 0));
        globals.put("flags", String.valueOf(this.info.compatibility == SidTune.Compatibility.RSIDv2 || this.info.compatibility == SidTune.Compatibility.RSIDv3 ? 1 : 4));
        InputStream asm = PSid.class.getResourceAsStream(PSIDDRIVER_ASM);
        byte[] driver = this.assembler.assemble(PSIDDRIVER_ASM, asm, globals);
        this.info.determinedDriverLength = driver.length - 2;
        System.arraycopy(driver, 2, mem, this.info.determinedDriverAddr, this.info.determinedDriverLength);
        Integer start = this.assembler.getLabels().get("start");
        if (start == null) {
            throw new RuntimeException("Label start not found in /libsidplay/sidtune/psiddriver.asm");
        }
        if (this.info.determinedDriverLength + 255 >> 8 != 1) {
            throw new RuntimeException("Driver must not be greater than one block! /libsidplay/sidtune/psiddriver.asm");
        }
        return start;
    }

    private void resolveAddrs() throws SidTuneError {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                throw new SidTuneError("Song is truncated");
            }
            this.info.loadAddr = (this.program[this.programOffset] & 0xFF) + ((this.program[this.programOffset + 1] & 0xFF) << 8);
            this.programOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            if (this.info.initAddr != 0) {
                throw new SidTuneError("Init address given for a RSID tune with BASIC flag");
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
    }

    protected void findPlaceForDriver() throws SidTuneError {
        short startlp = (short)(this.info.loadAddr >> 8);
        short endlp = (short)(this.info.loadAddr + this.info.c64dataLen - 1 >> 8);
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
        } else if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
        } else {
            short startp = this.info.relocStartPage;
            short endp = (short)(startp + this.info.relocPages - 1 & 0xFF);
            if (endp < startp) {
                throw new SidTuneError(String.format("Relocation info is invalid: end before start: end=%02x, start=%02x", endp, startp));
            }
            if (startp <= startlp && endp >= startlp || startp <= endlp && endp >= endlp) {
                throw new SidTuneError(String.format("Relocation info is invalid: relocation in middle of song tune itself: songstart=%02x, songend=%02x, relocstart=%02x, relocend=%02x", startlp, endlp, startp, endp));
            }
            if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || 160 <= endp && endp <= 191 || endp >= 208) {
                throw new SidTuneError(String.format("Relocation info is invalid: beyond acceptable bounds (kernal, basic, io, < 4th page): %02x-%02x", startp, endp));
            }
        }
        this.info.determinedDriverAddr = this.info.relocStartPage << 8;
        if (this.info.determinedDriverAddr == 0) {
            boolean driverLen = true;
            block0: for (int i = 4; i < 208; ++i) {
                for (int j = 0; j < 1; ++j) {
                    if (i + j >= startlp && i + j <= endlp || i + j >= 160 && i + j <= 191) continue block0;
                }
                this.info.determinedDriverAddr = i << 8;
                break;
            }
        }
        if (this.info.determinedDriverAddr == 0) {
            throw new SidTuneError("Can't relocate tune: no pages left to store driver.");
        }
    }

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        int speed;
        PSid psid;
        PHeader header;
        block30: {
            block29: {
                if (dataBuf.length < 124) {
                    throw new SidTuneError(String.format("Header too short: %d, expected (%d)", dataBuf.length, 124));
                }
                header = new PHeader(dataBuf);
                if ((header.flags & 1) != 0) {
                    throw new SidTuneError("MUS-specific PSIDs are not supported by this player");
                }
                psid = new PSid();
                psid.program = dataBuf;
                psid.programOffset = header.data;
                psid.info.c64dataLen = dataBuf.length - psid.programOffset;
                psid.info.loadAddr = header.load & 0xFFFF;
                psid.info.initAddr = header.init & 0xFFFF;
                psid.info.playAddr = header.play & 0xFFFF;
                psid.info.songs = header.songs & 0xFFFF;
                if (psid.info.songs == 0) {
                    ++psid.info.songs;
                }
                if (psid.info.songs > 256) {
                    psid.info.songs = 256;
                }
                psid.info.startSong = header.start & 0xFFFF;
                if (psid.info.startSong > psid.info.songs) {
                    psid.info.startSong = 1;
                } else if (psid.info.startSong == 0) {
                    ++psid.info.startSong;
                }
                speed = header.speed;
                if (!Arrays.equals(header.id, new byte[]{80, 83, 73, 68})) break block29;
                switch (header.version) {
                    case 1: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv1;
                        break block30;
                    }
                    case 2: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv2;
                        if ((header.flags & 2) != 0) {
                            throw new SidTuneError("PSID-specific files are not supported by this player");
                        }
                        break block30;
                    }
                    case 3: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv3;
                        break block30;
                    }
                    case 4: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv4;
                        break block30;
                    }
                    default: {
                        throw new SidTuneError("PSID version must be 1, 2, 3 or 4, now: " + header.version);
                    }
                }
            }
            if (Arrays.equals(header.id, new byte[]{82, 83, 73, 68})) {
                if ((header.flags & 2) != 0) {
                    psid.info.compatibility = SidTune.Compatibility.RSID_BASIC;
                } else {
                    switch (header.version) {
                        case 2: {
                            psid.info.compatibility = SidTune.Compatibility.RSIDv2;
                            break;
                        }
                        case 3: {
                            psid.info.compatibility = SidTune.Compatibility.RSIDv3;
                            break;
                        }
                        default: {
                            throw new SidTuneError("RSID version must be 2 or 3, now: " + header.version);
                        }
                    }
                }
                if (psid.info.loadAddr != 0 || psid.info.playAddr != 0 || speed != 0) {
                    throw new SidTuneError("RSID tune specified load, play or speed information.");
                }
                speed = -1;
            } else {
                throw new SidTuneError("Bad PSID header, expected (PSID or RSID)");
            }
        }
        int clock = 0;
        int model1 = 0;
        int model2 = 0;
        int model3 = 0;
        if (header.version >= 2) {
            clock = header.flags >> 2 & 3;
            model1 = header.flags >> 4 & 3;
            psid.info.relocStartPage = (short)(header.relocStartPage & 0xFF);
            psid.info.relocPages = (short)(header.relocPages & 0xFF);
            if (header.version >= 3) {
                model2 = header.flags >> 6 & 3;
                int sid2loc = 0xD000 | (header.sidChip2MiddleNybbles & 0xFF) << 4;
                if ((sid2loc >= 54304 && sid2loc < 55296 || sid2loc >= 56832) && (sid2loc & 0x10) == 0) {
                    psid.info.sidChipBase[1] = sid2loc;
                    if (model2 == 0) {
                        model2 = model1;
                    }
                }
                model3 = header.flags >> 8 & 3;
                int sid3loc = 0xD000 | (header.sidChip3MiddleNybbles & 0xFF) << 4;
                if ((sid3loc >= 54304 && sid3loc < 55296 || sid3loc >= 56832) && (sid3loc & 0x10) == 0) {
                    psid.info.sidChipBase[2] = sid3loc;
                    if (model3 == 0) {
                        model3 = model1;
                    }
                }
            }
        }
        psid.info.clockSpeed = SidTune.Clock.values()[clock];
        psid.info.sidModel[0] = SidTune.Model.values()[model1];
        psid.info.sidModel[1] = SidTune.Model.values()[model2];
        psid.info.sidModel[2] = SidTune.Model.values()[model3];
        psid.convertOldStyleSpeedToTables(speed);
        psid.info.infoString.add(header.getString(header.name));
        psid.info.infoString.add(header.getString(header.author));
        psid.info.infoString.add(header.getString(header.released));
        psid.resolveAddrs();
        psid.findPlaceForDriver();
        return psid;
    }

    private void convertOldStyleSpeedToTables(long speed) {
        for (int s = 0; s < 256; ++s) {
            int i = s > 31 ? 31 : s;
            this.songSpeed[s] = (speed & (long)(1 << i)) != 0L ? SidTune.Speed.CIA_1A : SidTune.Speed.VBI;
        }
    }

    @Override
    public int getSongSpeedWord() {
        int speed = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.songSpeed[i] == SidTune.Speed.VBI) continue;
            speed |= 1 << i;
        }
        return speed;
    }

    @Override
    public SidTune.Speed getSongSpeed(int selected) {
        return this.songSpeed[selected - 1];
    }

    @Override
    public void save(String name) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(name);){
            PHeader header = new PHeader();
            PHeader.access$902(header, "PSID".getBytes(Charset.forName("ISO-8859-1")));
            if (this.info.getSIDChipBase(2) != 0) {
                header.version = (short)4;
            } else if (this.info.getSIDChipBase(1) != 0) {
                header.version = (short)3;
            } else {
                header.version = (short)2;
            }
            header.data = (short)124;
            header.songs = (short)this.info.songs;
            header.start = (short)this.info.startSong;
            header.speed = this.getSongSpeedWord();
            header.init = (short)this.info.initAddr;
            header.relocStartPage = (byte)this.info.relocStartPage;
            header.relocPages = (byte)this.info.relocPages;
            short tmpFlags = 0;
            switch (this.info.compatibility) {
                case RSID_BASIC: {
                    tmpFlags = (short)(tmpFlags | 2);
                }
                case RSIDv2: 
                case RSIDv3: {
                    PHeader.access$902(header, "RSID".getBytes(Charset.forName("ISO-8859-1")));
                    header.speed = 0;
                    break;
                }
                case PSIDv1: {
                    throw new IOException("PSID-specific files are not supported by this player");
                }
                default: {
                    header.play = (short)this.info.playAddr;
                }
            }
            if (this.info.infoString.size() == 3) {
                Iterator<String> descriptionIt = this.info.infoString.iterator();
                String title = descriptionIt.next();
                String author = descriptionIt.next();
                String released = descriptionIt.next();
                if (title.length() == 32 || author.length() == 32 || released.length() == 32) {
                    header.version = (short)3;
                }
                byte[] titleBytes = title.getBytes("ISO-8859-1");
                for (int i = 0; i < title.length(); ++i) {
                    ((PHeader)header).name[i] = titleBytes[i];
                }
                byte[] authorBytes = author.getBytes("ISO-8859-1");
                for (int i = 0; i < author.length(); ++i) {
                    ((PHeader)header).author[i] = authorBytes[i];
                }
                byte[] releasedBytes = released.getBytes("ISO-8859-1");
                for (int i = 0; i < released.length(); ++i) {
                    ((PHeader)header).released[i] = releasedBytes[i];
                }
            }
            tmpFlags = (short)(tmpFlags | this.info.clockSpeed.ordinal() << 2);
            tmpFlags = (short)(tmpFlags | this.info.getSIDModel(0).ordinal() << 4);
            tmpFlags = (short)(tmpFlags | this.info.getSIDModel(1).ordinal() << 6);
            tmpFlags = (short)(tmpFlags | this.info.getSIDModel(2).ordinal() << 8);
            header.flags = tmpFlags;
            fos.write(header.getArray());
            byte[] saveAddr = new byte[]{(byte)(this.info.loadAddr & 0xFF), (byte)(this.info.loadAddr >> 8)};
            fos.write(saveAddr);
            fos.write(this.program, this.programOffset, this.info.c64dataLen);
        }
    }

    @Override
    public String getMD5Digest() {
        byte[] encryptMsg;
        byte[] myMD5 = new byte[this.info.c64dataLen + 6 + this.info.songs + (this.info.clockSpeed == SidTune.Clock.NTSC ? 1 : 0)];
        System.arraycopy(this.program, this.programOffset, myMD5, 0, this.info.c64dataLen);
        int i = this.info.c64dataLen;
        myMD5[i++] = (byte)(this.info.initAddr & 0xFF);
        myMD5[i++] = (byte)(this.info.initAddr >> 8);
        myMD5[i++] = (byte)(this.info.playAddr & 0xFF);
        myMD5[i++] = (byte)(this.info.playAddr >> 8);
        myMD5[i++] = (byte)(this.info.songs & 0xFF);
        myMD5[i++] = (byte)(this.info.songs >> 8);
        for (int s = 1; s <= this.info.songs; ++s) {
            myMD5[i++] = (byte)this.getSongSpeed(s).speedValue();
        }
        if (this.info.clockSpeed == SidTune.Clock.NTSC) {
            myMD5[i++] = (byte)this.info.clockSpeed.ordinal();
        }
        StringBuilder md5 = new StringBuilder();
        for (byte anEncryptMsg : encryptMsg = MD5_DIGEST.digest(myMD5)) {
            md5.append(String.format("%02x", anEncryptMsg & 0xFF));
        }
        return md5.toString();
    }

    @Override
    public long getInitDelay() {
        return this.info.compatibility == SidTune.Compatibility.RSID_BASIC || this.info.compatibility == SidTune.Compatibility.RSIDv2 || this.info.compatibility == SidTune.Compatibility.RSIDv3 ? 2500000L : 2500L;
    }

    private static class PHeader {
        private static final int SIZE = 124;
        private byte[] id = new byte[4];
        private short version;
        private short data;
        private short load;
        private short init;
        private short play;
        private short songs;
        private short start;
        private int speed;
        private byte[] name = new byte[32];
        private byte[] author = new byte[32];
        private byte[] released = new byte[32];
        private short flags;
        private byte relocStartPage;
        private byte relocPages;
        private byte sidChip2MiddleNybbles;
        private byte sidChip3MiddleNybbles;

        private PHeader(byte[] header) {
            ByteBuffer buffer = ByteBuffer.wrap(header);
            buffer.get(this.id);
            this.version = buffer.getShort();
            this.data = buffer.getShort();
            this.load = buffer.getShort();
            this.init = buffer.getShort();
            this.play = buffer.getShort();
            this.songs = buffer.getShort();
            this.start = buffer.getShort();
            this.speed = buffer.getInt();
            buffer.get(this.name);
            buffer.get(this.author);
            buffer.get(this.released);
            if (this.version >= 2) {
                this.flags = buffer.getShort();
                this.relocStartPage = buffer.get();
                this.relocPages = buffer.get();
                this.sidChip2MiddleNybbles = buffer.get();
                this.sidChip3MiddleNybbles = buffer.get();
            }
        }

        private PHeader() {
        }

        private byte[] getArray() {
            ByteBuffer buffer = ByteBuffer.allocate(124);
            buffer.put(this.id);
            buffer.putShort(this.version);
            buffer.putShort(this.data);
            buffer.putShort(this.load);
            buffer.putShort(this.init);
            buffer.putShort(this.play);
            buffer.putShort(this.songs);
            buffer.putShort(this.start);
            buffer.putInt(this.speed);
            buffer.put(this.name);
            buffer.put(this.author);
            buffer.put(this.released);
            if (this.version >= 2) {
                buffer.putShort(this.flags);
                buffer.put(this.relocStartPage);
                buffer.put(this.relocPages);
                buffer.put(this.sidChip2MiddleNybbles);
                buffer.put(this.sidChip3MiddleNybbles);
            }
            return buffer.array();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getString(byte[] info) {
            try (Scanner sc = new Scanner(new String(info, "ISO-8859-1"));){
                String string = sc.useDelimiter("\u0000").next();
                return string;
            }
            catch (UnsupportedEncodingException | NoSuchElementException e) {
                return "<?>";
            }
        }

        static /* synthetic */ byte[] access$902(PHeader x0, byte[] x1) {
            x0.id = x1;
            return x1;
        }
    }
}

