/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.Petscii;

class P00
extends Prg {
    private static final String SIDTUNE_ID = "C64File";

    P00() {
    }

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        String ext = PathUtils.getFilenameSuffix(name).toUpperCase(Locale.ENGLISH);
        if (dataBuf.length < 28 || ext.length() != 4 || '0' != ext.charAt(2) || '0' != ext.charAt(3)) {
            throw new SidTuneError("Bad file extension expected: .p00");
        }
        X00Header header = new X00Header(dataBuf);
        X00Format type = X00Format.valueOf(String.valueOf(ext.charAt(1)));
        if (type != X00Format.P || !header.getId().equals(SIDTUNE_ID)) {
            throw new SidTuneError("Bad program type, expected: C64File, PRG");
        }
        P00 p00 = new P00();
        p00.program = dataBuf;
        p00.programOffset = 28;
        p00.info.c64dataLen = dataBuf.length - p00.programOffset;
        p00.info.loadAddr = dataBuf[26] & 0xFF | (dataBuf[27] & 0xFF) << 8;
        p00.info.infoString.add(Petscii.petsciiToIso88591(header.name));
        return p00;
    }

    private static class X00Header {
        private static final int ID_LEN = 8;
        private static final int NAME_LEN = 17;
        private static final int SIZE = 26;
        private byte[] id = new byte[8];
        private byte[] name = new byte[17];

        public X00Header(byte[] s) {
            ByteBuffer b = ByteBuffer.wrap(s);
            b.get(this.id);
            b.get(this.name);
        }

        public String getId() {
            return new String(this.id, 0, 7, Charset.forName("ISO-8859-1"));
        }
    }

    private static enum X00Format {
        D,
        S,
        P,
        U,
        R;

    }
}

