/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import libsidplay.sidtune.PSid;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.Petscii;
import libsidutils.assembler.KickAssembler;

class Mus
extends PSid {
    protected static String MUSDRIVER1_ASM = "/libsidplay/sidtune/musdriver1.asm";
    protected static String MUSDRIVER2_ASM = "/libsidplay/sidtune/musdriver2.asm";
    private static final List<String> DEFAULT_MUS_NAMES = Arrays.asList(".mus", ".str", "_a.mus", "_b.mus");
    private static final String ERR_SIDTUNE_INVALID = "ERROR: File contains invalid data";
    private static final String ERR_SIDTUNE_2ND_INVALID = "ERROR: 2nd file contains invalid data";
    private static final int MUS_HLT_CMD = 335;
    private static final int MUS_DATA_ADDR = 2304;
    private static final int DUAL_SID_BASE = 54528;
    private final KickAssembler assembler = new KickAssembler();
    private int musDataLen;

    Mus() {
    }

    @Override
    public Integer placeProgramInMemory(byte[] c64buf) {
        this.installMusPlayers(c64buf);
        return super.placeProgramInMemory(c64buf);
    }

    private int detect(File musFile, byte[] buffer, String errorMessage) throws SidTuneError {
        String suffix = PathUtils.getFilenameSuffix(musFile.getName().toLowerCase(Locale.ENGLISH));
        if (!DEFAULT_MUS_NAMES.stream().anyMatch(ext -> suffix.endsWith((String)ext))) {
            throw new SidTuneError(errorMessage);
        }
        if (buffer == null || buffer.length < 8) {
            throw new SidTuneError(errorMessage);
        }
        int voice1DataEnd = 8 + ((buffer[2] & 0xFF) + ((buffer[3] & 0xFF) << 8));
        int voice2DataEnd = voice1DataEnd + ((buffer[4] & 0xFF) + ((buffer[5] & 0xFF) << 8));
        int voice3DataEnd = voice2DataEnd + ((buffer[6] & 0xFF) + ((buffer[7] & 0xFF) << 8));
        if (voice3DataEnd - 1 >= buffer.length || (buffer[voice1DataEnd - 1] & 0xFF) + ((buffer[voice1DataEnd - 2] & 0xFF) << 8) != 335 || (buffer[voice2DataEnd - 1] & 0xFF) + ((buffer[voice2DataEnd - 2] & 0xFF) << 8) != 335 || (buffer[voice3DataEnd - 1] & 0xFF) + ((buffer[voice3DataEnd - 2] & 0xFF) << 8) != 335) {
            throw new SidTuneError(errorMessage);
        }
        return voice3DataEnd;
    }

    protected static SidTune load(File musFile, byte[] dataBuf) throws SidTuneError {
        Mus mus = new Mus();
        mus.loadWithProvidedMetadata(musFile, dataBuf);
        return mus;
    }

    private void loadWithProvidedMetadata(File musFile, byte[] musBuf) throws SidTuneError {
        int voice3DataEnd = this.detect(musFile, musBuf, ERR_SIDTUNE_INVALID);
        this.musDataLen = musBuf.length;
        if (voice3DataEnd < musBuf.length) {
            String credits = this.getCredits(musBuf, voice3DataEnd);
            this.info.commentString.add(credits);
            voice3DataEnd += credits.length() + 1;
        }
        byte[] strBuf = null;
        File stereoFile = Mus.getStereoTune(musFile);
        if (stereoFile != null) {
            try {
                strBuf = Mus.getFileContents(stereoFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (strBuf != null) {
            voice3DataEnd = this.detect(stereoFile, strBuf, ERR_SIDTUNE_2ND_INVALID);
            if (voice3DataEnd < strBuf.length) {
                this.info.commentString.add(this.getCredits(strBuf, voice3DataEnd));
            }
            this.info.sidChipBase[1] = 54528;
        }
        this.info.loadAddr = 2304;
        this.info.compatibility = SidTune.Compatibility.PSIDv2;
        this.info.infoString.add(PathUtils.getFilenameWithoutSuffix(musFile.getName()));
        this.info.infoString.add("<?>");
        this.info.infoString.add("<?>");
        this.program = new byte[musBuf.length + (strBuf != null ? strBuf.length : 0)];
        this.info.c64dataLen = this.program.length;
        System.arraycopy(musBuf, 0, this.program, 0, musBuf.length);
        if (strBuf != null) {
            System.arraycopy(strBuf, 0, this.program, musBuf.length, strBuf.length);
        }
        this.findPlaceForDriver();
    }

    private String getCredits(byte[] musBuf, int voice3DataEnd) {
        byte[] creditsBytes = Arrays.copyOfRange(musBuf, voice3DataEnd, musBuf.length - 1);
        return Petscii.petsciiToIso88591(creditsBytes);
    }

    private static File getStereoTune(File file) {
        File[] siblings = file.getParentFile().listFiles((dir, name) -> {
            String suffix = PathUtils.getFilenameSuffix(name.toLowerCase(Locale.ENGLISH));
            return DEFAULT_MUS_NAMES.stream().filter(ext -> suffix.endsWith((String)ext)).findFirst().isPresent();
        });
        for (String extension : DEFAULT_MUS_NAMES) {
            String test = file.getName().replaceFirst("(_[aA]|_[bB])?\\.\\w+$", extension);
            if (file.getName().equalsIgnoreCase(test)) continue;
            for (File sibling : siblings) {
                if (!sibling.getName().equalsIgnoreCase(test)) continue;
                return sibling;
            }
        }
        return null;
    }

    private void installMusPlayers(byte[] c64buf) {
        HashMap<String, String> globals = new HashMap<String, String>();
        InputStream asm = Mus.class.getResourceAsStream(MUSDRIVER1_ASM);
        byte[] driver = this.assembler.assemble(MUSDRIVER1_ASM, asm, globals);
        Integer data_low = this.assembler.getLabels().get("data_low");
        Integer data_high = this.assembler.getLabels().get("data_high");
        Integer init = this.assembler.getLabels().get("init");
        Integer start = this.assembler.getLabels().get("start");
        this.checkLabels(MUSDRIVER1_ASM, data_low, data_high, init, start);
        this.installMusPlayer(c64buf, 2304, driver, data_low, data_high);
        if (this.info.getSIDChipBase(1) != 0) {
            globals = new HashMap();
            asm = Mus.class.getResourceAsStream(MUSDRIVER2_ASM);
            driver = this.assembler.assemble(MUSDRIVER2_ASM, asm, globals);
            data_low = this.assembler.getLabels().get("data_low");
            data_high = this.assembler.getLabels().get("data_high");
            init = this.assembler.getLabels().get("init");
            start = this.assembler.getLabels().get("start");
            this.checkLabels(MUSDRIVER2_ASM, data_low, data_high, init, start);
            this.installMusPlayer(c64buf, 2304 + this.musDataLen, driver, data_low, data_high);
        }
        this.info.initAddr = init;
        this.info.playAddr = start;
    }

    private void checkLabels(String asmSource, Integer data_low, Integer data_high, Integer init, Integer start) {
        if (data_low == null) {
            throw new RuntimeException("Label data_low not found in " + asmSource);
        }
        if (data_high == null) {
            throw new RuntimeException("Label data_high not found in " + asmSource);
        }
        if (init == null) {
            throw new RuntimeException("Label init not found in " + asmSource);
        }
        if (start == null) {
            throw new RuntimeException("Label start not found in " + asmSource);
        }
    }

    private void installMusPlayer(byte[] c64buf, int musDataAddr, byte[] driver, Integer data_low, Integer data_high) {
        int driverAddr = (driver[0] & 0xFF) + ((driver[1] & 0xFF) << 8);
        System.arraycopy(driver, 2, c64buf, driverAddr, driver.length - 2);
        c64buf[data_low.intValue() + 1] = (byte)(2 + musDataAddr & 0xFF);
        c64buf[data_high.intValue() + 1] = (byte)(2 + musDataAddr >> 8);
    }

    @Override
    public String getMD5Digest() {
        return null;
    }

    @Override
    public void save(String destFileName) throws IOException {
        try (FileOutputStream fMyOut = new FileOutputStream(destFileName);){
            fMyOut.write(this.program);
        }
    }
}

