/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.sidid.SidIdInfo;
import lowlevel.ID3V2Decoder;

public class MP3Tune
extends SidTune {
    private String mp3Filename;
    private ID3V2Decoder decoder = new ID3V2Decoder();

    @Override
    public Integer placeProgramInMemory(byte[] c64buf) {
        return null;
    }

    @Override
    public void save(String destFileName) throws IOException {
        throw new RuntimeException("Saving of this format is not possible!");
    }

    @Override
    public Collection<String> identify() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("jump3r");
        return names;
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName) {
        return null;
    }

    public static final SidTune load(File file) throws IOException, SidTuneError {
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
            throw new SidTuneError("Bad file extension, expected: .mp3");
        }
        MP3Tune mp3 = new MP3Tune();
        mp3.mp3Filename = file.getAbsolutePath();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            mp3.decoder.read(randomAccessFile);
            String title = mp3.decoder.getTitle();
            mp3.info.infoString.add(title != null ? title : PathUtils.getFilenameWithoutSuffix(file.getName()));
            String interpret = mp3.decoder.getInterpret();
            String albumInterpret = mp3.decoder.getAlbumInterpret();
            String genre = mp3.decoder.getGenre();
            if (interpret != null) {
                mp3.info.infoString.add(interpret);
            } else if (albumInterpret != null) {
                mp3.info.infoString.add(albumInterpret);
            } else {
                mp3.info.infoString.add("<?>");
            }
            String album = mp3.decoder.getAlbum();
            String year = mp3.decoder.getYear();
            if (album != null && year != null) {
                mp3.info.infoString.add(album + " (" + year + ")" + (genre != null ? " / " + genre : ""));
            } else if (album != null) {
                mp3.info.infoString.add(album + (genre != null ? " / " + genre : ""));
            } else {
                mp3.info.infoString.add("<?>");
            }
        }
        return mp3;
    }

    public byte[] getCoverArt() {
        return this.decoder.getImageBytes();
    }

    @Override
    public String getMD5Digest() {
        return null;
    }

    public String getMP3Filename() {
        return this.mp3Filename;
    }

    @Override
    protected long getInitDelay() {
        return 0L;
    }
}

