/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import java.util.Arrays;
import java.util.function.Consumer;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos656x.Palette;
import libsidplay.components.mos656x.Sprite;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public abstract class VIC
extends Bank {
    private static final int ALPHA = -16777216;
    protected static final int FIRST_DMA_LINE = 48;
    protected static final int LAST_DMA_LINE = 247;
    private static final byte COL_D021 = 0;
    private static final byte COL_D022 = 1;
    private static final byte COL_D023 = 2;
    private static final byte COL_CBUF = 4;
    private static final byte COL_CBUF_MC = 5;
    private static final byte COL_VBUF_L = 6;
    private static final byte COL_VBUF_H = 7;
    private static final byte COL_ECM = 8;
    private static final byte COL_NONE = 9;
    private static final byte[] videoModeColorDecoder = new byte[]{0, 0, 4, 4, 0, 1, 2, 5, 6, 6, 7, 7, 0, 7, 6, 4, 8, 8, 4, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
    private int videoModeColorDecoderOffset;
    private final byte[] videoModeColors = new byte[10];
    private int borderColor;
    protected byte phi1Data;
    private int pixelColor;
    private boolean mcFlip;
    private int phi1DataPipe;
    protected int[] combinedLinesCurrent;
    protected final int[] combinedLinesEven = new int[65536];
    protected final int[] combinedLinesOdd = new int[65536];
    protected byte[] linePaletteCurrent;
    protected final byte[] linePaletteEven = new byte[65536];
    protected final byte[] linePaletteOdd = new byte[65536];
    protected final byte[] previousLineDecodedColor = new byte[520];
    protected int previousLineIndex;
    private final PLA pla;
    private static final String credit = "MOS656X (cycle-exact VICII) Emulation:\n\tCopyright (\u00a9) 2009 J\u00f6rg Jahnke <joergjahnke@users.sourceforge.net>\n\tCopyright (\u00a9) 2010 Antti S. Lankila <alankila@bel.fi>\n";
    private static final byte IRQ_RASTER = 1;
    protected static final byte IRQ_SPRITE_BACKGROUND_COLLISION = 2;
    protected static final byte IRQ_SPRITE_SPRITE_COLLISION = 4;
    private static final byte MOS656X_INTERRUPT_LP = 8;
    protected final byte[] registers = new byte[64];
    protected int vc;
    protected int vcBase;
    protected int rc;
    protected boolean isDisplayActive;
    protected boolean areBadLinesEnabled;
    protected int rasterY;
    protected boolean rasterYIRQCondition;
    protected final Sprite[] sprites = new Sprite[8];
    protected final Sprite spriteLinkedListHead = new Sprite(null, -1);
    private final byte[] colorData = new byte[40];
    protected final byte[] videoMatrixData = new byte[40];
    protected boolean showBorderVertical;
    private boolean showBorderMain;
    protected boolean isBadLine;
    protected int videoMatrixBase;
    protected int charMemBase;
    protected int bitmapMemBase;
    private int yscroll;
    protected byte xscroll;
    protected int latchedXscroll;
    private byte irqFlags;
    private byte irqMask;
    protected final int[] pixels = new int[119808];
    protected int nextPixel;
    protected int lineCycle;
    protected boolean graphicsRendering;
    protected final EventScheduler context;
    private byte lpx;
    private byte lpy;
    protected boolean lpTriggered;
    protected boolean startOfFrame;
    protected final int CYCLES_PER_LINE;
    protected final int MAX_RASTERS;
    private boolean lpAsserted;
    private byte latchedColor;
    private byte latchedVmd;
    protected Consumer<int[]> pixelConsumer = pixels -> {};
    protected static final int[] singleColorLUT = new int[16];
    protected int oldGraphicsData;
    private final Event makeDisplayActive = new Event("Activate display due to badline"){

        @Override
        public void event() {
            VIC.this.isDisplayActive = true;
        }
    };
    private final Event badLineStateChange = new Event("Update AEC signal"){

        @Override
        public void event() {
            VIC.this.setBA(!VIC.this.isBadLine);
        }
    };
    protected final Event rasterYIRQEdgeDetector = new Event("RasterY changed"){

        @Override
        public void event() {
            boolean oldRasterYIRQCondition = VIC.this.rasterYIRQCondition;
            boolean bl = VIC.this.rasterYIRQCondition = VIC.this.rasterY == VIC.this.readRasterLineIRQ();
            if (!oldRasterYIRQCondition && VIC.this.rasterYIRQCondition) {
                VIC.this.activateIRQFlag((byte)1);
            }
        }
    };

    public VIC(PLA pla, EventScheduler context, int cpl, int maxRasters) {
        this.pla = pla;
        this.context = context;
        this.CYCLES_PER_LINE = cpl;
        this.MAX_RASTERS = maxRasters;
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i] = new Sprite(this.spriteLinkedListHead, i);
        }
    }

    public void setPixelConsumer(Consumer<int[]> consumer) {
        this.pixelConsumer = consumer;
    }

    private int readSpriteXCoordinate(int spriteNo) {
        return (this.registers[0 + (spriteNo << 1)] & 0xFF) + ((this.registers[16] & 1 << spriteNo) != 0 ? 256 : 0);
    }

    protected boolean readRSEL() {
        return (this.registers[17] & 8) != 0;
    }

    private boolean readCSEL() {
        return (this.registers[22] & 8) != 0;
    }

    protected boolean readDEN() {
        return (this.registers[17] & 0x10) != 0;
    }

    protected int readRasterLineIRQ() {
        return (this.registers[18] & 0xFF) + ((this.registers[17] & 0x80) << 1);
    }

    protected boolean evaluateIsBadLine() {
        return this.areBadLinesEnabled && this.rasterY >= 48 && this.rasterY <= 247 && (this.rasterY & 7) == this.yscroll;
    }

    private void handleIrqState() {
        if ((this.irqFlags & this.irqMask & 0xF) != 0) {
            if ((this.irqFlags & 0x80) == 0) {
                this.interrupt(true);
                this.irqFlags = (byte)(this.irqFlags | 0x80);
            }
        } else if ((this.irqFlags & 0x80) != 0) {
            this.interrupt(false);
            this.irqFlags = (byte)(this.irqFlags & 0x7F);
        }
    }

    private void determineVideoMemoryBaseAddresses() {
        this.videoMatrixBase = (this.registers[24] & 0xF0) << 6;
        this.charMemBase = (this.registers[24] & 0xE) << 10;
        this.bitmapMemBase = (this.registers[24] & 8) << 10;
    }

    protected void activateIRQFlag(byte flag) {
        this.irqFlags = (byte)(this.irqFlags | flag);
        this.handleIrqState();
    }

    protected void doVideoMatrixAccess() {
        int displayCycle = this.lineCycle - 24;
        this.videoMatrixData[displayCycle] = this.vicReadMemoryPHI2(this.videoMatrixBase | this.vc);
        this.colorData[displayCycle] = this.vicReadColorMemoryPHI2(this.vc);
    }

    protected void drawSpritesAndGraphics() {
        int renderCycle = this.lineCycle - 26;
        if (renderCycle < 0) {
            renderCycle += this.CYCLES_PER_LINE;
        }
        int priorityData = 0;
        int graphicsDataBuffer = 0;
        int pixel = 0;
        while (pixel < 32) {
            if (pixel == 16) {
                this.videoModeColorDecoderOffset |= (this.registers[17] & 0x60 | this.registers[22] & 0x10) >> 2;
            }
            if (pixel == this.latchedXscroll) {
                this.videoModeColors[4] = this.latchedColor;
                this.videoModeColors[5] = (byte)(this.latchedColor & 7);
                this.videoModeColors[6] = (byte)(this.latchedVmd & 0xF);
                this.videoModeColors[7] = (byte)(this.latchedVmd >> 4 & 0xF);
                this.videoModeColors[8] = this.videoModeColors[0 + (this.latchedVmd >> 6 & 3)];
                this.mcFlip = true;
                if (renderCycle < 40 && !this.showBorderVertical) {
                    this.latchedVmd = this.isDisplayActive ? this.videoMatrixData[renderCycle] : (byte)0;
                    this.latchedColor = this.isDisplayActive ? this.colorData[renderCycle] : (byte)0;
                    this.phi1DataPipe ^= (this.phi1DataPipe ^ this.phi1Data << 16) & 0xFF0000;
                }
            }
            int end = pixel + 16 & 0xF0;
            if (pixel < this.latchedXscroll) {
                end = Math.min(end, this.latchedXscroll);
            }
            if ((this.videoModeColorDecoderOffset & 4) != 0 && (this.videoModeColorDecoderOffset != 4 || this.videoModeColors[4] >= 8)) {
                while (pixel < end) {
                    if (this.mcFlip) {
                        this.pixelColor = this.phi1DataPipe >>> 30;
                    }
                    this.phi1DataPipe <<= 1;
                    this.mcFlip = !this.mcFlip;
                    graphicsDataBuffer <<= 4;
                    priorityData <<= 4;
                    byte color = videoModeColorDecoder[this.videoModeColorDecoderOffset | this.pixelColor];
                    graphicsDataBuffer |= this.videoModeColors[color];
                    priorityData |= this.pixelColor > 1 ? 15 : 0;
                    pixel += 4;
                }
                continue;
            }
            int bits = end - pixel;
            int mask = -1 >>> -bits;
            int inputBits = this.phi1DataPipe >>> (-bits >> 2);
            this.phi1DataPipe <<= bits >> 2;
            this.mcFlip ^= (bits & 4) != 0;
            int videoModeColorsSIMD = this.videoModeColors[videoModeColorDecoder[this.videoModeColorDecoderOffset]] << 16 | this.videoModeColors[videoModeColorDecoder[this.videoModeColorDecoderOffset | 3]] & 0xFF;
            videoModeColorsSIMD |= videoModeColorsSIMD << 4;
            videoModeColorsSIMD |= videoModeColorsSIMD << 8;
            int priorityBits = singleColorLUT[inputBits];
            int out = videoModeColorsSIMD & priorityBits;
            out |= out >>> 16;
            graphicsDataBuffer <<= bits;
            graphicsDataBuffer |= out & mask;
            priorityData <<= bits;
            priorityData |= priorityBits & mask;
            pixel = end;
        }
        this.videoModeColorDecoderOffset &= (this.registers[17] & 0x60 | this.registers[22] & 0x10) >> 2;
        int opaqueSpritePixels = 0;
        Sprite prev = this.spriteLinkedListHead;
        Sprite current = prev.nextVisibleSprite;
        while (current != null) {
            int spriteForegroundMask = current.calculateNext8Pixels();
            if ((spriteForegroundMask & priorityData) != 0) {
                if (this.registers[31] == 0) {
                    this.activateIRQFlag((byte)2);
                }
                this.registers[31] = (byte)(this.registers[31] | 1 << current.index);
            }
            if ((opaqueSpritePixels & spriteForegroundMask) != 0) {
                if (this.registers[30] == 0) {
                    this.activateIRQFlag((byte)4);
                }
                this.registers[30] = (byte)(this.registers[30] | 1 << current.index);
                for (int pixel2 = 0; pixel2 < 32; pixel2 += 4) {
                    if ((spriteForegroundMask >> pixel2 & 0xF) == 0) continue;
                    int otherSprite = opaqueSpritePixels >> pixel2 & 0xF;
                    if (otherSprite == 0) {
                        opaqueSpritePixels |= (current.index | 8) << pixel2;
                        continue;
                    }
                    this.registers[30] = (byte)(this.registers[30] | 1 << (otherSprite & 7));
                }
            } else {
                opaqueSpritePixels |= current.indexBits & spriteForegroundMask;
            }
            int priorityMask = current.getNextPriorityMask();
            graphicsDataBuffer ^= (current.colorBuffer ^ graphicsDataBuffer) & (spriteForegroundMask &= ~priorityData | priorityMask);
            if (current.consuming) {
                prev = current;
            } else {
                prev.nextVisibleSprite = current.nextVisibleSprite;
            }
            current = current.nextVisibleSprite;
        }
        if (!(renderCycle != 1 && renderCycle != 39 || this.readCSEL())) {
            if (this.showBorderMain) {
                graphicsDataBuffer ^= (graphicsDataBuffer ^ this.borderColor) & 0xFFFFFFF0;
            }
            boolean bl = this.showBorderMain = this.showBorderVertical || renderCycle == 39;
            if (this.showBorderMain) {
                graphicsDataBuffer ^= (graphicsDataBuffer ^ this.borderColor) & 0xF;
            }
        } else {
            if (this.showBorderMain) {
                graphicsDataBuffer = this.borderColor;
            }
            if ((renderCycle == 0 || renderCycle == 40) && this.readCSEL()) {
                this.showBorderMain = this.showBorderVertical || renderCycle == 40;
            }
        }
        for (int j = 0; j < 2; ++j) {
            this.oldGraphicsData |= graphicsDataBuffer >>> 16;
            for (int i = 0; i < 4; ++i) {
                this.oldGraphicsData <<= 4;
                byte lineColor = this.linePaletteCurrent[this.oldGraphicsData >>> 16];
                byte previousLineColor = this.previousLineDecodedColor[this.previousLineIndex];
                this.pixels[this.nextPixel++] = 0xFF000000 | this.combinedLinesCurrent[lineColor & 0xFF | previousLineColor << 8 & 0xFF00];
                this.previousLineDecodedColor[this.previousLineIndex++] = lineColor;
            }
            graphicsDataBuffer <<= 16;
        }
    }

    protected final void spriteCollisionsOnly() {
        int opaqueSpritePixels = 0;
        Sprite prev = this.spriteLinkedListHead;
        Sprite current = prev.nextVisibleSprite;
        while (current != null) {
            int spriteForegroundMask = current.calculateNext8Pixels();
            if ((opaqueSpritePixels & spriteForegroundMask) != 0) {
                if (this.registers[30] == 0) {
                    this.activateIRQFlag((byte)4);
                }
                this.registers[30] = (byte)(this.registers[30] | 1 << current.index);
                for (int pixel = 0; pixel < 32; pixel += 4) {
                    if ((spriteForegroundMask >> pixel & 1) == 0) continue;
                    int otherSprite = opaqueSpritePixels >> pixel & 0xF;
                    if (otherSprite == 0) {
                        opaqueSpritePixels |= (current.index | 8) << pixel;
                        continue;
                    }
                    this.registers[30] = (byte)(this.registers[30] | 1 << (otherSprite & 7));
                }
            } else {
                opaqueSpritePixels |= current.indexBits & spriteForegroundMask;
            }
            if (current.consuming) {
                prev = current;
            } else {
                prev.nextVisibleSprite = current.nextVisibleSprite;
            }
            current = current.nextVisibleSprite;
        }
    }

    public final byte getLastReadByte() {
        return this.phi1Data;
    }

    protected void fetchSpritePointer(int n) {
        Sprite sprite = this.sprites[n];
        sprite.setPointerByte(this.phi1Data);
        int x = this.sprites[n].getX();
        if (x >= 352 + 16 * n && x <= 359 + 16 * n) {
            sprite.event();
        }
        sprite.repeatPixels();
        sprite.setSpriteByte(2, this.vicReadMemoryPHI2(this.sprites[n].getCurrentByteAddress()));
    }

    protected void fetchSpriteData(int n) {
        Sprite sprite = this.sprites[n];
        sprite.setSpriteByte(1, this.phi1Data);
        sprite.setSpriteByte(0, this.vicReadMemoryPHI2(sprite.getCurrentByteAddress()));
        int x = this.sprites[n].getX();
        if (x == 367 + 16 * n) {
            this.sprites[n].event();
        } else {
            this.handleSpriteVisibilityEvent(this.sprites[n]);
        }
    }

    @Override
    public final byte read(int register) {
        int value;
        switch (register &= 0x3F) {
            case 17: {
                value = (byte)(this.registers[register] & 0x7F | (this.rasterY & 0x100) >> 1);
                break;
            }
            case 18: {
                value = (byte)this.rasterY;
                break;
            }
            case 19: {
                value = this.lpx;
                break;
            }
            case 20: {
                value = this.lpy;
                break;
            }
            case 25: {
                value = (byte)(this.irqFlags | 0x70);
                break;
            }
            case 26: {
                value = (byte)(this.irqMask | 0xF0);
                break;
            }
            case 30: 
            case 31: {
                int result = this.registers[register];
                this.registers[register] = 0;
                value = result;
                break;
            }
            default: {
                value = register < 32 ? this.registers[register] : (register < 47 ? (int)((byte)(this.registers[register] | 0xF0)) : -1);
            }
        }
        this.setSpriteDataFromCPU((byte)value);
        return (byte)value;
    }

    protected void lightpenEdgeDetector() {
        if (this.rasterY != this.MAX_RASTERS - 1) {
            if (!this.lpAsserted) {
                return;
            }
            if (this.lpTriggered) {
                return;
            }
            this.lpTriggered = true;
            this.lpx = (byte)this.getCurrentSpriteCycle();
            this.lpx = (byte)(this.lpx + 1);
            if (this.lpx == this.CYCLES_PER_LINE) {
                this.lpx = 0;
            }
            this.lpx = (byte)(this.lpx << 2);
            this.lpx = (byte)(this.lpx + (this.context.phase() == Event.Phase.PHI1 ? 1 : 2));
            this.lpy = (byte)(this.rasterY & 0xFF);
            if (this.lineCycle == 9) {
                this.lpy = (byte)(this.lpy + 1);
            }
            this.activateIRQFlag((byte)8);
        }
    }

    @Override
    public final void write(int register, byte data) {
        this.registers[register &= 0x3F] = data;
        this.setSpriteDataFromCPU(data);
        switch (register) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                int n = register >> 1;
                this.sprites[n].setX(this.readSpriteXCoordinate(n));
                this.handleSpriteVisibilityEvent(this.sprites[n]);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.sprites[register >> 1].setY(data & 0xFF);
                break;
            }
            case 16: {
                for (int i = 0; i < 8; ++i) {
                    this.sprites[i].setX(this.readSpriteXCoordinate(i));
                    this.handleSpriteVisibilityEvent(this.sprites[i]);
                }
                break;
            }
            case 17: {
                this.yscroll = data & 7;
                if (this.rasterY == 48) {
                    this.areBadLinesEnabled |= this.readDEN();
                }
                if (this.lineCycle != 9) {
                    int narrowing;
                    int n = narrowing = this.readRSEL() ? 0 : 4;
                    if (this.rasterY == 51 + narrowing && this.readDEN()) {
                        this.showBorderVertical = false;
                    }
                    if (this.rasterY == 251 - narrowing) {
                        this.showBorderVertical = true;
                    }
                }
                boolean oldBadLine = this.isBadLine;
                this.isBadLine = this.evaluateIsBadLine();
                if (!oldBadLine && this.isBadLine) {
                    this.context.schedule(this.makeDisplayActive, 1L, Event.Phase.PHI2);
                }
                if (this.isBadLine ^ oldBadLine && this.lineCycle > 20 && this.lineCycle < 63) {
                    this.context.schedule(this.badLineStateChange, 0L, Event.Phase.PHI1);
                }
            }
            case 18: {
                this.context.schedule(this.rasterYIRQEdgeDetector, 0L, Event.Phase.PHI1);
                break;
            }
            case 21: {
                for (int i = 0; i < 8; ++i) {
                    this.sprites[i].setEnabled((data & 1 << i) != 0);
                }
                break;
            }
            case 22: {
                this.xscroll = (byte)(this.registers[22] & 7);
                int renderCycle = this.lineCycle - 26;
                if (renderCycle < 0) {
                    renderCycle += this.CYCLES_PER_LINE;
                }
                if (renderCycle == 39) break;
                this.latchedXscroll = this.xscroll << 2;
                break;
            }
            case 23: {
                for (int i = 0; i < 8; ++i) {
                    boolean expandY = (data & 1 << i) != 0;
                    this.sprites[i].setExpandY(expandY, this.lineCycle == 24);
                }
                break;
            }
            case 24: {
                this.determineVideoMemoryBaseAddresses();
                break;
            }
            case 25: {
                this.irqFlags = (byte)(this.irqFlags & (~data & 0xF | 0x80));
                this.handleIrqState();
                break;
            }
            case 26: {
                this.irqMask = (byte)(data & 0xF);
                this.handleIrqState();
                break;
            }
            case 27: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setPriorityOverForegroundGraphics((data & m) == 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 28: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setMulticolor((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 29: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setExpandX((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 32: {
                this.borderColor = (data & 0xF) * 0x11111111;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                int n = register - 33;
                this.videoModeColors[n] = (byte)(data & 0xF);
                break;
            }
            case 37: {
                for (int i = 0; i < 8; ++i) {
                    this.sprites[i].setColor(1, (byte)(data & 0xF));
                }
                int n = register;
                this.registers[n] = (byte)(this.registers[n] | 0xF0);
                break;
            }
            case 38: {
                for (int i = 0; i < 8; ++i) {
                    this.sprites[i].setColor(3, (byte)(data & 0xF));
                }
                int n = register;
                this.registers[n] = (byte)(this.registers[n] | 0xF0);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.sprites[register - 39].setColor(2, (byte)(data & 0xF));
                int n = register;
                this.registers[n] = (byte)(this.registers[n] | 0xF0);
            }
        }
    }

    private void setSpriteDataFromCPU(byte data) {
        if (this.lineCycle >= 4 && this.lineCycle < 20) {
            Sprite damagedSprite = this.sprites[this.lineCycle - 4 >> 1];
            damagedSprite.setSpriteByte((this.lineCycle & 1) == 0 ? 2 : 0, data);
        }
    }

    private int getCurrentSpriteCycle() {
        int spriteCoordinate = this.lineCycle - 23;
        if (spriteCoordinate < 0) {
            spriteCoordinate += this.CYCLES_PER_LINE;
        }
        return spriteCoordinate;
    }

    private void handleSpriteVisibilityEvent(Sprite sprite) {
        this.context.cancel(sprite);
        if (sprite.getX() >> 3 >= this.CYCLES_PER_LINE) {
            return;
        }
        int xpos = sprite.getX() >> 3;
        int count = xpos - this.getCurrentSpriteCycle();
        if (count <= 0) {
            count += this.CYCLES_PER_LINE;
        }
        if (count > this.CYCLES_PER_LINE) {
            count -= this.CYCLES_PER_LINE;
        }
        sprite.setDisplayStart(sprite.getX() & 7);
        this.context.schedule(sprite, count, Event.Phase.PHI2);
    }

    public void reset() {
        this.spriteLinkedListHead.nextVisibleSprite = null;
        for (Sprite s : this.sprites) {
            s.consuming = false;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = -16777216;
        }
        this.graphicsRendering = false;
        Arrays.fill(this.registers, (byte)0);
        this.vc = 0;
        this.vcBase = 0;
        this.rc = 0;
        this.isDisplayActive = false;
        this.areBadLinesEnabled = false;
        this.rasterY = 0;
        this.phi1Data = 0;
        this.showBorderVertical = true;
        this.xscroll = 0;
        this.yscroll = 0;
        this.irqFlags = 0;
        this.irqMask = 0;
        this.nextPixel = 0;
        this.lpx = 0;
        this.lpy = 0;
        this.determineVideoMemoryBaseAddresses();
    }

    public static String credits() {
        return credit;
    }

    public abstract Palette getPalette();

    public abstract void updatePalette();

    public void triggerLightpen() {
        this.lpAsserted = true;
        this.lightpenEdgeDetector();
    }

    public void clearLightpen() {
        this.lpAsserted = false;
    }

    protected void interrupt(boolean b) {
        this.pla.setIRQ(b);
    }

    protected void setBA(boolean b) {
        this.pla.setBA(b);
    }

    protected byte vicReadColorMemoryPHI2(int address) {
        return this.pla.vicReadColorMemoryPHI2(address);
    }

    protected byte vicReadMemoryPHI1(int address) {
        return this.pla.vicReadMemoryPHI1(address);
    }

    protected byte vicReadMemoryPHI2(int address) {
        return this.pla.vicReadMemoryPHI2(address);
    }

    public int getBorderWidth() {
        return 384;
    }

    public abstract int getBorderHeight();

    public byte[] getRegisters() {
        return this.registers;
    }

    static {
        for (int in = 0; in < 16; ++in) {
            int out = 0;
            for (int b = 0; b < 4; ++b) {
                if ((in & 1 << b) == 0) continue;
                out |= 15 << (b << 2);
            }
            VIC.singleColorLUT[in] = out | (0xFFFF ^ out) << 16;
        }
    }

    public static enum Model {
        MOS6567R8,
        MOS6569R1,
        MOS6569R3,
        MOS6569R4,
        MOS6569R5;

    }
}

