/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import libsidplay.common.Event;
import libsidplay.components.mos656x.VIC;

public final class Sprite
extends Event {
    protected final int index;
    private final Sprite linkedListHead;
    protected Sprite nextVisibleSprite;
    private int delayPixels;
    private boolean display;
    boolean consuming;
    private boolean firstMultiColorRead;
    private int lineData;
    private byte pointerByte;
    private int mcBase;
    private int mc;
    private boolean firstYRead;
    private boolean firstXRead;
    private int x;
    private int y;
    private boolean enabled;
    private boolean expandX;
    private boolean expandY;
    private boolean multiColor;
    private boolean priorityOverForegroundGraphics;
    private int priorityMask;
    private boolean multiColorLatched;
    private int prevPixel;
    private boolean expandXLatched;
    private int consumedLineData;
    private boolean allowDisplay;
    private final int[] color = new int[4];
    private int prevPriority;
    protected int colorBuffer;
    protected final int indexBits;

    @Override
    public void event() {
        if (this.consuming) {
            return;
        }
        if (!this.display) {
            return;
        }
        this.consuming = true;
        int delayLength = this.delayPixels;
        if (this.expandX) {
            this.firstXRead = (delayLength & 1) == 0;
            delayLength >>= 1;
        } else {
            this.firstXRead = true;
        }
        this.firstMultiColorRead = this.multiColor ? (delayLength & 1) == 0 : true;
        this.consumedLineData = this.lineData << 8 - delayLength;
        this.lineData = 0;
        this.prevPixel = 0;
        this.prevPriority = 0;
        this.expandXLatched = this.expandX;
        this.multiColorLatched = this.multiColor;
        this.priorityMask = this.priorityOverForegroundGraphics ? -1 : 0;
        Sprite current = this.linkedListHead;
        while (true) {
            if (current.nextVisibleSprite == null || current.nextVisibleSprite.index < this.index) break;
            current = current.nextVisibleSprite;
        }
        this.nextVisibleSprite = current.nextVisibleSprite;
        current.nextVisibleSprite = this;
    }

    public Sprite(Sprite linkedListHead, int index) {
        super("Sprite " + index);
        this.linkedListHead = linkedListHead;
        this.index = index;
        this.indexBits = (8 | index) * 0x11111111;
    }

    protected void setDisplayStart(int delayPixels) {
        this.delayPixels = delayPixels;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final void setPriorityOverForegroundGraphics(boolean priority) {
        if (priority == this.priorityOverForegroundGraphics) {
            return;
        }
        this.priorityOverForegroundGraphics = priority;
        this.priorityMask = this.priorityOverForegroundGraphics ? -16777216 : 0xFFFFFF;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setExpandX(boolean expandX) {
        this.expandX = expandX;
    }

    public final void setExpandY(boolean expandY, boolean crunchCycle) {
        if (this.expandY == expandY) {
            return;
        }
        this.expandY = expandY;
        if (!expandY) {
            this.firstYRead = false;
            if (crunchCycle) {
                this.mc = 0x2A & this.mc & this.mcBase | 0x15 & (this.mc | this.mcBase);
            }
        }
    }

    public final void setMulticolor(boolean multiColor) {
        this.multiColor = multiColor;
    }

    public final void beginDMA() {
        if (this.isDMA()) {
            return;
        }
        this.mcBase = 0;
        this.firstYRead = false;
    }

    public final boolean isDMA() {
        return this.mcBase != 63;
    }

    public void setDisplay(boolean display) {
        if (display && !this.allowDisplay) {
            return;
        }
        this.display = display;
    }

    public final void setPointerByte(byte pointerByte) {
        this.pointerByte = pointerByte;
    }

    public int getCurrentByteAddress() {
        int pointer = (this.pointerByte & 0xFF) << 6;
        int address = pointer | this.mc;
        this.mc = this.mc + 1 & 0x3F;
        return address;
    }

    public final void setSpriteByte(int idx, byte value) {
        this.lineData &= ~(255 << idx * 8);
        this.lineData |= (value & 0xFF) << idx * 8;
    }

    public void initDmaAccess() {
        this.mc = this.mcBase;
    }

    public final void finishDmaAccess() {
        if (!this.firstYRead) {
            this.mcBase = this.mc;
        }
    }

    public final void expandYFlipFlop() {
        if (this.expandY) {
            this.firstYRead = !this.firstYRead;
        }
    }

    public final void setColor(int idx, int val) {
        this.color[idx] = val;
    }

    public final int getColor(int idx) {
        return this.color[idx];
    }

    public final int calculateNext8Pixels() {
        int priorityBuffer = 0;
        if (!(this.expandX || this.expandXLatched || this.multiColor || this.multiColorLatched)) {
            int priorityH = VIC.singleColorLUT[this.consumedLineData >>> 28];
            this.consumedLineData <<= 4;
            int priorityL = VIC.singleColorLUT[this.consumedLineData >>> 28];
            this.consumedLineData <<= 4;
            if (this.consumedLineData == 0) {
                this.consuming = false;
            }
            int priority = priorityH << 16 | priorityL & 0xFFFF;
            this.colorBuffer = this.color[2] * 0x11111111 & priority;
            return priority;
        }
        this.colorBuffer = 0;
        for (int pixelIndex = 0; pixelIndex < 8; ++pixelIndex) {
            switch (pixelIndex) {
                case 6: {
                    if (this.expandXLatched == this.expandX) break;
                    this.expandXLatched = this.expandX;
                    if (this.expandXLatched) break;
                    this.firstXRead = true;
                    break;
                }
                case 7: {
                    if (this.multiColorLatched == this.multiColor) break;
                    this.multiColorLatched = this.multiColor;
                    this.firstMultiColorRead = false;
                }
            }
            if (this.firstXRead) {
                if (this.multiColorLatched) {
                    if (this.firstMultiColorRead) {
                        if (this.consumedLineData == 0) {
                            this.consuming = false;
                        }
                        this.prevPriority = this.consumedLineData >>> 30 != 0 ? 15 : 0;
                        this.prevPixel = this.color[this.consumedLineData >>> 30];
                    }
                    this.firstMultiColorRead = !this.firstMultiColorRead;
                } else {
                    if (this.consumedLineData == 0) {
                        this.consuming = false;
                    }
                    this.prevPriority = this.consumedLineData >> 31 & 0xF;
                    this.prevPixel = this.prevPriority & this.color[2];
                }
                this.consumedLineData <<= 1;
            }
            if (this.expandXLatched) {
                this.firstXRead = !this.firstXRead;
            }
            this.colorBuffer <<= 4;
            this.colorBuffer |= this.prevPixel;
            priorityBuffer <<= 4;
            priorityBuffer |= this.prevPriority;
        }
        return priorityBuffer;
    }

    public void repeatPixels() {
        this.consumedLineData &= 0xC0000000;
        if ((this.consumedLineData & 0x40000000) != 0) {
            this.consumedLineData |= 0x7F800000;
        }
    }

    public int getNextPriorityMask() {
        int mask = this.priorityMask;
        this.priorityMask = (mask >>> 24) * 0x1010101;
        return mask;
    }

    public void setAllowDisplay(boolean allowDisplay) {
        this.allowDisplay = allowDisplay;
    }
}

