/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos656x.Palette;
import libsidplay.components.mos656x.Sprite;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.PLA;

public final class MOS6569
extends VIC {
    private final Palette palette = new Palette();
    private static final int FIRST_DISPLAY_LINE = 15;
    private static final int LAST_DISPLAY_LINE = 300;
    private final Event event = new Event("MOS6569"){

        @Override
        public final void event() throws InterruptedException {
            if (MOS6569.this.lineCycle == MOS6569.this.CYCLES_PER_LINE) {
                MOS6569.this.lineCycle = 0;
            }
            ++MOS6569.this.lineCycle;
            if (MOS6569.this.graphicsRendering && (MOS6569.this.lineCycle >= 23 || MOS6569.this.lineCycle < 71 - MOS6569.this.CYCLES_PER_LINE)) {
                MOS6569.this.drawSpritesAndGraphics();
            } else {
                MOS6569.this.spriteCollisionsOnly();
            }
            MOS6569.this.doPHI1Fetch();
            switch (MOS6569.this.lineCycle) {
                case 1: {
                    for (Sprite sprite : MOS6569.this.sprites) {
                        if (!sprite.isEnabled() || sprite.getY() != (MOS6569.this.rasterY & 0xFF)) continue;
                        sprite.beginDMA();
                    }
                    MOS6569.this.setBA(!MOS6569.this.sprites[0].isDMA());
                    break;
                }
                case 2: {
                    for (Sprite sprite : MOS6569.this.sprites) {
                        if (sprite.isEnabled() && sprite.getY() == (MOS6569.this.rasterY & 0xFF)) {
                            sprite.beginDMA();
                            sprite.setAllowDisplay(true);
                        } else {
                            sprite.setAllowDisplay(false);
                        }
                        sprite.expandYFlipFlop();
                    }
                    MOS6569.this.setBA(!MOS6569.this.sprites[0].isDMA());
                    break;
                }
                case 3: {
                    MOS6569.this.setBA(!MOS6569.this.sprites[0].isDMA() && !MOS6569.this.sprites[1].isDMA());
                    break;
                }
                case 4: {
                    if (MOS6569.this.rc == 7) {
                        MOS6569.this.vcBase = MOS6569.this.vc;
                        MOS6569.this.isDisplayActive = MOS6569.this.isBadLine;
                    }
                    if (MOS6569.this.isDisplayActive) {
                        MOS6569.this.rc = MOS6569.this.rc + 1 & 7;
                    }
                    for (Sprite sprite : MOS6569.this.sprites) {
                        if (sprite.isEnabled() && sprite.getY() == (MOS6569.this.rasterY & 0xFF)) {
                            sprite.setDisplay(true);
                        }
                        if (!sprite.isDMA()) {
                            sprite.setDisplay(false);
                        }
                        sprite.initDmaAccess();
                    }
                    MOS6569.this.fetchSpritePointer(0);
                    break;
                }
                case 5: {
                    MOS6569.this.fetchSpriteData(0);
                    MOS6569.this.setBA(!MOS6569.this.sprites[0].isDMA() && !MOS6569.this.sprites[1].isDMA() && !MOS6569.this.sprites[2].isDMA());
                    break;
                }
                case 6: {
                    MOS6569.this.fetchSpritePointer(1);
                    MOS6569.this.setBA(!MOS6569.this.sprites[1].isDMA() && !MOS6569.this.sprites[2].isDMA());
                    break;
                }
                case 7: {
                    MOS6569.this.fetchSpriteData(1);
                    MOS6569.this.setBA(!MOS6569.this.sprites[1].isDMA() && !MOS6569.this.sprites[2].isDMA() && !MOS6569.this.sprites[3].isDMA());
                    break;
                }
                case 8: {
                    MOS6569.this.fetchSpritePointer(2);
                    MOS6569.this.setBA(!MOS6569.this.sprites[2].isDMA() && !MOS6569.this.sprites[3].isDMA());
                    break;
                }
                case 9: {
                    MOS6569.this.fetchSpriteData(2);
                    MOS6569.this.setBA(!MOS6569.this.sprites[2].isDMA() && !MOS6569.this.sprites[3].isDMA() && !MOS6569.this.sprites[4].isDMA());
                    break;
                }
                case 10: {
                    int narrowing;
                    if (MOS6569.this.rasterY == MOS6569.this.MAX_RASTERS - 1) {
                        MOS6569.this.vcBase = 0;
                        MOS6569.this.startOfFrame = true;
                    } else {
                        ++MOS6569.this.rasterY;
                        MOS6569.this.rasterYIRQEdgeDetector.event();
                    }
                    if (MOS6569.this.rasterY == 48) {
                        MOS6569.this.areBadLinesEnabled = MOS6569.this.readDEN();
                    }
                    MOS6569.this.isBadLine = MOS6569.this.evaluateIsBadLine();
                    MOS6569.this.isDisplayActive |= MOS6569.this.isBadLine;
                    int n = narrowing = MOS6569.this.readRSEL() ? 0 : 4;
                    if (MOS6569.this.rasterY == 51 + narrowing && MOS6569.this.readDEN()) {
                        MOS6569.this.showBorderVertical = false;
                    }
                    if (MOS6569.this.rasterY == 251 - narrowing) {
                        MOS6569.this.showBorderVertical = true;
                    }
                    MOS6569.this.latchedXscroll = MOS6569.this.xscroll << 2;
                    MOS6569.this.oldGraphicsData = 0;
                    MOS6569.this.previousLineIndex = 0;
                    if (MOS6569.this.rasterY == 15) {
                        MOS6569.this.linePaletteCurrent = (MOS6569.this.rasterY & 1) != 0 ? MOS6569.this.linePaletteEven : MOS6569.this.linePaletteOdd;
                        MOS6569.this.combinedLinesCurrent = (MOS6569.this.rasterY & 1) != 0 ? MOS6569.this.combinedLinesEven : MOS6569.this.combinedLinesOdd;
                        MOS6569.this.graphicsRendering = true;
                        MOS6569.this.nextPixel = 0;
                        for (int i = 0; i < MOS6569.this.previousLineDecodedColor.length; ++i) {
                            MOS6569.this.previousLineDecodedColor[i] = MOS6569.this.linePaletteCurrent[0];
                        }
                    }
                    MOS6569.this.linePaletteCurrent = MOS6569.this.linePaletteCurrent == MOS6569.this.linePaletteOdd ? MOS6569.this.linePaletteEven : MOS6569.this.linePaletteOdd;
                    int[] nArray = MOS6569.this.combinedLinesCurrent = MOS6569.this.combinedLinesCurrent == MOS6569.this.combinedLinesOdd ? MOS6569.this.combinedLinesEven : MOS6569.this.combinedLinesOdd;
                    if (MOS6569.this.rasterY == 301) {
                        MOS6569.this.graphicsRendering = false;
                        MOS6569.this.pixelConsumer.accept(MOS6569.this.pixels);
                    }
                    MOS6569.this.fetchSpritePointer(3);
                    MOS6569.this.setBA(!MOS6569.this.sprites[3].isDMA() && !MOS6569.this.sprites[4].isDMA());
                    break;
                }
                case 11: {
                    if (MOS6569.this.startOfFrame) {
                        MOS6569.this.startOfFrame = false;
                        MOS6569.this.rasterY = 0;
                        MOS6569.this.rasterYIRQEdgeDetector.event();
                        MOS6569.this.lpTriggered = false;
                        MOS6569.this.lightpenEdgeDetector();
                    }
                    MOS6569.this.setBA(!MOS6569.this.sprites[3].isDMA() && !MOS6569.this.sprites[4].isDMA() && !MOS6569.this.sprites[5].isDMA());
                    MOS6569.this.fetchSpriteData(3);
                    break;
                }
                case 12: {
                    MOS6569.this.fetchSpritePointer(4);
                    MOS6569.this.setBA(!MOS6569.this.sprites[4].isDMA() && !MOS6569.this.sprites[5].isDMA());
                    break;
                }
                case 13: {
                    MOS6569.this.fetchSpriteData(4);
                    MOS6569.this.setBA(!MOS6569.this.sprites[4].isDMA() && !MOS6569.this.sprites[5].isDMA() && !MOS6569.this.sprites[6].isDMA());
                    break;
                }
                case 14: {
                    MOS6569.this.fetchSpritePointer(5);
                    MOS6569.this.setBA(!MOS6569.this.sprites[5].isDMA() && !MOS6569.this.sprites[6].isDMA());
                    break;
                }
                case 15: {
                    MOS6569.this.fetchSpriteData(5);
                    MOS6569.this.setBA(!MOS6569.this.sprites[5].isDMA() && !MOS6569.this.sprites[6].isDMA() && !MOS6569.this.sprites[7].isDMA());
                    break;
                }
                case 16: {
                    MOS6569.this.fetchSpritePointer(6);
                    MOS6569.this.setBA(!MOS6569.this.sprites[6].isDMA() && !MOS6569.this.sprites[7].isDMA());
                    break;
                }
                case 17: {
                    MOS6569.this.fetchSpriteData(6);
                    break;
                }
                case 18: {
                    MOS6569.this.fetchSpritePointer(7);
                    MOS6569.this.setBA(!MOS6569.this.sprites[7].isDMA());
                    break;
                }
                case 19: {
                    MOS6569.this.fetchSpriteData(7);
                    break;
                }
                case 20: {
                    MOS6569.this.setBA(true);
                    break;
                }
                case 21: {
                    MOS6569.this.setBA(!MOS6569.this.isBadLine);
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    MOS6569.this.vc = MOS6569.this.vcBase;
                    if (!MOS6569.this.isBadLine) break;
                    MOS6569.this.rc = 0;
                    break;
                }
                case 24: {
                    if (!MOS6569.this.isBadLine) break;
                    MOS6569.this.doVideoMatrixAccess();
                    break;
                }
                case 25: {
                    if (MOS6569.this.isBadLine) {
                        MOS6569.this.doVideoMatrixAccess();
                    }
                    for (Sprite sprite : MOS6569.this.sprites) {
                        if (!sprite.isDMA()) continue;
                        sprite.finishDmaAccess();
                    }
                    break;
                }
                default: {
                    if (!MOS6569.this.isBadLine) break;
                    MOS6569.this.doVideoMatrixAccess();
                }
            }
            MOS6569.this.context.schedule(this, 1L);
        }
    };

    public MOS6569(PLA pla, EventScheduler context) {
        super(pla, context, 63, 312);
    }

    protected void doPHI1Fetch() {
        switch (this.lineCycle) {
            case 2: 
            case 3: {
                this.phi1Data = this.vicReadMemoryPHI1(16383);
                return;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                int n = this.lineCycle - 4 >> 1;
                this.phi1Data = this.vicReadMemoryPHI1(this.videoMatrixBase | 0x3F8 | n);
                return;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                int n = this.lineCycle - 5 >> 1;
                if (this.sprites[n].isDMA()) {
                    int address = this.sprites[n].getCurrentByteAddress();
                    this.phi1Data = this.vicReadMemoryPHI1(address);
                } else {
                    this.phi1Data = this.vicReadMemoryPHI1(16383);
                }
                return;
            }
            default: {
                int address = 16383;
                if ((this.registers[17] & 0x40) != 0) {
                    address ^= 0x600;
                }
                if (this.isDisplayActive) {
                    if ((this.registers[17] & 0x20) != 0) {
                        address &= this.bitmapMemBase | this.vc << 3 | this.rc;
                    } else {
                        int n = this.lineCycle == 1 ? 39 : this.lineCycle - 25;
                        address &= this.charMemBase | (this.videoMatrixData[n] & 0xFF) << 3 | this.rc;
                    }
                    this.vc = this.vc + 1 & 0x3FF;
                }
                this.phi1Data = this.vicReadMemoryPHI1(address);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
        }
        int n = this.lineCycle - 20;
        int offset = 255 - this.rasterY * 5 - n & 0xFF;
        this.phi1Data = this.vicReadMemoryPHI1(0x3F00 | offset);
    }

    @Override
    public final void reset() {
        super.reset();
        this.updatePalette();
        this.lineCycle = 9;
        this.context.schedule(this.event, 0L, Event.Phase.PHI1);
    }

    @Override
    public int getBorderHeight() {
        return 285;
    }

    @Override
    public void updatePalette() {
        this.palette.calculatePalette(Palette.buildPaletteVariant(VIC.Model.MOS6567R8));
        System.arraycopy(this.palette.getEvenLines(), 0, this.combinedLinesEven, 0, this.combinedLinesEven.length);
        System.arraycopy(this.palette.getOddLines(), 0, this.combinedLinesOdd, 0, this.combinedLinesOdd.length);
        System.arraycopy(this.palette.getEvenFiltered(), 0, this.linePaletteEven, 0, this.linePaletteEven.length);
        System.arraycopy(this.palette.getOddFiltered(), 0, this.linePaletteOdd, 0, this.linePaletteOdd.length);
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }
}

