/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos656x.Palette;
import libsidplay.components.mos656x.Sprite;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.PLA;

public class MOS6567
extends VIC {
    private final Palette palette = new Palette();
    private static final int FIRST_DISPLAY_LINE = 40;
    private static final int LAST_DISPLAY_LINE = 13;
    private final Event event = new Event("MOS6567"){

        @Override
        public final void event() throws InterruptedException {
            if (MOS6567.this.lineCycle == MOS6567.this.CYCLES_PER_LINE) {
                MOS6567.this.lineCycle = 0;
            }
            ++MOS6567.this.lineCycle;
            if (MOS6567.this.graphicsRendering && (MOS6567.this.lineCycle >= 23 || MOS6567.this.lineCycle < 71 - MOS6567.this.CYCLES_PER_LINE)) {
                MOS6567.this.drawSpritesAndGraphics();
            } else {
                MOS6567.this.spriteCollisionsOnly();
            }
            MOS6567.this.doPHI1Fetch();
            switch (MOS6567.this.lineCycle) {
                case 1: {
                    for (Sprite sprite : MOS6567.this.sprites) {
                        if (sprite.isEnabled() && sprite.getY() == (MOS6567.this.rasterY & 0xFF)) {
                            sprite.beginDMA();
                            sprite.setAllowDisplay(true);
                        } else {
                            sprite.setAllowDisplay(false);
                        }
                        sprite.expandYFlipFlop();
                    }
                    MOS6567.this.setBA(!MOS6567.this.sprites[0].isDMA());
                    break;
                }
                case 2: {
                    MOS6567.this.setBA(!MOS6567.this.sprites[0].isDMA() && !MOS6567.this.sprites[1].isDMA());
                    break;
                }
                case 3: {
                    for (Sprite sprite : MOS6567.this.sprites) {
                        if (sprite.isEnabled() && sprite.getY() == (MOS6567.this.rasterY & 0xFF)) {
                            sprite.setDisplay(true);
                        }
                        if (!sprite.isDMA()) {
                            sprite.setDisplay(false);
                        }
                        sprite.initDmaAccess();
                    }
                    MOS6567.this.fetchSpritePointer(0);
                    break;
                }
                case 4: {
                    if (MOS6567.this.rc == 7) {
                        MOS6567.this.vcBase = MOS6567.this.vc;
                        MOS6567.this.isDisplayActive = MOS6567.this.isBadLine;
                    }
                    if (MOS6567.this.isDisplayActive) {
                        MOS6567.this.rc = MOS6567.this.rc + 1 & 7;
                    }
                    MOS6567.this.fetchSpriteData(0);
                    MOS6567.this.setBA(!MOS6567.this.sprites[0].isDMA() && !MOS6567.this.sprites[1].isDMA() && !MOS6567.this.sprites[2].isDMA());
                    break;
                }
                case 5: {
                    MOS6567.this.fetchSpritePointer(1);
                    MOS6567.this.setBA(!MOS6567.this.sprites[1].isDMA() && !MOS6567.this.sprites[2].isDMA());
                    break;
                }
                case 6: {
                    MOS6567.this.fetchSpriteData(1);
                    MOS6567.this.setBA(!MOS6567.this.sprites[1].isDMA() && !MOS6567.this.sprites[2].isDMA() && !MOS6567.this.sprites[3].isDMA());
                    break;
                }
                case 7: {
                    MOS6567.this.fetchSpritePointer(2);
                    MOS6567.this.setBA(!MOS6567.this.sprites[2].isDMA() && !MOS6567.this.sprites[3].isDMA());
                    break;
                }
                case 8: {
                    MOS6567.this.fetchSpriteData(2);
                    MOS6567.this.setBA(!MOS6567.this.sprites[2].isDMA() && !MOS6567.this.sprites[3].isDMA() && !MOS6567.this.sprites[4].isDMA());
                    break;
                }
                case 9: {
                    MOS6567.this.fetchSpritePointer(3);
                    MOS6567.this.setBA(!MOS6567.this.sprites[3].isDMA() && !MOS6567.this.sprites[4].isDMA());
                    break;
                }
                case 10: {
                    int narrowing;
                    if (MOS6567.this.rasterY == MOS6567.this.MAX_RASTERS - 1) {
                        MOS6567.this.vcBase = 0;
                        MOS6567.this.startOfFrame = true;
                    } else {
                        ++MOS6567.this.rasterY;
                        MOS6567.this.rasterYIRQEdgeDetector.event();
                    }
                    if (MOS6567.this.rasterY == 48) {
                        MOS6567.this.areBadLinesEnabled = MOS6567.this.readDEN();
                    }
                    MOS6567.this.isBadLine = MOS6567.this.evaluateIsBadLine();
                    MOS6567.this.isDisplayActive |= MOS6567.this.isBadLine;
                    int n = narrowing = MOS6567.this.readRSEL() ? 0 : 4;
                    if (MOS6567.this.rasterY == 51 + narrowing && MOS6567.this.readDEN()) {
                        MOS6567.this.showBorderVertical = false;
                    }
                    if (MOS6567.this.rasterY == 251 - narrowing) {
                        MOS6567.this.showBorderVertical = true;
                    }
                    MOS6567.this.latchedXscroll = MOS6567.this.xscroll << 2;
                    MOS6567.this.oldGraphicsData = 0;
                    MOS6567.this.previousLineIndex = 0;
                    if (MOS6567.this.rasterY == 40) {
                        MOS6567.this.linePaletteCurrent = (MOS6567.this.rasterY & 1) != 0 ? MOS6567.this.linePaletteEven : MOS6567.this.linePaletteOdd;
                        MOS6567.this.combinedLinesCurrent = (MOS6567.this.rasterY & 1) != 0 ? MOS6567.this.combinedLinesEven : MOS6567.this.combinedLinesOdd;
                        MOS6567.this.graphicsRendering = true;
                        MOS6567.this.nextPixel = 0;
                        for (int i = 0; i < MOS6567.this.previousLineDecodedColor.length; ++i) {
                            MOS6567.this.previousLineDecodedColor[i] = MOS6567.this.linePaletteCurrent[0];
                        }
                    }
                    MOS6567.this.linePaletteCurrent = MOS6567.this.linePaletteCurrent == MOS6567.this.linePaletteOdd ? MOS6567.this.linePaletteEven : MOS6567.this.linePaletteOdd;
                    int[] nArray = MOS6567.this.combinedLinesCurrent = MOS6567.this.combinedLinesCurrent == MOS6567.this.combinedLinesOdd ? MOS6567.this.combinedLinesEven : MOS6567.this.combinedLinesOdd;
                    if (MOS6567.this.rasterY == 14) {
                        MOS6567.this.graphicsRendering = false;
                        MOS6567.this.pixelConsumer.accept(MOS6567.this.pixels);
                    }
                    MOS6567.this.setBA(!MOS6567.this.sprites[3].isDMA() && !MOS6567.this.sprites[4].isDMA() && !MOS6567.this.sprites[5].isDMA());
                    MOS6567.this.fetchSpriteData(3);
                    break;
                }
                case 11: {
                    if (MOS6567.this.startOfFrame) {
                        MOS6567.this.startOfFrame = false;
                        MOS6567.this.rasterY = 0;
                        MOS6567.this.rasterYIRQEdgeDetector.event();
                        MOS6567.this.lpTriggered = false;
                        MOS6567.this.lightpenEdgeDetector();
                    }
                    MOS6567.this.fetchSpritePointer(4);
                    MOS6567.this.setBA(!MOS6567.this.sprites[4].isDMA() && !MOS6567.this.sprites[5].isDMA());
                    break;
                }
                case 12: {
                    MOS6567.this.fetchSpriteData(4);
                    MOS6567.this.setBA(!MOS6567.this.sprites[4].isDMA() && !MOS6567.this.sprites[5].isDMA() && !MOS6567.this.sprites[6].isDMA());
                    break;
                }
                case 13: {
                    MOS6567.this.fetchSpritePointer(5);
                    MOS6567.this.setBA(!MOS6567.this.sprites[5].isDMA() && !MOS6567.this.sprites[6].isDMA());
                    break;
                }
                case 14: {
                    MOS6567.this.fetchSpriteData(5);
                    MOS6567.this.setBA(!MOS6567.this.sprites[5].isDMA() && !MOS6567.this.sprites[6].isDMA() && !MOS6567.this.sprites[7].isDMA());
                    break;
                }
                case 15: {
                    MOS6567.this.fetchSpritePointer(6);
                    MOS6567.this.setBA(!MOS6567.this.sprites[6].isDMA() && !MOS6567.this.sprites[7].isDMA());
                    break;
                }
                case 16: {
                    MOS6567.this.fetchSpriteData(6);
                    break;
                }
                case 17: {
                    MOS6567.this.fetchSpritePointer(7);
                    MOS6567.this.setBA(!MOS6567.this.sprites[7].isDMA());
                    break;
                }
                case 18: {
                    MOS6567.this.fetchSpriteData(7);
                    break;
                }
                case 19: {
                    MOS6567.this.setBA(true);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    MOS6567.this.setBA(!MOS6567.this.isBadLine);
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    MOS6567.this.vc = MOS6567.this.vcBase;
                    if (!MOS6567.this.isBadLine) break;
                    MOS6567.this.rc = 0;
                    break;
                }
                case 24: {
                    if (!MOS6567.this.isBadLine) break;
                    MOS6567.this.doVideoMatrixAccess();
                    break;
                }
                case 25: {
                    if (MOS6567.this.isBadLine) {
                        MOS6567.this.doVideoMatrixAccess();
                    }
                    for (Sprite sprite : MOS6567.this.sprites) {
                        if (!sprite.isDMA()) continue;
                        sprite.finishDmaAccess();
                    }
                    break;
                }
                default: {
                    if (!MOS6567.this.isBadLine) break;
                    MOS6567.this.doVideoMatrixAccess();
                    break;
                }
                case 64: {
                    MOS6567.this.setBA(true);
                    break;
                }
                case 65: {
                    for (Sprite sprite : MOS6567.this.sprites) {
                        if (!sprite.isEnabled() || sprite.getY() != (MOS6567.this.rasterY & 0xFF)) continue;
                        sprite.beginDMA();
                    }
                    MOS6567.this.setBA(!MOS6567.this.sprites[0].isDMA());
                }
            }
            MOS6567.this.context.schedule(this, 1L);
        }
    };

    public MOS6567(PLA pla, EventScheduler context) {
        super(pla, context, 65, 263);
    }

    protected void doPHI1Fetch() {
        switch (this.lineCycle) {
            case 1: 
            case 2: 
            case 19: 
            case 65: {
                this.phi1Data = this.vicReadMemoryPHI1(16383);
                return;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                int n = this.lineCycle - 3 >> 1;
                this.phi1Data = this.vicReadMemoryPHI1(this.videoMatrixBase | 0x3F8 | n);
                return;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                int n = this.lineCycle - 4 >> 1;
                if (this.sprites[n].isDMA()) {
                    int address = this.sprites[n].getCurrentByteAddress();
                    this.phi1Data = this.vicReadMemoryPHI1(address);
                } else {
                    this.phi1Data = this.vicReadMemoryPHI1(16383);
                }
                return;
            }
            default: {
                int n = this.lineCycle - 25;
                int address = 16383;
                if ((this.registers[17] & 0x40) != 0) {
                    address ^= 0x600;
                }
                if (this.isDisplayActive) {
                    address = (this.registers[17] & 0x20) != 0 ? (address &= this.bitmapMemBase | this.vc << 3 | this.rc) : (address &= this.charMemBase | (this.videoMatrixData[n] & 0xFF) << 3 | this.rc);
                    this.vc = this.vc + 1 & 0x3FF;
                }
                this.phi1Data = this.vicReadMemoryPHI1(address);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
        }
        int n = this.lineCycle - 20;
        int offset = 255 - this.rasterY * 5 - n & 0xFF;
        this.phi1Data = this.vicReadMemoryPHI1(0x3F00 | offset);
    }

    @Override
    public final void reset() {
        super.reset();
        this.updatePalette();
        this.lineCycle = 9;
        this.context.schedule(this.event, 0L, Event.Phase.PHI1);
    }

    @Override
    public int getBorderHeight() {
        return -27 + this.MAX_RASTERS;
    }

    @Override
    public void updatePalette() {
        this.palette.calculatePalette(Palette.buildPaletteVariant(VIC.Model.MOS6567R8));
        System.arraycopy(this.palette.getEvenLines(), 0, this.combinedLinesEven, 0, this.combinedLinesEven.length);
        System.arraycopy(this.palette.getOddLines(), 0, this.combinedLinesOdd, 0, this.combinedLinesOdd.length);
        System.arraycopy(this.palette.getEvenFiltered(), 0, this.linePaletteEven, 0, this.linePaletteEven.length);
        System.arraycopy(this.palette.getOddFiltered(), 0, this.linePaletteOdd, 0, this.linePaletteOdd.length);
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }
}

