/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class GeoRAM
extends Cartridge {
    protected byte dffe;
    protected byte dfff;
    protected byte[] ram;
    protected final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return GeoRAM.this.ram[GeoRAM.this.dfff << 14 | GeoRAM.this.dffe << 8 | address & 0xFF];
        }

        @Override
        public void write(int address, byte value) {
            GeoRAM.this.ram[GeoRAM.this.dfff << 14 | GeoRAM.this.dffe << 8 | address & 0xFF] = value;
        }
    };
    protected final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            return GeoRAM.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            switch (address & 0xFF) {
                case 255: {
                    GeoRAM.this.dfff = (byte)(value & (GeoRAM.this.ram.length >> 14) - 1);
                    break;
                }
                case 254: {
                    GeoRAM.this.dffe = (byte)(value & 0x3F);
                    break;
                }
            }
        }
    };

    public GeoRAM(DataInputStream dis, PLA pla, int sizeKB) throws IOException {
        super(pla);
        assert (sizeKB == 0 || sizeKB == 64 || sizeKB == 128 || sizeKB == 256 || sizeKB == 512 || sizeKB == 1024 || sizeKB == 2048);
        if (sizeKB == 0) {
            sizeKB = 2048;
        }
        this.ram = new byte[sizeKB << 10];
        Arrays.fill(this.ram, (byte)0);
        if (dis != null) {
            try {
                dis.readFully(this.ram);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.dffe = 0;
        this.dfff = 0;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " (" + (this.ram.length >> 10) + " KB)";
    }
}

