/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import libsidplay.common.Event;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.cart.supported.GeoRAM;
import libsidplay.components.cart.supported.REU;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Cartridge {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    public final PLA pla;
    private boolean nmiState;
    private boolean irqState;

    protected Cartridge(PLA pla) {
        this.pla = pla;
    }

    public Bank getRoml() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getRomh() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getUltimaxMemory() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO1() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO2() {
        return this.pla.getDisconnectedBusBank();
    }

    public static final Cartridge create(PLA pla, CartridgeType cartType, int sizeKB) throws IOException {
        switch (cartType) {
            case GEORAM: {
                return new GeoRAM(null, pla, sizeKB);
            }
            case REU: {
                return new REU(null, pla, sizeKB);
            }
        }
        throw new RuntimeException("Cartridge is unsupported");
    }

    /*
     * Exception decompiling
     */
    public static Cartridge read(PLA pla, CartridgeType cartType, File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[SWITCH], 36[CASE]], but top level block is 31[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
    }

    public static Cartridge nullCartridge(PLA pla) {
        return new Cartridge(pla){

            @Override
            public String toString() {
                return "";
            }
        };
    }

    public void reset() {
        this.nmiState = false;
        this.irqState = false;
    }

    public final void freeze() {
        this.pla.getCPU().getEventScheduler().scheduleThreadSafe(new Event("Freeze TS"){

            @Override
            public void event() {
                Cartridge.this.doFreeze();
            }
        });
    }

    protected void doFreeze() {
    }

    public void changedNMI(boolean state) {
    }

    public void changedIRQ(boolean state) {
    }

    public void changedBA(boolean state) {
    }

    public void setNMI(boolean state) {
        if (state ^ this.nmiState) {
            this.pla.setNMI(state);
            this.nmiState = state;
        }
    }

    public void setIRQ(boolean state) {
        if (state ^ this.irqState) {
            this.pla.setIRQ(state);
            this.irqState = state;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static enum CRTType {
        NORMAL,
        ACTION_REPLAY,
        KCS_POWER_CARTRIDGE,
        FINAL_CARTRIDGE_III,
        SIMONS_BASIC,
        OCEAN_TYPE_1,
        EXPERT_CARTRIDGE,
        FUN_PLAY__POWER_PLAY,
        SUPER_GAMES,
        ATOMIC_POWER,
        EPYX_FASTLOAD,
        WESTERMANN_LEARNING,
        REX_UTILITY,
        FINAL_CARTRIDGE_I,
        MAGIC_FORMEL,
        C64_GAME_SYSTEM__SYSTEM_3,
        WARPSPEED,
        DINAMIC,
        ZAXXON__SUPER_ZAXXON,
        MAGIC_DESK__DOMARK__HES_AUSTRALIA,
        SUPER_SNAPSHOT_5,
        COMAL_80,
        STRUCTURED_BASIC,
        ROSS,
        DELA_EP64,
        DELA_EP7X8,
        DELA_EP256,
        REX_EP256,
        MIKRO_ASSEMBLER,
        RESERVED,
        ACTION_REPLAY_4,
        STARDOS,
        EASYFLASH;


        public static CRTType getType(byte[] header) {
            if (!new String(header, 0, 16, ISO88591).equals("C64 CARTRIDGE   ")) {
                throw new RuntimeException("File is not a .CRT file");
            }
            return CRTType.values()[(header[22] & 0xFF) << 8 | header[23] & 0xFF];
        }
    }
}

