/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.GCR;

public class G64
extends DiskImage {
    static final String IMAGE_HEADER = "GCR-1541";
    private static final int BEGIN_TRACK_DATA_OFFSETS = 12;
    private int[] speedZoneMap = new int[554960];

    public G64(GCR gcr, String fileName, RandomAccessFile fd, boolean readOnly) {
        super(gcr, fileName, fd, readOnly);
    }

    @Override
    protected void attach() throws IOException {
        byte[] header = new byte[IMAGE_HEADER.length()];
        this.fd.readFully(header);
        if (!new String(header, "ISO-8859-1").equals(IMAGE_HEADER)) {
            throw new IOException(String.format("GCR image is not GCR-1541 format.", new Object[0]));
        }
        int version = this.fd.read();
        if (version != 0) {
            throw new IOException(String.format("Unknown GCR image version %d.", version));
        }
        this.tracks = this.fd.read() >> 1;
        if (this.tracks < 35 || this.tracks > 42) {
            throw new IOException(String.format("Invalid number of tracks (%d).", this.tracks));
        }
        int rawTrackSize = this.fd.read() + (this.fd.read() << 8);
        if (rawTrackSize != 7928) {
            throw new IOException(String.format("Unexpected GCR raw track size: %s (expected: %s)", rawTrackSize, 7928));
        }
        int[] trackOffsets = new int[84];
        this.readIntLittleEndian(this.fd, trackOffsets, this.tracks << 1);
        int[] speedZoneOffsets = new int[84];
        this.readIntLittleEndian(this.fd, speedZoneOffsets, this.tracks << 1);
        int trackDataPos = 0;
        int zoneDataPos = 0;
        for (int track = 1; track <= 42; ++track) {
            this.gcr.setTrackData(trackDataPos, 7928, (byte)-1);
            Arrays.fill(this.speedZoneMap, zoneDataPos, zoneDataPos + 1982, 0);
            this.trackSize[track - 1] = DiskImage.RAW_TRACK_SIZE[SPEED_MAP_1541[track - 1]];
            if (track <= this.tracks && trackOffsets[track - 1 << 1] != 0) {
                long gcrTrackDataStart = trackOffsets[track - 1 << 1];
                this.fd.seek(gcrTrackDataStart);
                int trackLen = this.fd.read() + (this.fd.read() << 8);
                if (trackLen > 7928) {
                    throw new IOException(String.format("Track field length %d is not supported.", trackLen));
                }
                this.trackSize[track - 1] = trackLen;
                this.fd.seek(gcrTrackDataStart + 2L);
                byte[] trackBytes = new byte[trackLen];
                this.fd.readFully(trackBytes);
                this.gcr.setTrackData(trackBytes, trackDataPos, trackLen);
                if (speedZoneOffsets[track - 1 << 1] <= 3) {
                    Arrays.fill(this.speedZoneMap, zoneDataPos, zoneDataPos + 7928, speedZoneOffsets[track - 1 << 1]);
                } else {
                    long speedZoneOffsetStart = speedZoneOffsets[track - 1 << 1];
                    byte[] speedData = new byte[1982];
                    this.fd.seek(speedZoneOffsetStart);
                    this.fd.readFully(speedData, 0, trackLen + 3 >> 2);
                    for (int i = 0; i < speedData.length; ++i) {
                        this.speedZoneMap[zoneDataPos + (i << 2) + 3] = speedData[i] & 3;
                        this.speedZoneMap[zoneDataPos + (i << 2) + 2] = (speedData[i] & 0xFF) >> 2 & 3;
                        this.speedZoneMap[zoneDataPos + (i << 2) + 1] = (speedData[i] & 0xFF) >> 4 & 3;
                        this.speedZoneMap[zoneDataPos + (i << 2)] = (speedData[i] & 0xFF) >> 6 & 3;
                    }
                }
            }
            trackDataPos += 7928;
            zoneDataPos += 7928;
        }
    }

    @Override
    public void gcrDataWriteback(int track) throws IOException {
        int gap;
        int[] trackOffsets = new int[84];
        this.fd.seek(12L);
        this.readIntLittleEndian(this.fd, trackOffsets, this.tracks << 1);
        int[] speedZoneOffsets = new int[84];
        this.fd.seek(12 + this.tracks << 3);
        this.readIntLittleEndian(this.fd, speedZoneOffsets, this.tracks << 1);
        int gcrTrackDataStart = trackOffsets[track - 1 << 1];
        if (gcrTrackDataStart == 0) {
            if (track > this.tracks && this.extendImageListener != null && !this.extendImageListener.isAllowed()) {
                return;
            }
            this.fd.seek(this.fd.length());
            trackOffsets[track - 1 << 1] = 0;
            gcrTrackDataStart = 0;
        }
        if ((gap = 7928 - this.trackSize[track - 1]) > 0) {
            this.gcr.setTrackData((track - 1) * 7928, this.trackSize[track - 1] + gap, (byte)0);
        }
        this.fd.seek(gcrTrackDataStart);
        this.fd.write(this.trackSize[track - 1]);
        this.fd.write(this.trackSize[track - 1] >> 8);
        this.fd.seek(gcrTrackDataStart + 2);
        this.fd.write(this.gcr.getTrackData((track - 1) * 7928, 7928));
        if (this.speedZoneMap != null) {
            for (int i = 0; i < 7928; ++i) {
                if (this.speedZoneMap[(track - 1) * 7928] == this.speedZoneMap[(track - 1) * 7928 + i]) continue;
                System.err.printf("Saving different speed zones is not supported yet (track=%d).", track);
                return;
            }
            if (speedZoneOffsets[track - 1 << 1] > 3) {
                System.err.printf("Adding new speed zones is not supported yet (track=%d).", track);
                return;
            }
            gcrTrackDataStart = 12 + (this.tracks << 3) + (track - 1 << 3);
            this.fd.seek(gcrTrackDataStart);
            this.fd.writeInt(this.flip(speedZoneOffsets[track - 1 << 1]));
        }
    }

    private int flip(int value) {
        return value >> 24 & 0xFF | value >> 8 & 0xFF00 | value << 8 & 0xFF0000 | value << 24;
    }

    private void readIntLittleEndian(RandomAccessFile fd, int[] buf, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            buf[i] = this.flip(fd.readInt());
        }
    }
}

