/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.c1541.VIA6522BC;
import libsidplay.components.c1541.VIA6522DC;
import libsidplay.components.iec.IECBus;
import libsidplay.components.mos6510.MOS6510;

public final class C1541 {
    private static final String C1541_ROM = "/libsidplay/roms/c1541.bin";
    private static final String C1541_II_ROM = "/libsidplay/roms/c1541-2.bin";
    private static final int ROM_SIZE = 16384;
    private static final byte[] C1541 = new byte[16384];
    private static final byte[] C1541_II = new byte[16384];
    private static final int RAM_SIZE = 2048;
    private static final int RAM_EXP_SIZE = 8192;
    private static final int EXP_RAM_BANKS = 5;
    private boolean powerOn;
    private final int id;
    private FloppyType floppyType;
    private final EventScheduler context = new EventScheduler();
    private final MOS6510 cpu;
    private final VIA6522BC viaBc;
    private final VIA6522DC viaDc;
    private final byte[] ram = new byte[2048];
    private final byte[] rom = new byte[16384];
    private byte[] customC1541Rom;
    private final byte[][] ramExpand = new byte[5][];
    private final boolean[] ramExpEnabled = new boolean[5];
    private int irqCount;
    private String diskName;

    public C1541(IECBus iecBus, int deviceID, FloppyType type) {
        this.id = deviceID;
        this.cpu = new MOS6510(this.context);
        this.viaBc = new VIA6522BC(deviceID, iecBus){

            @Override
            protected long cpuClk() {
                return C1541.this.getEventScheduler().getTime(Event.Phase.PHI2);
            }

            @Override
            protected void alarmSet(Event alarm, long ti) {
                C1541.this.getEventScheduler().scheduleAbsolute(alarm, ti, Event.Phase.PHI1);
            }

            @Override
            protected void alarmUnset(Event alarm) {
                C1541.this.getEventScheduler().cancel(alarm);
            }

            @Override
            protected void setIRQ(boolean state) {
                C1541.this.signalIRQ(state);
            }
        };
        this.viaDc = new VIA6522DC(deviceID, this.cpu){

            @Override
            protected long cpuClk() {
                return C1541.this.getEventScheduler().getTime(Event.Phase.PHI2);
            }

            @Override
            protected void alarmSet(Event alarm, long ti) {
                C1541.this.getEventScheduler().scheduleAbsolute(alarm, ti, Event.Phase.PHI1);
            }

            @Override
            protected void alarmUnset(Event alarm) {
                C1541.this.getEventScheduler().cancel(alarm);
            }

            @Override
            protected void setIRQ(boolean state) {
                C1541.this.signalIRQ(state);
            }

            @Override
            public void diskAttachedDetached(String imageName, boolean attached) {
                C1541.this.setDiskName(attached ? imageName : null);
            }
        };
        this.cpu.setVFlagHandler(flagV -> {
            this.viaDc.rotateDisk();
            return flagV;
        });
        this.cpu.setMemoryHandler(address -> {
            int ramExpSelect = address >> 13;
            if (ramExpSelect > 0 && ramExpSelect <= 5 && this.getRAMExpEnabled()[ramExpSelect - 1]) {
                return this.getRAMExpand()[ramExpSelect - 1][address & 0x1FFF];
            }
            if (address < 32768) {
                int chip = address & 0x1C00;
                if (chip < 2048) {
                    return this.getRAM()[address & 0x7FF];
                }
                if (chip == 6144) {
                    return this.getBusController().read((int)(address & 0xF));
                }
                if (chip == 7168) {
                    return this.getDiskController().read((int)(address & 0xF));
                }
                return (byte)-1;
            }
            return this.getROM()[address & 0x3FFF];
        }, (address, data) -> {
            int ramExpSelect = address >> 13;
            if (ramExpSelect > 0 && ramExpSelect <= 5 && this.getRAMExpEnabled()[ramExpSelect - 1]) {
                this.getRAMExpand()[ramExpSelect - 1][address.intValue() & 0x1FFF] = data;
            }
            if (address < 32768) {
                int chip = address & 0x1C00;
                if (chip < 2048) {
                    this.getRAM()[address.intValue() & 0x7FF] = data;
                }
                if (chip == 6144) {
                    this.getBusController().write((int)(address & 0xF), (byte)data);
                }
                if (chip == 7168) {
                    this.getDiskController().write((int)(address & 0xF), (byte)data);
                }
            }
        });
        this.setFloppyType(type);
        for (int i = 0; i < 5; ++i) {
            this.ramExpand[i] = new byte[8192];
        }
    }

    public final EventScheduler getEventScheduler() {
        return this.context;
    }

    public final MOS6510 getCPU() {
        return this.cpu;
    }

    public final VIA6522BC getBusController() {
        return this.viaBc;
    }

    public final VIA6522DC getDiskController() {
        return this.viaDc;
    }

    public final byte[] getRAM() {
        return this.ram;
    }

    public final byte[] getROM() {
        return this.rom;
    }

    public final boolean[] getRAMExpEnabled() {
        return this.ramExpEnabled;
    }

    public final byte[][] getRAMExpand() {
        return this.ramExpand;
    }

    public final int getID() {
        return this.id;
    }

    public final void setPowerOn(boolean on) {
        this.powerOn = on;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public final void setFloppyType(FloppyType type) {
        this.floppyType = type;
        this.setRom();
    }

    public final void setRamExpansion(int select, boolean expand) {
        assert (select < 5);
        this.ramExpEnabled[select] = expand;
    }

    protected void signalIRQ(boolean state) {
        if (state) {
            if (this.irqCount++ == 0) {
                this.cpu.triggerIRQ();
            }
        } else if (--this.irqCount == 0) {
            this.cpu.clearIRQ();
        }
    }

    public final void reset() {
        this.context.reset();
        this.cpu.triggerRST();
        this.viaBc.reset();
        this.viaDc.reset();
        this.irqCount = 0;
        Arrays.fill(this.ram, (byte)0);
        for (int i = 0; i < 5; ++i) {
            Arrays.fill(this.ramExpand[i], (byte)0);
        }
    }

    private void setRom() {
        if (this.customC1541Rom != null) {
            System.arraycopy(this.customC1541Rom, 0, this.rom, 0, this.customC1541Rom.length);
        } else {
            switch (this.floppyType) {
                case C1541: {
                    System.arraycopy(C1541, 0, this.rom, 0, C1541.length);
                    break;
                }
                case C1541_II: {
                    System.arraycopy(C1541_II, 0, this.rom, 0, C1541_II.length);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported floppy type: " + (Object)((Object)this.floppyType));
                }
            }
        }
    }

    public final void setCustomKernalRom(byte[] c1541Rom) {
        this.customC1541Rom = c1541Rom;
    }

    public final FloppyStatus getStatus() {
        if (this.powerOn) {
            if (this.viaDc.isLEDOn()) {
                return FloppyStatus.LOAD;
            }
            return FloppyStatus.ON;
        }
        return FloppyStatus.OFF;
    }

    public FloppyType getFloppyType() {
        return this.floppyType;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    static {
        try (DataInputStream isC1541 = new DataInputStream(C1541.class.getResourceAsStream(C1541_ROM));
             DataInputStream isC1541_II = new DataInputStream(C1541.class.getResourceAsStream(C1541_II_ROM));){
            isC1541.readFully(C1541);
            isC1541_II.readFully(C1541_II);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static enum FloppyType {
        C1541,
        C1541_II;

    }

    public static enum FloppyStatus {
        OFF,
        ON,
        LOAD;

    }
}

