/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public enum ChipModel {
    AUTO,
    MOS6581,
    MOS8580;


    public static ChipModel getChipModel(IEmulationSection emulation, SidTune tune, int sidNum) {
        ChipModel defaultSidModel;
        SidTune.Model tuneSidModel;
        ChipModel forcedChipModel;
        switch (sidNum) {
            case 0: {
                forcedChipModel = emulation.getUserSidModel();
                tuneSidModel = tune != null ? tune.getInfo().getSIDModel(0) : null;
                defaultSidModel = emulation.getDefaultSidModel();
                break;
            }
            case 1: {
                forcedChipModel = emulation.getStereoSidModel();
                tuneSidModel = tune != null ? tune.getInfo().getSIDModel(1) : null;
                defaultSidModel = ChipModel.getChipModel(emulation, tune, 0);
                break;
            }
            case 2: {
                forcedChipModel = emulation.getThirdSIDModel();
                tuneSidModel = tune != null ? tune.getInfo().getSIDModel(2) : null;
                defaultSidModel = ChipModel.getChipModel(emulation, tune, 0);
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
        if (forcedChipModel != AUTO) {
            return forcedChipModel;
        }
        if (tuneSidModel == null) {
            return defaultSidModel;
        }
        switch (tuneSidModel) {
            case MOS6581: 
            case MOS8580: {
                return tuneSidModel.asChipModel();
            }
        }
        return defaultSidModel;
    }
}

