/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public enum CPUClock {
    PAL(985248.4, 50.0),
    NTSC(1022727.14, 60.0);

    private final double frequency;
    private final double refresh;

    private CPUClock(double frequency, double refresh) {
        this.frequency = frequency;
        this.refresh = refresh;
    }

    public double getCpuFrequency() {
        return this.frequency;
    }

    public double getCyclesPerFrame() {
        return this.frequency / this.refresh;
    }

    public double getRefresh() {
        return this.refresh;
    }

    public static CPUClock getCPUClock(IEmulationSection emulation, SidTune tune) {
        CPUClock forcedCPUClock = emulation.getUserClockSpeed();
        SidTune.Clock tuneCPUClock = tune != null ? tune.getInfo().getClockSpeed() : null;
        CPUClock defaultCPUClock = emulation.getDefaultClockSpeed();
        if (forcedCPUClock != null) {
            return forcedCPUClock;
        }
        if (tuneCPUClock == null) {
            return defaultCPUClock;
        }
        switch (tuneCPUClock) {
            case PAL: 
            case NTSC: {
                return tuneCPUClock.asCPUClock();
            }
        }
        return defaultCPUClock;
    }
}

