/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import libsidplay.C64;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.C1541Runner;
import libsidplay.components.c1541.DisconnectedParallelCable;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.c1541.SameThreadC1541Runner;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.iec.IECBus;
import libsidplay.components.iec.SerialIECDevice;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.printer.mps803.MPS803;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConfig;
import libsidplay.config.ISidPlay2Section;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.prg2tap.PRG2TAP;
import libsidutils.prg2tap.PRG2TAPProgram;

public class HardwareEnsemble {
    private static final String JIFFYDOS_C64_ROM = "/libsidplay/roms/JiffyDOS C64 Kernal 6.01.bin";
    private static final String JIFFYDOS_C1541_ROM = "/libsidplay/roms/JiffyDOS 1541 5.0.bin";
    private static final int JIFFYDOS_C64_ROM_SIZE = 8192;
    private static final int JIFFYDOS_C1541_ROM_SIZE = 16384;
    private static final byte[] JIFFYDOS_C64_KERNAL = new byte[8192];
    private static final byte[] JIFFYDOS_C1541 = new byte[16384];
    private static final MessageDigest MD5_DIGEST;
    private static final byte[] EOD_HACK;
    protected IConfig config;
    protected C64 c64;
    protected Datasette datasette;
    protected IECBus iecBus;
    protected SerialIECDevice[] serialDevices;
    protected C1541[] floppies;
    protected C1541Runner c1541Runner;
    protected MPS803 printer;
    private IExtendImageListener policy;

    public HardwareEnsemble(IConfig config) {
        this(config, MOS6510.class);
    }

    public HardwareEnsemble(final IConfig config, Class<? extends MOS6510> cpuClass) {
        this.config = config;
        this.iecBus = new IECBus();
        this.printer = new MPS803(this.iecBus, 4, 7){

            @Override
            public void setBusy(boolean flag) {
                HardwareEnsemble.this.c64.cia2.setFlag(flag);
            }

            @Override
            public long clk() {
                return HardwareEnsemble.this.c64.context.getTime(Event.Phase.PHI2);
            }
        };
        this.c64 = new C64(cpuClass){

            @Override
            public void printerUserportWriteData(byte data) {
                if (config.getPrinterSection().isPrinterOn()) {
                    HardwareEnsemble.this.printer.printerUserportWriteData(data);
                }
            }

            @Override
            public void printerUserportWriteStrobe(boolean strobe) {
                if (config.getPrinterSection().isPrinterOn()) {
                    HardwareEnsemble.this.printer.printerUserportWriteStrobe(strobe);
                }
            }

            @Override
            public byte readFromIECBus() {
                if (config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                return HardwareEnsemble.this.iecBus.readFromIECBus();
            }

            @Override
            public void writeToIECBus(byte data) {
                if (config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(1L);
                }
                HardwareEnsemble.this.iecBus.writeToIECBus(data);
            }

            @Override
            public boolean getTapeSense() {
                return HardwareEnsemble.this.datasette.getTapeSense();
            }

            @Override
            public void setMotor(boolean state) {
                HardwareEnsemble.this.datasette.setMotor(state);
            }

            @Override
            public void toggleWriteBit(boolean state) {
                HardwareEnsemble.this.datasette.toggleWriteBit(state);
            }
        };
        this.datasette = new Datasette(this.c64.getEventScheduler()){

            @Override
            public void setFlag(boolean flag) {
                HardwareEnsemble.this.c64.cia1.setFlag(flag);
            }
        };
        C1541 c1541 = new C1541(this.iecBus, 8, C1541.FloppyType.C1541);
        this.floppies = new C1541[]{c1541};
        this.serialDevices = new SerialIECDevice[]{this.printer};
        this.iecBus.setFloppies(this.floppies);
        this.iecBus.setSerialDevices(this.serialDevices);
        this.c1541Runner = new SameThreadC1541Runner(this.c64.getEventScheduler(), c1541.getEventScheduler());
    }

    public final IConfig getConfig() {
        return this.config;
    }

    public final C64 getC64() {
        return this.c64;
    }

    public final Datasette getDatasette() {
        return this.datasette;
    }

    public final C1541[] getFloppies() {
        return this.floppies;
    }

    public final MPS803 getPrinter() {
        return this.printer;
    }

    protected void setClock(CPUClock cpuFreq) {
        this.c64.setClock(cpuFreq);
        this.c1541Runner.setClockDivider(cpuFreq);
        for (SerialIECDevice device : this.serialDevices) {
            device.setClock(cpuFreq);
        }
    }

    protected void reset() {
        this.c64.configureVICs(vic -> {
            ISidPlay2Section sidplay2section = this.config.getSidplay2Section();
            vic.getPalette().setBrightness(sidplay2section.getBrightness());
            vic.getPalette().setContrast(sidplay2section.getContrast());
            vic.getPalette().setGamma(sidplay2section.getGamma());
            vic.getPalette().setSaturation(sidplay2section.getSaturation());
            vic.getPalette().setPhaseShift(sidplay2section.getPhaseShift());
            vic.getPalette().setOffset(sidplay2section.getOffset());
            vic.getPalette().setTint(sidplay2section.getTint());
            vic.getPalette().setLuminanceC(sidplay2section.getBlur());
            vic.getPalette().setDotCreep(sidplay2section.getBleed());
        });
        IC1541Section c1541Section = this.config.getC1541Section();
        this.c64.setCustomKernal((byte[])(c1541Section.isJiffyDosInstalled() ? JIFFYDOS_C64_KERNAL : null));
        this.c64.reset();
        this.iecBus.reset();
        this.datasette.reset();
        for (C1541 floppy : this.floppies) {
            floppy.setFloppyType(c1541Section.getFloppyType());
            for (int selector = 0; selector < 5; ++selector) {
                boolean hasRamExpansion = c1541Section.isRamExpansion(selector);
                floppy.setRamExpansion(selector, hasRamExpansion);
            }
            floppy.setCustomKernalRom((byte[])(c1541Section.isJiffyDosInstalled() ? JIFFYDOS_C1541 : null));
            floppy.reset();
        }
        this.enableFloppyDiskDrives(c1541Section.isDriveOn());
        this.connectC64AndC1541WithParallelCable(c1541Section.isParallelCable());
        for (SerialIECDevice serialDevice : this.serialDevices) {
            serialDevice.reset();
        }
        this.enablePrinter(this.config.getPrinterSection().isPrinterOn());
    }

    public final void enableFloppyDiskDrives(final boolean on) {
        this.c64.getEventScheduler().scheduleThreadSafe(new Event("C64-C1541 sync"){

            @Override
            public void event() {
                if (on) {
                    HardwareEnsemble.this.c1541Runner.reset();
                } else {
                    HardwareEnsemble.this.c1541Runner.cancel();
                }
                for (C1541 floppy : HardwareEnsemble.this.floppies) {
                    floppy.setPowerOn(on);
                }
            }
        });
    }

    public final void connectC64AndC1541WithParallelCable(boolean connected) {
        IParallelCable cable = connected ? this.makeCableBetweenC64AndC1541() : new DisconnectedParallelCable();
        this.c64.setParallelCable(cable);
        for (C1541 floppy : this.floppies) {
            floppy.getBusController().setParallelCable(cable);
        }
    }

    private IParallelCable makeCableBetweenC64AndC1541() {
        return new IParallelCable(){
            protected byte parallelCableCpuValue = (byte)-1;
            protected final byte[] parallelCableDriveValue = new byte[]{-1, -1, -1, -1};

            @Override
            public void driveWrite(byte data, boolean handshake, int dnr) {
                HardwareEnsemble.this.c64.cia2.setFlag(handshake);
                this.parallelCableDriveValue[dnr & 0xFFFFFFF7] = data;
            }

            @Override
            public byte driveRead(boolean handshake) {
                HardwareEnsemble.this.c64.cia2.setFlag(handshake);
                return this.parallelCableValue();
            }

            private byte parallelCableValue() {
                byte val = this.parallelCableCpuValue;
                for (C1541 floppy : HardwareEnsemble.this.floppies) {
                    val = (byte)(val & this.parallelCableDriveValue[floppy.getID() & 0xFFFFFFF7]);
                }
                return val;
            }

            @Override
            public void c64Write(byte data) {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                this.parallelCableCpuValue = data;
            }

            @Override
            public byte c64Read() {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                return this.parallelCableValue();
            }

            @Override
            public void pulse() {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                for (C1541 floppy : HardwareEnsemble.this.floppies) {
                    floppy.getBusController().signal(2, 0);
                }
            }
        };
    }

    public final void enablePrinter(boolean printerOn) {
        this.printer.turnPrinterOnOff(printerOn);
    }

    public final void setExtendImagePolicy(IExtendImageListener policy) {
        this.policy = policy;
    }

    public final void insertDisk(File file) throws IOException, SidTuneError {
        this.config.getSidplay2Section().setLastDirectory(file.getParent());
        this.config.getC1541Section().setDriveOn(true);
        this.enableFloppyDiskDrives(true);
        DiskImage disk = this.floppies[0].getDiskController().insertDisk(file);
        if (this.policy != null) {
            disk.setExtendImagePolicy(this.policy);
        }
        this.installHack(file);
    }

    private void installHack(File file) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
             DigestInputStream dis = new DigestInputStream(is, MD5_DIGEST);){
            while (dis.read() != -1) {
            }
            boolean hack = Arrays.equals(MD5_DIGEST.digest(), EOD_HACK);
            if (hack) {
                System.err.println("Edge of Disgrace hack has been installed!");
            }
            this.c64.getCPU().setEODHack(hack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void insertTape(File file) throws IOException, SidTuneError {
        this.config.getSidplay2Section().setLastDirectory(file.getParent());
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".tap")) {
            String tmpDir = this.config.getSidplay2Section().getTmpDir();
            File convertedTape = new File(tmpDir, file.getName() + ".tap");
            convertedTape.deleteOnExit();
            SidTune prog = SidTune.load(file);
            String name = PathUtils.getFilenameWithoutSuffix(file.getName());
            PRG2TAPProgram program = new PRG2TAPProgram(prog, name);
            PRG2TAP prg2tap = new PRG2TAP();
            prg2tap.setTurboTape(this.config.getSidplay2Section().isTurboTape());
            prg2tap.open(convertedTape);
            prg2tap.add(program);
            prg2tap.close(convertedTape);
            this.datasette.insertTape(convertedTape);
        } else {
            this.datasette.insertTape(file);
        }
    }

    public final void insertCartridge(CartridgeType type, int sizeKB) throws IOException, SidTuneError {
        this.c64.ejectCartridge();
        this.c64.setCartridge(type, sizeKB);
    }

    public final void insertCartridge(CartridgeType type, File file) throws IOException, SidTuneError {
        this.config.getSidplay2Section().setLastDirectory(file.getParent());
        this.c64.ejectCartridge();
        this.c64.setCartridge(type, file);
    }

    static {
        EOD_HACK = new byte[]{-18, -83, 86, 48, -112, 70, 55, -51, 61, 76, -123, -113, 80, -122, 81, -110};
        try (DataInputStream isJiffyDosC64 = new DataInputStream(HardwareEnsemble.class.getResourceAsStream(JIFFYDOS_C64_ROM));
             DataInputStream isJiffyDosC1541 = new DataInputStream(HardwareEnsemble.class.getResourceAsStream(JIFFYDOS_C1541_ROM));){
            isJiffyDosC64.readFully(JIFFYDOS_C64_KERNAL);
            isJiffyDosC1541.readFully(JIFFYDOS_C1541);
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

