/*
 * Decompiled with CFR 0.152.
 */
package libpsid64;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import libpsid64.FreeMemPages;
import libpsid64.MemoryBlock;
import libpsid64.Screen;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.PathUtils;
import libsidutils.Petscii;
import libsidutils.assembler.KickAssembler;
import libsidutils.cruncher.PUCrunch;
import libsidutils.stil.STIL;
import sidplay.Player;

public class Psid64 {
    private static final String PSID64_BOOT_ASM = "/libpsid64/psid64_boot.asm";
    private static final String PSID64_ASM = "/libpsid64/psid64.asm";
    private static final String PSID64_NOSCREEN_ASM = "/libpsid64/psid64_noscreen.asm";
    private static final int MAX_BLOCKS = 4;
    private static final int MAX_PAGES = 256;
    private static final int NUM_MINDRV_PAGES = 2;
    private static final int NUM_EXTDRV_PAGES = 5;
    private static final int NUM_SCREEN_PAGES = 4;
    private static final int NUM_CHAR_PAGES = 8;
    private static final int STIL_EOT_SPACES = 10;
    private KickAssembler assembler = new KickAssembler();
    private SidTune tune;
    private STIL.STILEntry stilEntry;
    private String tmpDir;
    private boolean verbose;
    private boolean blankScreen;

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBlankScreen(boolean blankScreen) {
        this.blankScreen = blankScreen;
    }

    private byte[] convert() {
        SidTuneInfo tuneInfo = this.tune.getInfo();
        if (tuneInfo.getCompatibility() == SidTune.Compatibility.RSID_BASIC) {
            return this.convertBASIC();
        }
        String stilText = this.formatStilText().toString();
        FreeMemPages freePages = this.findFreeSpace(stilText.length());
        if (this.blankScreen) {
            freePages.setScreenPage(null);
            freePages.setCharPage(null);
            freePages.setStilPage(null);
        }
        byte[] driverInfo = this.initDriver(freePages);
        ArrayList<MemoryBlock> memBlocks = new ArrayList<MemoryBlock>();
        MemoryBlock memoryBlock = new MemoryBlock();
        memoryBlock.setStartAddress(freePages.getDriverPage() << 8);
        memoryBlock.setSize(driverInfo.length - 2);
        memoryBlock.setData(driverInfo);
        memoryBlock.setDataOff(2);
        memoryBlock.setDescription("Driver code");
        memBlocks.add(memoryBlock);
        memoryBlock = new MemoryBlock();
        memoryBlock.setStartAddress(tuneInfo.getLoadAddr());
        memoryBlock.setSize(tuneInfo.getC64dataLen());
        memoryBlock.setData(new byte[65536]);
        memoryBlock.setDataOff(tuneInfo.getLoadAddr());
        memoryBlock.setDescription("Music data");
        memBlocks.add(memoryBlock);
        this.tune.placeProgramInMemory(memoryBlock.getData());
        if (freePages.getScreenPage() != null) {
            Screen screen = new Screen(this.tune.getInfo());
            memoryBlock = new MemoryBlock();
            memoryBlock.setStartAddress(freePages.getScreenPage() << 8);
            memoryBlock.setSize(screen.getDataSize());
            memoryBlock.setData(screen.getData());
            memoryBlock.setDataOff(0);
            memoryBlock.setDescription("Screen");
            memBlocks.add(memoryBlock);
        }
        if (freePages.getStilPage() != null) {
            byte[] data = new byte[stilText.length()];
            for (int i = 0; i < stilText.length(); ++i) {
                data[i] = Petscii.iso88591ToPetscii(stilText.charAt(i));
            }
            data[data.length - 1] = -1;
            memoryBlock = new MemoryBlock();
            memoryBlock.setStartAddress(freePages.getStilPage() << 8);
            memoryBlock.setSize(data.length);
            memoryBlock.setData(data);
            memoryBlock.setDataOff(0);
            memoryBlock.setDescription("STIL text");
            memBlocks.add(memoryBlock);
        }
        Collections.sort(memBlocks, (a, b) -> a.getStartAddress() - b.getStartAddress());
        int driver = freePages.getDriverPage() != null ? freePages.getDriverPage() << 8 : 0;
        int charset = freePages.getCharPage() != null ? freePages.getCharPage() << 8 : 0;
        this.printMemoryMap(memBlocks, charset);
        int size = 0;
        for (MemoryBlock memBlock : memBlocks) {
            size += memBlock.getSize();
        }
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("songNum", String.valueOf(tuneInfo.getCurrentSong() - 1));
        globals.put("size", String.valueOf(size));
        globals.put("numPages", String.valueOf(size + 255 >> 8));
        globals.put("numBlocks", String.valueOf(memBlocks.size() - 1));
        globals.put("charPage", String.valueOf(charset));
        globals.put("driverPage", String.valueOf(driver));
        globals.put("stopVec", String.valueOf(driver + 3));
        for (int i = 0; i < 4; ++i) {
            boolean used = i < memBlocks.size();
            int blockNum = memBlocks.size() - i - 1 + (used ? 0 : 4);
            int blockStart = used ? ((MemoryBlock)memBlocks.get(i)).getStartAddress() : 0;
            int blockSize = used ? ((MemoryBlock)memBlocks.get(i)).getSize() : 0;
            globals.put("block" + blockNum + "Start", String.valueOf(blockStart));
            globals.put("block" + blockNum + "Size", String.valueOf(blockSize));
        }
        InputStream asm = Psid64.class.getResourceAsStream(PSID64_BOOT_ASM);
        byte[] psidBoot = this.assembler.assemble(PSID64_BOOT_ASM, asm, globals);
        byte[] programData = new byte[psidBoot.length + size];
        System.arraycopy(psidBoot, 0, programData, 0, psidBoot.length);
        int destPos = psidBoot.length;
        for (MemoryBlock memBlock : memBlocks) {
            System.arraycopy(memBlock.getData(), memBlock.getDataOff(), programData, destPos, memBlock.getSize());
            destPos += memBlock.getSize();
        }
        return programData;
    }

    private byte[] convertBASIC() {
        SidTuneInfo tuneInfo = this.tune.getInfo();
        byte[] programData = new byte[2 + tuneInfo.getC64dataLen()];
        programData[0] = (byte)(tuneInfo.getLoadAddr() & 0xFF);
        programData[1] = (byte)(tuneInfo.getLoadAddr() >> 8);
        byte[] c64buf = new byte[65536];
        this.tune.placeProgramInMemory(c64buf);
        System.arraycopy(c64buf, tuneInfo.getLoadAddr(), programData, 2, tuneInfo.getC64dataLen());
        this.printBasicMemoryMap(tuneInfo);
        return programData;
    }

    private void printBasicMemoryMap(SidTuneInfo tuneInfo) {
        if (this.verbose) {
            PrintStream out = System.out;
            out.println("C64 memory map:");
            out.printf("  $%04x-$%04x  BASIC program", tuneInfo.getLoadAddr(), tuneInfo.getLoadAddr() + tuneInfo.getC64dataLen());
            out.println();
        }
    }

    private void printMemoryMap(List<MemoryBlock> memBlocks, int charset) {
        if (this.verbose) {
            PrintStream out = System.out;
            out.println("C64 memory map:");
            boolean charsetPrinted = false;
            for (MemoryBlock memBlock : memBlocks) {
                if (!charsetPrinted && memBlock.getStartAddress() > charset) {
                    out.printf("  $%04x-$%04x  Character set", charset, charset + 2048);
                    out.println();
                    charsetPrinted = true;
                }
                out.printf("  $%04x-$%04x  %s", memBlock.getStartAddress(), memBlock.getStartAddress() + memBlock.getSize(), memBlock.getDescription());
                out.println();
            }
            if (!charsetPrinted) {
                out.printf("  $%04x-$%04x  Character set", charset, charset + 2048);
                out.println();
            }
        }
    }

    private byte[] initDriver(FreeMemPages freePages) {
        SidTuneInfo tuneInfo = this.tune.getInfo();
        int screenPage = freePages.getScreenPage() != null ? freePages.getScreenPage() : 0;
        int screen = screenPage << 8;
        int screenSongNum = 0;
        if (tuneInfo.getSongs() > 1) {
            screenSongNum = screen + 400 + 24;
            if (tuneInfo.getSongs() >= 100) {
                ++screenSongNum;
            }
            if (tuneInfo.getSongs() >= 10) {
                ++screenSongNum;
            }
        }
        int vsa = (screenPage & 0x3C) << 2;
        int charset = freePages.getCharPage() != null ? freePages.getCharPage() >> 2 & 0xE : 6;
        int stil = freePages.getStilPage() != null ? freePages.getStilPage() : 0;
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("pc", String.valueOf(freePages.getDriverPage() << 8));
        globals.put("screen", String.valueOf(screen));
        globals.put("screen_songnum", String.valueOf(screenSongNum));
        globals.put("dd00", String.valueOf((screenPage & 0xC0) >> 6 ^ 3 | 4));
        globals.put("d018", String.valueOf(vsa | charset));
        globals.put("loadAddr", String.valueOf(tuneInfo.getLoadAddr()));
        globals.put("initAddr", String.valueOf(tuneInfo.getInitAddr()));
        globals.put("playAddr", String.valueOf(tuneInfo.getPlayAddr()));
        globals.put("songs", String.valueOf(tuneInfo.getSongs()));
        globals.put("speed", String.valueOf(this.tune.getSongSpeedWord()));
        globals.put("initIOMap", String.valueOf(tuneInfo.iomap(tuneInfo.getInitAddr())));
        globals.put("playIOMap", String.valueOf(tuneInfo.iomap(tuneInfo.getPlayAddr())));
        globals.put("stilPage", String.valueOf(stil));
        String resource = freePages.getScreenPage() == null ? PSID64_NOSCREEN_ASM : PSID64_ASM;
        InputStream asm = Psid64.class.getResourceAsStream(resource);
        return this.assembler.assemble(resource, asm, globals);
    }

    private StringBuffer formatStilText() {
        StringBuffer result = new StringBuffer();
        if (this.stilEntry != null) {
            String writeSTILEntry = this.writeSTILEntry(this.stilEntry);
            String replaceAll = writeSTILEntry.replaceAll("([ \t\r\n])+", " ");
            result.append(replaceAll);
        }
        if (result.length() > 0) {
            for (int i = 0; i < 9; ++i) {
                result.insert(0, ' ');
            }
            result.append('\u00ff');
        }
        return result;
    }

    private String writeSTILEntry(STIL.STILEntry stilEntry) {
        StringBuffer result = new StringBuffer();
        if (stilEntry.filename != null) {
            result.append("Filename: ");
            result.append(stilEntry.filename);
            result.append(" - ");
        }
        if (stilEntry.globalComment != null) {
            result.append(stilEntry.globalComment);
        }
        for (STIL.Info info : stilEntry.infos) {
            this.writeSTILEntry(result, info);
        }
        int subTuneNo = 1;
        for (STIL.TuneEntry entry : stilEntry.subtunes) {
            if (entry.globalComment != null) {
                result.append(entry.globalComment);
            }
            for (STIL.Info info : entry.infos) {
                result.append(" SubTune #" + subTuneNo + ": ");
                this.writeSTILEntry(result, info);
            }
            ++subTuneNo;
        }
        return result.append("                                        ").toString();
    }

    private void writeSTILEntry(StringBuffer buffer, STIL.Info info) {
        if (info.name != null) {
            buffer.append(" Name: ");
            buffer.append(info.name);
        }
        if (info.author != null) {
            buffer.append(" Author: ");
            buffer.append(info.author);
        }
        if (info.title != null) {
            buffer.append(" Title: ");
            buffer.append(info.title);
        }
        if (info.artist != null) {
            buffer.append(" Artist: ");
            buffer.append(info.artist);
        }
        if (info.comment != null) {
            buffer.append(" Comment: ");
            buffer.append(info.comment);
        }
    }

    private FreeMemPages findFreeSpace(int stilTextLength) {
        int j;
        int i;
        int stilSize = stilTextLength + 255 >> 8;
        boolean[] pages = new boolean[256];
        SidTuneInfo tuneInfo = this.tune.getInfo();
        if (tuneInfo.getRelocStartPage() == 0) {
            int[] used = new int[]{0, 3, 160, 191, 208, 255, tuneInfo.getLoadAddr() >> 8, tuneInfo.getLoadAddr() + tuneInfo.getC64dataLen() - 1 >> 8};
            for (i = 0; i < 256; ++i) {
                pages[i] = false;
            }
            for (i = 0; i < used.length; i += 2) {
                for (j = used[i]; j <= used[i + 1]; ++j) {
                    pages[j] = true;
                }
            }
        } else if (tuneInfo.getRelocStartPage() != 255 && tuneInfo.getRelocPages() != 0) {
            int endp = Math.min(tuneInfo.getRelocStartPage() + tuneInfo.getRelocPages(), 256);
            if (tuneInfo.getRelocStartPage() < 4 || 160 <= tuneInfo.getRelocStartPage() && tuneInfo.getRelocStartPage() <= 191 || tuneInfo.getRelocStartPage() >= 208 || endp - 1 < 4 || 160 <= endp - 1 && endp - 1 <= 191 || endp - 1 >= 208) {
                throw new RuntimeException("PSID64: Not enough memory for driver and screen!");
            }
            for (i = 0; i < 256; ++i) {
                pages[i] = tuneInfo.getRelocStartPage() > i || i >= endp;
            }
        } else {
            throw new RuntimeException("PSID64: Not enough memory for driver and screen!");
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            int bank = ((i2 & 1 ^ i2 >> 1) != 0 ? i2 ^ 3 : i2) << 6;
            for (j = 0; j < 64; j += 4) {
                int scr;
                if ((bank & 0x40) == 0 && 16 <= j && j < 32 || pages[scr = bank + j] || pages[scr + 1] || pages[scr + 2] || pages[scr + 3]) continue;
                if ((bank & 0x40) != 0) {
                    for (int k = 0; k < 64; k += 8) {
                        Integer driver;
                        int chars;
                        if (k == (j & 0x38) || pages[chars = bank + k] || pages[chars + 1] || pages[chars + 2] || pages[chars + 3] || pages[chars + 4] || pages[chars + 5] || pages[chars + 6] || pages[chars + 7] || (driver = this.findSpace(pages, scr, chars, null, 5)) == null) continue;
                        FreeMemPages freePrages = new FreeMemPages();
                        freePrages.setDriverPage(driver);
                        freePrages.setScreenPage(scr);
                        freePrages.setCharPage(chars);
                        if (stilSize != 0) {
                            freePrages.setStilPage(this.findSpace(pages, scr, chars, driver, stilSize));
                        }
                        return freePrages;
                    }
                    continue;
                }
                Integer driver = this.findSpace(pages, scr, null, null, 5);
                if (driver == null) continue;
                FreeMemPages freePages = new FreeMemPages();
                freePages.setDriverPage(driver);
                freePages.setScreenPage(scr);
                if (stilSize != 0) {
                    freePages.setStilPage(this.findSpace(pages, scr, null, driver, stilSize));
                }
                return freePages;
            }
        }
        Integer driver = this.findSpace(pages, null, null, null, 2);
        if (driver != null) {
            FreeMemPages freePrages = new FreeMemPages();
            freePrages.setDriverPage(driver);
            return freePrages;
        }
        throw new RuntimeException("PSID64: Not enough memory for driver and screen!");
    }

    private Integer findSpace(boolean[] pages, Integer scr, Integer chars, Integer driver, int size) {
        int firstPage = 0;
        for (int i = 0; i < 256; ++i) {
            if (!(pages[i] || scr != null && scr <= i && i < scr + 4 || chars != null && chars <= i && i < chars + 8) && (driver == null || driver > i || i >= driver + 5)) continue;
            if (i - firstPage >= size) {
                return firstPage;
            }
            firstPage = i + 1;
        }
        return null;
    }

    public void convertFiles(Player player, File[] files, File target, File hvscRoot) throws IOException, SidTuneError {
        for (File file : files) {
            if (file.isDirectory()) {
                this.convertFiles(player, file.listFiles(), target, hvscRoot);
                continue;
            }
            this.convertToPSID64(player, file, target, hvscRoot);
        }
    }

    private void convertToPSID64(Player player, File file, File target, File hvscRoot) throws IOException, SidTuneError {
        this.tune = SidTune.load(file);
        this.tune.getInfo().setSelectedSong(null);
        String collectionName = PathUtils.getCollectionName(hvscRoot, file);
        this.stilEntry = player.getStilEntry(collectionName);
        File tmpFile = new File(this.tmpDir, PathUtils.getFilenameWithoutSuffix(file.getName()) + ".prg.tmp");
        tmpFile.deleteOnExit();
        try (FileOutputStream outfile = new FileOutputStream(tmpFile);){
            ((OutputStream)outfile).write(this.convert());
        }
        PUCrunch puCrunch = new PUCrunch();
        puCrunch.setVerbose(this.verbose);
        puCrunch.crunch(tmpFile.getAbsolutePath(), new File(target, PathUtils.getFilenameWithoutSuffix(file.getName()) + ".prg").getAbsolutePath());
    }
}

