/*
 * Decompiled with CFR 0.152.
 */
package hardsid_builder;

import hardsid_builder.HardSID;
import hardsid_builder.HardSID4U;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.config.IConfig;
import libsidplay.sidtune.SidTune;

public class HardSIDBuilder
implements SIDBuilder {
    private static final short REGULAR_DELAY = 256;
    static final short SHORTEST_DELAY = 4;
    private EventScheduler context;
    private IConfig config;
    private static HardSID4U hardSID;
    private List<HardSID> sids = new ArrayList<HardSID>();
    private byte deviceID;
    protected long lastSIDWriteTime;
    private static boolean initialized;

    public HardSIDBuilder(EventScheduler context, IConfig config) {
        this.context = context;
        this.config = config;
        if (!initialized) {
            try {
                System.load(this.extract(config, "/hardsid_builder/win32/Release/", "JHardSID.dll"));
                initialized = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("HARDSID ERROR: JHardSID.dll not found!", new Object[0]));
            }
        }
        hardSID = new HardSID4U();
    }

    private String extract(IConfig config, String path, String libName) throws IOException {
        File file = new File(new File(config.getSidplay2Section().getTmpDir()), libName);
        file.deleteOnExit();
        try (InputStream is = this.getClass().getResourceAsStream(path + libName);){
            Files.copy(is, Paths.get(file.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        return file.getAbsolutePath();
    }

    @Override
    public SIDEmu lock(SIDEmu oldHardSID, int sidNum, SidTune tune) {
        ChipModel chipModel = this.getChipModel(tune, sidNum);
        byte chipNum = this.getModelDependantSidNum(chipModel, sidNum);
        if (this.deviceID < hardSID.HardSID_DeviceCount() && chipNum < hardSID.HardSID_SIDCount(this.deviceID)) {
            if (oldHardSID != null) {
                return oldHardSID;
            }
            HardSID hsid = new HardSID(this.context, this, hardSID, this.deviceID, chipNum, chipModel);
            this.sids.add(hsid);
            hsid.lock();
            return hsid;
        }
        throw new RuntimeException(String.format("HARDSID ERROR: System doesn't have enough SID chips. Requested: (DeviceID=%d, SID=%d)", this.deviceID, chipNum));
    }

    @Override
    public void unlock(SIDEmu sidEmu) {
        HardSID hardSid = (HardSID)sidEmu;
        hardSid.unlock();
        this.sids.remove(sidEmu);
    }

    private ChipModel getChipModel(SidTune tune, int sidNum) {
        ChipModel modelAlreadyInUse;
        ChipModel chipModel = ChipModel.getChipModel(this.config.getEmulationSection(), tune, sidNum);
        if (this.sids.size() > 0 && chipModel == (modelAlreadyInUse = this.sids.get(0).getChipModel())) {
            chipModel = chipModel == ChipModel.MOS6581 ? ChipModel.MOS8580 : ChipModel.MOS6581;
        }
        return chipModel;
    }

    private byte getModelDependantSidNum(ChipModel chipModel, int sidNum) {
        int sid6581 = this.config.getEmulationSection().getHardsid6581();
        int sid8580 = this.config.getEmulationSection().getHardsid8580();
        if (sidNum == 2) {
            for (byte i = 0; i < hardSID.HardSID_SIDCount(this.deviceID); i = (byte)(i + 1)) {
                if (i == sid6581 || i == sid8580) continue;
                System.err.println("Use 1st:" + sid6581 + ", 2nd:" + sid8580 + ", 3rd:" + i);
                return i;
            }
            throw new RuntimeException(String.format("HARDSID ERROR: System doesn't have enough SID chips. Requested: (DeviceID=%d, SID=%d)", this.deviceID, hardSID.HardSID_SIDCount(this.deviceID)));
        }
        return (byte)(chipModel == ChipModel.MOS6581 ? sid6581 : sid8580);
    }

    int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return Math.max(4, diff);
    }

    long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 512) {
            this.lastSIDWriteTime += 256L;
            hardSID.HardSID_Delay(this.deviceID, (short)256);
        }
        return 256L;
    }
}

