/*
 * Decompiled with CFR 0.152.
 */
package hardsid_builder;

import hardsid_builder.HardSID4U;
import hardsid_builder.HardSIDBuilder;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDEmu;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;

public class HardSID
extends SIDEmu {
    private final Event event = new Event("HardSID Delay"){

        @Override
        public void event() {
            HardSID.this.context.schedule(HardSID.this.event, HardSID.this.hardSIDBuilder.eventuallyDelay(), Event.Phase.PHI2);
        }
    };
    private EventScheduler context;
    private final HardSID4U hardSID;
    private final byte deviceID;
    private final byte chipNum;
    private ChipModel chipModel;
    private HardSIDBuilder hardSIDBuilder;

    public HardSID(EventScheduler context, HardSIDBuilder hardSIDBuilder, HardSID4U hardSID, byte deviceID, byte sid, ChipModel model) {
        this.context = context;
        this.hardSIDBuilder = hardSIDBuilder;
        this.hardSID = hardSID;
        this.deviceID = deviceID;
        this.chipNum = sid;
        this.chipModel = model;
    }

    @Override
    public void reset(byte volume) {
        this.hardSID.HardSID_Reset(this.deviceID);
        for (byte reg = 0; reg < 32; reg = (byte)(reg + 1)) {
            this.hardSID.HardSID_Write(this.deviceID, this.chipNum, (short)4, reg, (byte)0);
        }
        this.hardSID.HardSID_Write(this.deviceID, this.chipNum, (short)4, (byte)15, volume);
        this.hardSID.HardSID_Flush(this.deviceID);
    }

    @Override
    public byte read(int addr) {
        this.clock();
        return this.hardSID.HardSID_Read(this.deviceID, this.chipNum, (short)this.hardSIDBuilder.clocksSinceLastAccess(), (byte)addr);
    }

    @Override
    public void write(int addr, byte data) {
        this.clock();
        super.write(addr, data);
        this.hardSID.HardSID_Write(this.deviceID, this.chipNum, (short)this.hardSIDBuilder.clocksSinceLastAccess(), (byte)addr, data);
    }

    @Override
    public void clock() {
    }

    protected void lock() {
        this.context.schedule(this.event, 0L, Event.Phase.PHI2);
    }

    protected void unlock() {
        this.reset((byte)0);
        this.context.cancel(this.event);
    }

    @Override
    public void setFilter(IConfig config, int sidNum) {
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    @Override
    public void setChipModel(ChipModel model) {
    }

    @Override
    public void setClockFrequency(double cpuFrequency) {
    }

    @Override
    public void input(int input) {
    }

    @Override
    public int getInputDigiBoost() {
        return 0;
    }

    public static final String credits() {
        return "HardSID V1.0.1 Engine:\n\tCopyright (\u00a9) 1999-2002 Simon White <sidplay2@yahoo.com>\n";
    }
}

