/*
 * Decompiled with CFR 0.152.
 */
package c64jukebox;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import libsidplay.common.Engine;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import sidplay.ini.IniConfig;
import sidplay.player.State;

public class SIDPlay
extends Applet {
    private IniConfig config;
    private Player player;
    private final HashMap<String, SidTune> map = new HashMap();

    @Override
    public void init() {
        this.config = new IniConfig();
        this.player = new Player(this.config);
        this.callJavaScript("javascript:init()");
    }

    @Override
    public void start() {
        if (this.getAppletContext() != null) {
            String startSong = this.getParameter("startSong");
            this.playSID(this.getParameter("playsid"), startSong != null ? Integer.valueOf(startSong) : -1);
        }
        this.callJavaScript("javascript:start()");
    }

    @Override
    public void stop() {
        this.player.stopC64();
        this.callJavaScript("javascript:stop()");
    }

    @Override
    public void destroy() {
        this.callJavaScript("javascript:destroy()");
    }

    private void callJavaScript(String spec) {
        try {
            if (this.getAppletContext() != null) {
                this.getAppletContext().showDocument(new URL(spec));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void playSID(String urlName, Integer songNum) {
        if (urlName == null) {
            return;
        }
        SidTune tune = this.getTune(urlName);
        tune.getInfo().setSelectedSong(songNum != -1 ? songNum : null);
        this.player.play(tune);
    }

    public void stopSID() {
        this.player.stopC64();
    }

    public void nextSong() {
        this.player.nextSong();
    }

    public void previousSong() {
        this.player.previousSong();
    }

    public void useEmulation() {
        this.config.getEmulationSection().setEngine(Engine.EMULATION);
    }

    public void useHardSID() {
        this.config.getEmulationSection().setEngine(Engine.HARDSID);
    }

    public void pauseOrContinueSID() {
        this.player.pauseContinue();
    }

    public int stateSID() {
        return ((State)((Object)this.player.stateProperty().get())).ordinal();
    }

    public void setChipDevice(int hardsid6581, int hardsid8580) {
        this.config.getEmulationSection().setHardsid6581(hardsid6581);
        this.config.getEmulationSection().setHardsid8580(hardsid8580);
    }

    public int getSongCount(String path) {
        return this.getTune(path).getInfo().getSongs();
    }

    public int getDefaultSong(String path) {
        return this.getTune(path).getInfo().getStartSong();
    }

    public int getCurrentSong() {
        return this.player.getPlayList().getCurrent();
    }

    public int getCurrentTime() {
        return this.player.time();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SidTune getTune(String url) {
        SidTune tune = this.map.get(url);
        if (tune != null) {
            return tune;
        }
        try (InputStream stream = new URL(url).openConnection().getInputStream();){
            tune = SidTune.load(url, stream);
            this.map.put(url, tune);
            SidTune sidTune = tune;
            return sidTune;
        }
        catch (IOException | SidTuneError e) {
            this.showStatus(e.getMessage());
            return null;
        }
    }
}

