/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.BuilderFactory;
import ui.UIPart;

public class UIUtil {
    private ResourceBundle bundle;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parse(UIPart part) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        URL fxml = part.getFxml();
        fxmlLoader.setLocation(fxml);
        fxmlLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        this.bundle = ResourceBundle.getBundle(part.getBundleName());
        fxmlLoader.setResources(this.bundle);
        fxmlLoader.setController((Object)part);
        try (InputStream is = fxml.openStream();){
            Object object = fxmlLoader.load(is);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ResourceBundle getBundle() {
        return this.bundle;
    }
}

