/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import ui.UIPart;
import ui.UIUtil;

public abstract class UIStage
extends Stage
implements UIPart {
    protected UIUtil util = new UIUtil();
    private boolean wait;

    public void open() throws IOException {
        this.open(this);
        this.centerOnScreen();
    }

    public void open(Stage stage) throws IOException {
        Scene scene = (Scene)this.util.parse(this);
        scene.getStylesheets().add((Object)this.getStyleSheetName());
        scene.setOnKeyPressed(ke -> {
            if (ke.getCode() == KeyCode.ESCAPE) {
                stage.close();
            }
        });
        stage.setScene(scene);
        stage.getIcons().add((Object)new Image(this.util.getBundle().getString("ICON")));
        stage.setTitle(this.util.getBundle().getString("TITLE"));
        if (this.wait) {
            stage.showAndWait();
        } else {
            stage.show();
        }
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    protected String getStyleSheetName() {
        return "/" + this.getClass().getName().replace('.', '/') + ".css";
    }
}

