/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import mp3.FrameSkip;
import mp3.GetAudio;
import mp3.Lame;
import mp3.Parse;
import mp3.Usage;
import mp3.Version;

public class Main {
    private Lame lame;
    private Usage usage = new Usage();
    private Version version = new Version();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final int MAX_NOGAP = 200;
    private double last_time = 0.0;
    private int oldPercent;
    private int curPercent;
    private int oldConsoleX;
    private static final int MAX_WIDTH = 79;

    public PropertyChangeSupport getSupport() {
        return this.support;
    }

    private int parse_args_from_string(String argv, StringBuilder inPath, StringBuilder outPath) {
        if (argv == null || argv.length() == 0) {
            return 0;
        }
        StringTokenizer tok = new StringTokenizer(argv, " ");
        ArrayList<String> args = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            args.add(tok.nextToken());
        }
        return this.lame.getParser().parse_args(this.lame.getFlags(), args, inPath, outPath, null, null);
    }

    private DataOutput init_files(String inPath, String outPath, FrameSkip enc) {
        if (inPath.equals(outPath)) {
            System.err.println("Input file and Output file are the same. Abort.");
            return null;
        }
        this.lame.getAudio().initInFile(this.lame.getFlags(), inPath, enc);
        try {
            FileOutputStream fout = new FileOutputStream(outPath);
            return new DataOutputStream(new BufferedOutputStream(fout, 0x100000));
        }
        catch (FileNotFoundException e) {
            System.err.printf("Can't init outfile '%s'\n", outPath);
            return null;
        }
    }

    private void lame_decoder(DataOutput outf, int skip_start, String inPath, String outPath, FrameSkip enc) throws IOException {
        int i;
        int iread;
        float[][] Buffer2 = new float[2][1152];
        int skip_end = 0;
        int tmp_num_channels = this.lame.getFlags().getInNumChannels();
        if (this.lame.getParser().silent < 10) {
            System.out.printf("\rinput:  %s%s(%g kHz, %d channel%s, ", inPath, inPath.length() > 26 ? "\n\t" : "  ", (double)this.lame.getFlags().getInSampleRate() / 1000.0, tmp_num_channels, tmp_num_channels != 1 ? "s" : "");
        }
        switch (this.lame.getParser().getInputFormat()) {
            case sf_mp123: {
                throw new RuntimeException("Internal error.  Aborting.");
            }
            case sf_mp3: {
                if (skip_start == 0) {
                    if (enc.getEncoderDelay() > -1 || enc.getEncoderPadding() > -1) {
                        if (enc.getEncoderDelay() > -1) {
                            skip_start = enc.getEncoderDelay() + 528 + 1;
                        }
                        if (enc.getEncoderPadding() > -1) {
                            skip_end = enc.getEncoderPadding() - 529;
                        }
                    } else {
                        skip_start = this.lame.getFlags().getEncoderDelay() + 528 + 1;
                    }
                } else {
                    skip_start += 529;
                }
                if (this.lame.getParser().silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", "III");
                break;
            }
            case sf_mp2: {
                skip_start += 241;
                if (this.lame.getParser().silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", "II");
                break;
            }
            case sf_mp1: {
                skip_start += 241;
                if (this.lame.getParser().silent >= 10) break;
                System.out.printf("MPEG-%d%s Layer %s", 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", "I");
                break;
            }
            case sf_raw: {
                if (this.lame.getParser().silent < 10) {
                    System.out.printf("raw PCM data", new Object[0]);
                }
                this.lame.getParser().getMp3InputData().setNumSamples(this.lame.getFlags().num_samples);
                this.lame.getParser().getMp3InputData().setFrameSize(1152);
                skip_start = 0;
                break;
            }
            case sf_wave: {
                if (this.lame.getParser().silent < 10) {
                    System.out.printf("Microsoft WAVE", new Object[0]);
                }
                this.lame.getParser().getMp3InputData().setNumSamples(this.lame.getFlags().num_samples);
                this.lame.getParser().getMp3InputData().setFrameSize(1152);
                skip_start = 0;
                break;
            }
            case sf_aiff: {
                if (this.lame.getParser().silent < 10) {
                    System.out.printf("SGI/Apple AIFF", new Object[0]);
                }
                this.lame.getParser().getMp3InputData().setNumSamples(this.lame.getFlags().num_samples);
                this.lame.getParser().getMp3InputData().setFrameSize(1152);
                skip_start = 0;
                break;
            }
            default: {
                if (this.lame.getParser().silent < 10) {
                    System.out.printf("unknown", new Object[0]);
                }
                this.lame.getParser().getMp3InputData().setNumSamples(this.lame.getFlags().num_samples);
                this.lame.getParser().getMp3InputData().setFrameSize(1152);
                skip_start = 0;
                assert (false);
                break;
            }
        }
        if (this.lame.getParser().silent < 10) {
            System.out.printf(")\noutput: %s%s(16 bit, Microsoft WAVE)\n", outPath, outPath.length() > 45 ? "\n\t" : "  ");
            if (skip_start > 0) {
                System.out.printf("skipping initial %d samples (encoder+decoder delay)\n", skip_start);
            }
            if (skip_end > 0) {
                System.out.printf("skipping final %d samples (encoder padding-decoder delay)\n", skip_end);
            }
        }
        if (!this.lame.getParser().embedded) {
            System.out.print("|");
            for (int j = 0; j < 77; ++j) {
                System.out.print("=");
            }
            System.out.println("|");
        }
        this.oldConsoleX = 0;
        this.curPercent = 0;
        this.oldPercent = 0;
        if (!this.lame.getParser().disable_wav_header) {
            this.lame.getAudio().WriteWaveHeader(outf, Integer.MAX_VALUE, this.lame.getFlags().getInSampleRate(), tmp_num_channels, 16);
        }
        double wavsize = -(skip_start + skip_end);
        this.lame.getParser().getMp3InputData().setTotalFrames(this.lame.getParser().getMp3InputData().getNumSamples() / this.lame.getParser().getMp3InputData().getFrameSize());
        assert (tmp_num_channels >= 1 && tmp_num_channels <= 2);
        do {
            if ((iread = this.lame.getAudio().get_audio16(this.lame.getFlags(), Buffer2)) < 0) continue;
            this.lame.getParser().getMp3InputData().setFramesDecodedCounter(this.lame.getParser().getMp3InputData().getFramesDecodedCounter() + iread / this.lame.getParser().getMp3InputData().getFrameSize());
            wavsize += (double)iread;
            if (this.lame.getParser().silent <= 0 || this.lame.getParser().embedded) {
                this.timestatus(this.lame.getParser().getMp3InputData().getFramesDecodedCounter(), this.lame.getParser().getMp3InputData().getTotalFrames());
            }
            i = skip_start < iread ? skip_start : iread;
            skip_start -= i;
            if (skip_end > 1152 && this.lame.getParser().getMp3InputData().getFramesDecodedCounter() + 2 > this.lame.getParser().getMp3InputData().getTotalFrames()) {
                iread -= skip_end - 1152;
                skip_end = 1152;
            } else if (this.lame.getParser().getMp3InputData().getFramesDecodedCounter() == this.lame.getParser().getMp3InputData().getTotalFrames() && iread != 0) {
                iread -= skip_end;
            }
            while (i < iread) {
                if (this.lame.getParser().disable_wav_header) {
                    if (this.lame.getParser().swapbytes) {
                        this.WriteBytesSwapped(outf, Buffer2[0], i);
                    } else {
                        this.WriteBytes(outf, Buffer2[0], i);
                    }
                    if (tmp_num_channels == 2) {
                        if (this.lame.getParser().swapbytes) {
                            this.WriteBytesSwapped(outf, Buffer2[1], i);
                        } else {
                            this.WriteBytes(outf, Buffer2[1], i);
                        }
                    }
                } else {
                    this.lame.getAudio().write16BitsLowHigh(outf, (int)Buffer2[0][i] & 0xFFFF);
                    if (tmp_num_channels == 2) {
                        this.lame.getAudio().write16BitsLowHigh(outf, (int)Buffer2[1][i] & 0xFFFF);
                    }
                }
                ++i;
            }
        } while (iread > 0);
        if (this.lame.getParser().silent <= 0) {
            for (i = this.curPercent; i < 100; ++i) {
                this.progressStep();
            }
            System.out.println();
        }
        i = 2 * tmp_num_channels;
        assert (i > 0);
        if (wavsize <= 0.0) {
            if (this.lame.getParser().silent < 10) {
                System.err.println("WAVE file contains 0 PCM samples");
            }
            wavsize = 0.0;
        } else if (wavsize > (double)(0xFFFFFFD0L / (long)i)) {
            if (this.lame.getParser().silent < 10) {
                System.err.println("Very huge WAVE file, can't set filesize accordingly");
            }
            wavsize = -48.0;
        } else {
            wavsize *= (double)i;
        }
        ((Closeable)((Object)outf)).close();
        if (!this.lame.getParser().disable_wav_header) {
            RandomAccessFile rf = new RandomAccessFile(outPath, "rw");
            this.lame.getAudio().WriteWaveHeader(rf, (int)wavsize, this.lame.getFlags().getInSampleRate(), tmp_num_channels, 16);
            rf.close();
        }
        if (!this.lame.getParser().embedded) {
            System.out.print("|");
            for (int j = 0; j < 77; ++j) {
                System.out.print("=");
            }
            System.out.println("|");
        }
    }

    private void print_lame_tag_leading_info() {
        if (this.lame.getFlags().bWriteVbrTag) {
            System.out.println("Writing LAME Tag...");
        }
    }

    private void print_trailing_info() {
        if (this.lame.getFlags().bWriteVbrTag) {
            System.out.println("done\n");
        }
        if (this.lame.getFlags().isFindReplayGain()) {
            int RadioGain = this.lame.getFlags().internal_flags.RadioGain;
            System.out.printf("ReplayGain: %s%.1fdB\n", RadioGain > 0 ? "+" : "", Float.valueOf((float)RadioGain / 10.0f));
            if (RadioGain > 510 || RadioGain < -510) {
                System.out.println("WARNING: ReplayGain exceeds the -51dB to +51dB range. Such a result is too\n         high to be stored in the header.");
            }
        }
        if (this.lame.getParser().print_clipping_info && this.lame.getFlags().decode_on_the_fly) {
            float noclipGainChange = (float)this.lame.getFlags().internal_flags.noclipGainChange / 10.0f;
            float noclipScale = this.lame.getFlags().internal_flags.noclipScale;
            if ((double)noclipGainChange > 0.0) {
                System.out.printf("WARNING: clipping occurs at the current gain. Set your decoder to decrease\n         the  gain  by  at least %.1fdB or encode again ", Float.valueOf(noclipGainChange));
                if (noclipScale > 0.0f) {
                    System.out.printf(Locale.US, "using  --scale %.2f\n", Float.valueOf(noclipScale));
                    System.out.print("         or less (the value under --scale is approximate).\n");
                } else {
                    System.out.print("using --scale <arg>\n         (For   a   suggestion  on  the  optimal  value  of  <arg>  encode\n         with  --scale 1  first)\n");
                }
            } else if ((double)noclipGainChange > -0.1) {
                System.out.print("\nThe waveform does not clip and is less than 0.1dB away from full scale.\n");
            } else {
                System.out.printf("\nThe waveform does not clip and is at least %.1fdB away from full scale.\n", Float.valueOf(-noclipGainChange));
            }
        }
    }

    private int write_xing_frame(RandomAccessFile outf) {
        byte[] mp3buffer = new byte[147456];
        int imp3 = this.lame.getVbr().getLameTagFrame(this.lame.getFlags(), mp3buffer);
        if (imp3 > mp3buffer.length) {
            System.err.printf("Error writing LAME-tag frame: buffer too small: buffer size=%d  frame size=%d\n", mp3buffer.length, imp3);
            return -1;
        }
        if (imp3 <= 0) {
            return 0;
        }
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            System.err.println("Error writing LAME-tag");
            return -1;
        }
        return imp3;
    }

    private int lame_encoder(DataOutput outf, boolean nogap, String inPath, String outPath) {
        int iread;
        byte[] mp3buffer = new byte[147456];
        float[][] Buffer2 = new float[2][1152];
        this.encoder_progress_begin(inPath, outPath);
        int imp3 = this.lame.getId3().lame_get_id3v2_tag(this.lame.getFlags(), mp3buffer, mp3buffer.length);
        if (imp3 > mp3buffer.length) {
            this.encoder_progress_end();
            System.err.printf("Error writing ID3v2 tag: buffer too small: buffer size=%d  ID3v2 size=%d\n", mp3buffer.length, imp3);
            return 1;
        }
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            this.encoder_progress_end();
            System.err.printf("Error writing ID3v2 tag \n", new Object[0]);
            return 1;
        }
        int id3v2_size = imp3;
        do {
            if ((iread = this.lame.getAudio().get_audio(this.lame.getFlags(), Buffer2)) < 0) continue;
            this.encoder_progress();
            imp3 = this.lame.encodeBuffer(Buffer2[0], Buffer2[1], iread, mp3buffer);
            if (imp3 < 0) {
                if (imp3 == -1) {
                    System.err.printf("mp3 buffer is not big enough... \n", new Object[0]);
                } else {
                    System.err.printf("mp3 internal error:  error code=%d\n", imp3);
                }
                return 1;
            }
            try {
                outf.write(mp3buffer, 0, imp3);
            }
            catch (IOException e) {
                this.encoder_progress_end();
                System.err.printf("Error writing mp3 output \n", new Object[0]);
                return 1;
            }
        } while (iread > 0);
        imp3 = nogap ? this.lame.lame_encode_flush_nogap(mp3buffer, mp3buffer.length) : this.lame.encodeFlush(mp3buffer);
        if (imp3 < 0) {
            if (imp3 == -1) {
                System.err.printf("mp3 buffer is not big enough... \n", new Object[0]);
            } else {
                System.err.printf("mp3 internal error:  error code=%d\n", imp3);
            }
            return 1;
        }
        this.encoder_progress_end();
        try {
            outf.write(mp3buffer, 0, imp3);
        }
        catch (IOException e) {
            this.encoder_progress_end();
            System.err.printf("Error writing mp3 output \n", new Object[0]);
            return 1;
        }
        imp3 = this.lame.getId3().lame_get_id3v1_tag(this.lame.getFlags(), mp3buffer, mp3buffer.length);
        if (imp3 > mp3buffer.length) {
            System.err.printf("Error writing ID3v1 tag: buffer too small: buffer size=%d  ID3v1 size=%d\n", mp3buffer.length, imp3);
        } else if (imp3 > 0) {
            try {
                outf.write(mp3buffer, 0, imp3);
            }
            catch (IOException e) {
                this.encoder_progress_end();
                System.err.printf("Error writing ID3v1 tag \n", new Object[0]);
                return 1;
            }
        }
        if (this.lame.getParser().silent <= 0) {
            this.print_lame_tag_leading_info();
        }
        try {
            ((Closeable)((Object)outf)).close();
            RandomAccessFile rf = new RandomAccessFile(outPath, "rw");
            rf.seek(id3v2_size);
            this.write_xing_frame(rf);
            rf.close();
        }
        catch (IOException e) {
            System.err.printf("fatal error: can't update LAME-tag frame!\n", new Object[0]);
        }
        this.print_trailing_info();
        return 0;
    }

    private void brhist_init_package() {
        if (this.lame.getParser().brhist) {
            if (this.lame.getHist().brhist_init(this.lame.getFlags(), this.lame.getFlags().VBR_min_bitrate_kbps, this.lame.getFlags().VBR_max_bitrate_kbps) != 0) {
                this.lame.getParser().brhist = false;
            }
        } else {
            this.lame.getHist().brhist_init(this.lame.getFlags(), 128, 128);
        }
    }

    private void parse_nogap_filenames(int nogapout, String inPath, StringBuilder outPath, StringBuilder outdir) {
        outPath.setLength(0);
        outPath.append((CharSequence)outdir);
        if (0 == nogapout) {
            outPath.setLength(0);
            outPath.append(inPath);
            if (outPath.toString().endsWith(".wav")) {
                outPath.setLength(0);
                outPath.append(outPath.substring(0, outPath.length() - 4) + ".mp3");
            } else {
                outPath.setLength(0);
                outPath.append(outPath + ".mp3");
            }
        } else {
            int slasher = inPath.lastIndexOf(System.getProperty("file.separator"));
            if (slasher != 0 && (outPath.toString().endsWith(System.getProperty("file.separator")) || outPath.toString().endsWith(":"))) {
                ++slasher;
            } else if (slasher == 0 && (!outPath.toString().endsWith(System.getProperty("file.separator")) || outPath.toString().endsWith(":"))) {
                outPath.append(System.getProperty("file.separator"));
            }
            outPath.append(inPath.substring(slasher));
            if (outPath.toString().endsWith(".wav")) {
                String string = outPath.substring(0, outPath.length() - 4) + ".mp3";
                outPath.setLength(0);
                outPath.append(string);
            } else {
                String string = outPath + ".mp3";
                outPath.setLength(0);
                outPath.append(string);
            }
        }
    }

    public static final void main(String[] args) {
        try {
            new Main().run(args);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int run(String[] args) throws IOException {
        DataOutput outf;
        this.lame = new Lame();
        StringBuilder outPath = new StringBuilder();
        StringBuilder nogapdir = new StringBuilder();
        StringBuilder inPath = new StringBuilder();
        FrameSkip enc = new FrameSkip();
        int nogapout = 0;
        int max_nogap = 200;
        String[] nogap_inPath = new String[max_nogap];
        this.lame.getParser().setInputFormat(GetAudio.SoundFileFormat.sf_unknown);
        if (args.length < 1) {
            System.err.println(this.version.getVersion());
            System.err.println();
            this.usage.print(System.err);
            this.lame.close();
            return 1;
        }
        this.parse_args_from_string(System.getenv("LAMEOPT"), inPath, outPath);
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        Parse.NoGap ng = new Parse.NoGap();
        int ret = this.lame.getParser().parse_args(this.lame.getFlags(), argsList, inPath, outPath, nogap_inPath, ng);
        max_nogap = ng.num_nogap;
        if (ret < 0) {
            this.lame.close();
            return ret == -2 ? 0 : 1;
        }
        if ((double)this.lame.getParser().update_interval < 0.0) {
            this.lame.getParser().update_interval = 2.0f;
        }
        if (outPath.length() != 0 && max_nogap > 0) {
            nogapdir = outPath;
            nogapout = 1;
        }
        if (max_nogap > 0) {
            this.parse_nogap_filenames(nogapout, nogap_inPath[0], outPath, nogapdir);
            outf = this.init_files(nogap_inPath[0], outPath.toString(), enc);
        } else {
            outf = this.init_files(inPath.toString(), outPath.toString(), enc);
        }
        if (outf == null) {
            this.lame.close();
            return -1;
        }
        this.lame.getFlags().setWriteId3tagAutomatic(false);
        int rc = this.lame.initParams();
        if (rc < 0) {
            if (rc == -1) {
                this.usage.printBitrates(System.err);
            }
            System.err.println("fatal error during initialization");
            this.lame.close();
            return rc;
        }
        if (this.lame.getParser().silent > 0) {
            this.lame.getParser().brhist = false;
        }
        if (this.lame.getFlags().decode_only) {
            if (this.lame.getParser().mp3_delay_set) {
                this.lame_decoder(outf, this.lame.getParser().mp3_delay, inPath.toString(), outPath.toString(), enc);
            } else {
                this.lame_decoder(outf, 0, inPath.toString(), outPath.toString(), enc);
            }
        } else if (max_nogap > 0) {
            for (rc = 0; rc < max_nogap; ++rc) {
                boolean use_flush_nogap;
                boolean bl = use_flush_nogap = rc != max_nogap - 1;
                if (rc > 0) {
                    this.parse_nogap_filenames(nogapout, nogap_inPath[rc], outPath, nogapdir);
                    outf = this.init_files(nogap_inPath[rc], outPath.toString(), enc);
                    this.lame.lame_init_bitstream();
                }
                this.brhist_init_package();
                this.lame.getFlags().internal_flags.nogap_total = max_nogap;
                this.lame.getFlags().internal_flags.nogap_current = rc;
                ret = this.lame_encoder(outf, use_flush_nogap, nogap_inPath[rc], outPath.toString());
                ((Closeable)((Object)outf)).close();
                this.lame.getAudio().close_infile();
            }
        } else {
            this.brhist_init_package();
            ret = this.lame_encoder(outf, false, inPath.toString(), outPath.toString());
            ((Closeable)((Object)outf)).close();
            this.lame.getAudio().close_infile();
        }
        this.lame.close();
        return ret;
    }

    private void encoder_progress_begin(String inPath, String outPath) {
        if (this.lame.getParser().silent < 10) {
            this.lame.lame_print_config();
            System.out.printf("Encoding %s%s to %s\n", inPath, inPath.length() + outPath.length() < 66 ? "" : "\n     ", outPath);
            System.out.printf("Encoding as %g kHz ", 0.001 * (double)this.lame.getFlags().getOutSampleRate());
            String[][] mode_names = new String[][]{{"stereo", "j-stereo", "dual-ch", "single-ch"}, {"stereo", "force-ms", "dual-ch", "single-ch"}};
            switch (this.lame.getFlags().getVBR()) {
                case vbr_rh: {
                    System.out.printf("%s MPEG-%d%s Layer III VBR(q=%g) qval=%d\n", mode_names[this.lame.getFlags().force_ms ? 1 : 0][this.lame.getFlags().getMode().getNumMode()], 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", Float.valueOf((float)this.lame.getFlags().getVBRQuality() + this.lame.getFlags().VBR_q_frac), this.lame.getFlags().getQuality());
                    break;
                }
                case vbr_mt: 
                case vbr_mtrh: {
                    System.out.printf("%s MPEG-%d%s Layer III VBR(q=%d)\n", mode_names[this.lame.getFlags().force_ms ? 1 : 0][this.lame.getFlags().getMode().getNumMode()], 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", this.lame.getFlags().getQuality());
                    break;
                }
                case vbr_abr: {
                    System.out.printf("%s MPEG-%d%s Layer III (%gx) average %d kbps qval=%d\n", mode_names[this.lame.getFlags().force_ms ? 1 : 0][this.lame.getFlags().getMode().getNumMode()], 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", 0.1 * (double)((int)(10.0 * (double)this.lame.getFlags().compression_ratio + 0.5)), this.lame.getFlags().VBR_mean_bitrate_kbps, this.lame.getFlags().getQuality());
                    break;
                }
                default: {
                    System.out.printf("%s MPEG-%d%s Layer III (%gx) %3d kbps qval=%d\n", mode_names[this.lame.getFlags().force_ms ? 1 : 0][this.lame.getFlags().getMode().getNumMode()], 2 - this.lame.getFlags().getMpegVersion(), this.lame.getFlags().getOutSampleRate() < 16000 ? ".5" : "", 0.1 * (double)((int)(10.0 * (double)this.lame.getFlags().compression_ratio + 0.5)), this.lame.getFlags().getBitRate(), this.lame.getFlags().getQuality());
                }
            }
            if (this.lame.getParser().silent <= -10) {
                this.lame.lame_print_internals();
            }
            if (!this.lame.getParser().embedded) {
                System.out.print("|");
                for (int i = 0; i < 77; ++i) {
                    System.out.print("=");
                }
                System.out.println("|");
            }
            this.oldConsoleX = 0;
            this.curPercent = 0;
            this.oldPercent = 0;
        }
    }

    private void encoder_progress() {
        if (this.lame.getParser().silent <= 0 || this.lame.getParser().embedded) {
            int frames = this.lame.getFlags().frameNum;
            if (this.lame.getParser().update_interval <= 0.0f) {
                if (frames % 100 != 0) {
                    return;
                }
            } else {
                double act;
                double dif;
                if (frames != 0 && frames != 9 && (dif = (act = (double)System.currentTimeMillis()) - this.last_time) >= 0.0 && dif < (double)this.lame.getParser().update_interval) {
                    return;
                }
                this.last_time = System.currentTimeMillis();
            }
            if (this.lame.getParser().brhist) {
                this.lame.getHist().brhist_jump_back();
            }
            this.timestatus(this.lame.getFlags().frameNum, this.lame_get_totalframes());
            if (this.lame.getParser().brhist) {
                this.lame.getHist().brhist_disp(this.lame.getFlags());
            }
        }
    }

    private void encoder_progress_end() {
        if (this.lame.getParser().silent <= 0 || this.lame.getParser().embedded) {
            if (this.lame.getParser().brhist) {
                this.lame.getHist().brhist_jump_back();
            }
            this.timestatus(this.lame.getFlags().frameNum, this.lame_get_totalframes());
            if (this.lame.getParser().brhist) {
                this.lame.getHist().brhist_disp(this.lame.getFlags());
            }
            if (!this.lame.getParser().embedded) {
                System.out.print("|");
                for (int i = 0; i < 77; ++i) {
                    System.out.print("=");
                }
                System.out.println("|");
            }
        }
    }

    private void timestatus(int frameNum, int totalframes) {
        int percent = frameNum < totalframes ? (int)(100.0 * (double)frameNum / (double)totalframes + 0.5) : 100;
        if (this.oldPercent != percent) {
            this.progressStep();
        }
        this.oldPercent = percent;
    }

    private void progressStep() {
        ++this.curPercent;
        float consoleX = (float)this.curPercent * 79.0f / 100.0f;
        if ((int)consoleX != this.oldConsoleX && !this.lame.getParser().embedded) {
            System.out.print(".");
        }
        this.oldConsoleX = (int)consoleX;
        this.support.firePropertyChange("progress", this.oldPercent, this.curPercent);
    }

    private int lame_get_totalframes() {
        int totalframes = (int)(2.0 + (double)this.lame.getFlags().num_samples * (double)this.lame.getFlags().getOutSampleRate() / ((double)this.lame.getFlags().getInSampleRate() * (double)this.lame.getFlags().getFrameSize()));
        return totalframes;
    }

    private void WriteBytesSwapped(DataOutput fp, float[] p, int pPos) throws IOException {
        fp.writeShort((int)p[pPos]);
    }

    private void WriteBytes(DataOutput fp, float[] p, int pPos) throws IOException {
        fp.write((int)p[pPos] & 0xFF);
        fp.write(((int)p[pPos] & 0xFFFF) >> 8 & 0xFF);
    }
}

