/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import mp3.ABRIterationLoop;
import mp3.ATH;
import mp3.BRHist;
import mp3.BitStream;
import mp3.CBRNewIterationLoop;
import mp3.Encoder;
import mp3.GainAnalysis;
import mp3.GetAudio;
import mp3.ID3Tag;
import mp3.LameGlobalFlags;
import mp3.LameInternalFlags;
import mp3.MPEGMode;
import mp3.PSY;
import mp3.Parse;
import mp3.Presets;
import mp3.PsyModel;
import mp3.Quantize;
import mp3.QuantizePVT;
import mp3.ReplayGain;
import mp3.Reservoir;
import mp3.ShortBlock;
import mp3.Tables;
import mp3.Takehiro;
import mp3.VBRNewIterationLoop;
import mp3.VBROldIterationLoop;
import mp3.VBRTag;
import mp3.VbrMode;
import mp3.Version;
import mpg.Interface;
import mpg.MPGLib;

public class Lame {
    public static final int QUALITY_LOWEST = 9;
    public static final int QUALITY_LOW = 7;
    public static final int QUALITY_MIDDLE_LOW = 6;
    public static final int QUALITY_MIDDLE = 5;
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_HIGHEST = 1;
    private static final int QUALITY_DEFAULT = 3;
    private LameGlobalFlags gfp;
    private GainAnalysis ga;
    private BitStream bs;
    private Presets p;
    private QuantizePVT qupvt;
    private Quantize qu;
    private PsyModel psy;
    private VBRTag vbr;
    private ID3Tag id3;
    private MPGLib mpglib;
    private Encoder enc;
    private GetAudio gaud;
    private Reservoir rv;
    private Takehiro tak;
    private Parse parse;
    private BRHist hist;
    private MPGLib mpg;
    private Interface intf;
    private Version version = new Version();
    public static final long LAME_ID = -487877L;
    public static final int V9 = 410;
    public static final int V8 = 420;
    public static final int V7 = 430;
    public static final int V6 = 440;
    public static final int V5 = 450;
    public static final int V4 = 460;
    public static final int V3 = 470;
    public static final int V2 = 480;
    public static final int V1 = 490;
    public static final int V0 = 500;
    public static final int R3MIX = 1000;
    public static final int STANDARD = 1001;
    public static final int EXTREME = 1002;
    public static final int INSANE = 1003;
    public static final int STANDARD_FAST = 1004;
    public static final int EXTREME_FAST = 1005;
    public static final int MEDIUM = 1006;
    public static final int MEDIUM_FAST = 1007;
    static final int LAME_MAXALBUMART = 131072;
    public static final int LAME_MAXMP3BUFFER = 147456;

    public Lame() {
        this.gfp = new LameGlobalFlags();
        this.gaud = new GetAudio();
        this.ga = new GainAnalysis();
        this.bs = new BitStream();
        this.p = new Presets();
        this.qupvt = new QuantizePVT();
        this.qu = new Quantize();
        this.vbr = new VBRTag();
        this.id3 = new ID3Tag();
        this.rv = new Reservoir();
        this.tak = new Takehiro();
        this.parse = new Parse();
        this.hist = new BRHist();
        this.psy = new PsyModel();
        this.enc = new Encoder();
        this.mpg = new MPGLib();
        this.intf = new Interface();
        this.enc.setModules(this.bs, this.psy, this.qupvt, this.vbr);
        this.bs.setModules(this.ga, this.mpg, this.vbr);
        this.id3.setModules(this.bs);
        this.p.setModules(this);
        this.qu.setModules(this.bs, this.rv, this.qupvt, this.tak);
        this.qupvt.setModules(this.tak, this.rv, this.enc.psy);
        this.rv.setModules(this.bs);
        this.tak.setModules(this.qupvt);
        this.vbr.setModules(this, this.bs);
        this.gaud.setModules(this.parse, this.mpg);
        this.parse.setModules(this.id3, this.p);
        this.mpg.setModules(this.intf);
        this.intf.setModules(this.vbr);
        this.lame_init();
    }

    public LameGlobalFlags getFlags() {
        return this.gfp;
    }

    public Parse getParser() {
        return this.parse;
    }

    public GetAudio getAudio() {
        return this.gaud;
    }

    public VBRTag getVbr() {
        return this.vbr;
    }

    public ID3Tag getId3() {
        return this.id3;
    }

    public BRHist getHist() {
        return this.hist;
    }

    private float filter_coef(float x) {
        if ((double)x > 1.0) {
            return 0.0f;
        }
        if ((double)x <= 0.0) {
            return 1.0f;
        }
        return (float)Math.cos(1.5707963267948966 * (double)x);
    }

    private void lame_init_params_ppflt() {
        float freq;
        int band;
        LameInternalFlags gfc = this.gfp.internal_flags;
        int lowpass_band = 32;
        int highpass_band = -1;
        if (gfc.lowpass1 > 0.0f) {
            int minband = 999;
            for (band = 0; band <= 31; ++band) {
                freq = (float)((double)band / 31.0);
                if (freq >= gfc.lowpass2) {
                    lowpass_band = Math.min(lowpass_band, band);
                }
                if (!(gfc.lowpass1 < freq) || !(freq < gfc.lowpass2)) continue;
                minband = Math.min(minband, band);
            }
            gfc.lowpass1 = minband == 999 ? ((float)lowpass_band - 0.75f) / 31.0f : ((float)minband - 0.75f) / 31.0f;
            gfc.lowpass2 = (float)lowpass_band / 31.0f;
        }
        if (gfc.highpass2 > 0.0f && (double)gfc.highpass2 < 0.021774193548387097) {
            gfc.highpass1 = 0.0f;
            gfc.highpass2 = 0.0f;
            System.err.println("Warning: highpass filter disabled.  highpass frequency too small\n");
        }
        if (gfc.highpass2 > 0.0f) {
            int maxband = -1;
            for (band = 0; band <= 31; ++band) {
                freq = (float)band / 31.0f;
                if (freq <= gfc.highpass1) {
                    highpass_band = Math.max(highpass_band, band);
                }
                if (!(gfc.highpass1 < freq) || !(freq < gfc.highpass2)) continue;
                maxband = Math.max(maxband, band);
            }
            gfc.highpass1 = (float)highpass_band / 31.0f;
            gfc.highpass2 = maxband == -1 ? ((float)highpass_band + 0.75f) / 31.0f : ((float)maxband + 0.75f) / 31.0f;
        }
        for (int band2 = 0; band2 < 32; ++band2) {
            float freq2 = (float)band2 / 31.0f;
            double fc1 = gfc.highpass2 > gfc.highpass1 ? (double)this.filter_coef((gfc.highpass2 - freq2) / (gfc.highpass2 - gfc.highpass1 + 1.0E-20f)) : 1.0;
            double fc2 = gfc.lowpass2 > gfc.lowpass1 ? (double)this.filter_coef((freq2 - gfc.lowpass1) / (gfc.lowpass2 - gfc.lowpass1 + 1.0E-20f)) : 1.0;
            gfc.amp_filter[band2] = (float)(fc1 * fc2);
        }
    }

    private void optimum_bandwidth(LowPassHighPass lh, int bitrate) {
        BandPass[] freq_map = new BandPass[]{new BandPass(8, 2000), new BandPass(16, 3700), new BandPass(24, 3900), new BandPass(32, 5500), new BandPass(40, 7000), new BandPass(48, 7500), new BandPass(56, 10000), new BandPass(64, 11000), new BandPass(80, 13500), new BandPass(96, 15100), new BandPass(112, 15600), new BandPass(128, 17000), new BandPass(160, 17500), new BandPass(192, 18600), new BandPass(224, 19400), new BandPass(256, 19700), new BandPass(320, 20500)};
        int table_index = this.nearestBitrateFullIndex(bitrate);
        lh.lowerlimit = freq_map[table_index].lowpass;
    }

    private int optimum_samplefreq(int lowpassfreq, int input_samplefreq) {
        int suggested_samplefreq = 44100;
        if (input_samplefreq >= 48000) {
            suggested_samplefreq = 48000;
        } else if (input_samplefreq >= 44100) {
            suggested_samplefreq = 44100;
        } else if (input_samplefreq >= 32000) {
            suggested_samplefreq = 32000;
        } else if (input_samplefreq >= 24000) {
            suggested_samplefreq = 24000;
        } else if (input_samplefreq >= 22050) {
            suggested_samplefreq = 22050;
        } else if (input_samplefreq >= 16000) {
            suggested_samplefreq = 16000;
        } else if (input_samplefreq >= 12000) {
            suggested_samplefreq = 12000;
        } else if (input_samplefreq >= 11025) {
            suggested_samplefreq = 11025;
        } else if (input_samplefreq >= 8000) {
            suggested_samplefreq = 8000;
        }
        if (lowpassfreq == -1) {
            return suggested_samplefreq;
        }
        if (lowpassfreq <= 15960) {
            suggested_samplefreq = 44100;
        }
        if (lowpassfreq <= 15250) {
            suggested_samplefreq = 32000;
        }
        if (lowpassfreq <= 11220) {
            suggested_samplefreq = 24000;
        }
        if (lowpassfreq <= 9970) {
            suggested_samplefreq = 22050;
        }
        if (lowpassfreq <= 7230) {
            suggested_samplefreq = 16000;
        }
        if (lowpassfreq <= 5420) {
            suggested_samplefreq = 12000;
        }
        if (lowpassfreq <= 4510) {
            suggested_samplefreq = 11025;
        }
        if (lowpassfreq <= 3970) {
            suggested_samplefreq = 8000;
        }
        if (input_samplefreq < suggested_samplefreq) {
            if (input_samplefreq > 44100) {
                return 48000;
            }
            if (input_samplefreq > 32000) {
                return 44100;
            }
            if (input_samplefreq > 24000) {
                return 32000;
            }
            if (input_samplefreq > 22050) {
                return 24000;
            }
            if (input_samplefreq > 16000) {
                return 22050;
            }
            if (input_samplefreq > 12000) {
                return 16000;
            }
            if (input_samplefreq > 11025) {
                return 12000;
            }
            if (input_samplefreq > 8000) {
                return 11025;
            }
            return 8000;
        }
        return suggested_samplefreq;
    }

    private void lame_init_qval() {
        LameInternalFlags gfc = this.gfp.internal_flags;
        switch (this.gfp.getQuality()) {
            default: {
                gfc.psymodel = 0;
                gfc.noise_shaping = 0;
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 8: {
                this.gfp.setQuality(7);
            }
            case 7: {
                gfc.psymodel = 1;
                gfc.noise_shaping = 0;
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 6: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 5: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 0;
                gfc.full_outer_loop = 0;
                break;
            }
            case 4: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 0;
                gfc.noise_shaping_stop = 0;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 3: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                gfc.noise_shaping_amp = 1;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 2: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 1;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 1: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 2;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
                break;
            }
            case 0: {
                gfc.psymodel = 1;
                if (gfc.noise_shaping == 0) {
                    gfc.noise_shaping = 1;
                }
                if (gfc.substep_shaping == 0) {
                    gfc.substep_shaping = 2;
                }
                gfc.noise_shaping_amp = 2;
                gfc.noise_shaping_stop = 1;
                if (gfc.subblock_gain == -1) {
                    gfc.subblock_gain = 1;
                }
                gfc.use_best_huffman = 1;
                gfc.full_outer_loop = 0;
            }
        }
    }

    private double linear_int(double a, double b, double m) {
        return a + m * (b - a);
    }

    private int FindNearestBitrate(int bRate, int version, int samplerate) {
        if (samplerate < 16000) {
            version = 2;
        }
        int bitrate = Tables.bitrate_table[version][1];
        for (int i = 2; i <= 14; ++i) {
            if (Tables.bitrate_table[version][i] <= 0 || Math.abs(Tables.bitrate_table[version][i] - bRate) >= Math.abs(bitrate - bRate)) continue;
            bitrate = Tables.bitrate_table[version][i];
        }
        return bitrate;
    }

    public final int nearestBitrateFullIndex(int bitrate) {
        int[] full_bitrate_table = new int[]{8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
        int lower_range = 0;
        int lower_range_kbps = 0;
        int upper_range = 0;
        int upper_range_kbps = 0;
        upper_range_kbps = full_bitrate_table[16];
        upper_range = 16;
        lower_range_kbps = full_bitrate_table[16];
        lower_range = 16;
        for (int b = 0; b < 16; ++b) {
            if (Math.max(bitrate, full_bitrate_table[b + 1]) == bitrate) continue;
            upper_range_kbps = full_bitrate_table[b + 1];
            upper_range = b + 1;
            lower_range_kbps = full_bitrate_table[b];
            lower_range = b;
            break;
        }
        if (upper_range_kbps - bitrate > bitrate - lower_range_kbps) {
            return lower_range;
        }
        return upper_range;
    }

    private int map2MP3Frequency(int freq) {
        if (freq <= 8000) {
            return 8000;
        }
        if (freq <= 11025) {
            return 11025;
        }
        if (freq <= 12000) {
            return 12000;
        }
        if (freq <= 16000) {
            return 16000;
        }
        if (freq <= 22050) {
            return 22050;
        }
        if (freq <= 24000) {
            return 24000;
        }
        if (freq <= 32000) {
            return 32000;
        }
        if (freq <= 44100) {
            return 44100;
        }
        return 48000;
    }

    private int SmpFrqIndex(int sample_freq) {
        switch (sample_freq) {
            case 44100: {
                this.gfp.setMpegVersion(1);
                return 0;
            }
            case 48000: {
                this.gfp.setMpegVersion(1);
                return 1;
            }
            case 32000: {
                this.gfp.setMpegVersion(1);
                return 2;
            }
            case 22050: {
                this.gfp.setMpegVersion(0);
                return 0;
            }
            case 24000: {
                this.gfp.setMpegVersion(0);
                return 1;
            }
            case 16000: {
                this.gfp.setMpegVersion(0);
                return 2;
            }
            case 11025: {
                this.gfp.setMpegVersion(0);
                return 0;
            }
            case 12000: {
                this.gfp.setMpegVersion(0);
                return 1;
            }
            case 8000: {
                this.gfp.setMpegVersion(0);
                return 2;
            }
        }
        this.gfp.setMpegVersion(0);
        return -1;
    }

    public final int BitrateIndex(int bRate, int version, int samplerate) {
        if (samplerate < 16000) {
            version = 2;
        }
        for (int i = 0; i <= 14; ++i) {
            if (Tables.bitrate_table[version][i] <= 0 || Tables.bitrate_table[version][i] != bRate) continue;
            return i;
        }
        return -1;
    }

    private float blackman(float x, float fcn, int l) {
        float wcn = (float)(Math.PI * (double)fcn);
        if ((x /= (float)l) < 0.0f) {
            x = 0.0f;
        }
        if (x > 1.0f) {
            x = 1.0f;
        }
        float x2 = x - 0.5f;
        float bkwn = 0.42f - 0.5f * (float)Math.cos((double)(2.0f * x) * Math.PI) + 0.08f * (float)Math.cos((double)(4.0f * x) * Math.PI);
        if ((double)Math.abs(x2) < 1.0E-9) {
            return (float)((double)wcn / Math.PI);
        }
        return (float)((double)bkwn * Math.sin((float)l * wcn * x2) / (Math.PI * (double)l * (double)x2));
    }

    private int gcd(int i, int j) {
        return j != 0 ? this.gcd(j, i % j) : i;
    }

    private int fill_buffer_resample(float[] outbuf, int outbufPos, int desired_len, float[] inbuf, int in_bufferPos, int len, NumUsed num_used, int ch) {
        double time0;
        int k;
        int i;
        int filter_l;
        LameInternalFlags gfc = this.gfp.internal_flags;
        int j = 0;
        int bpc = this.gfp.getOutSampleRate() / this.gcd(this.gfp.getOutSampleRate(), this.gfp.getInSampleRate());
        if (bpc > 320) {
            bpc = 320;
        }
        float intratio = Math.abs(gfc.resample_ratio - Math.floor(0.5 + gfc.resample_ratio)) < 1.0E-4 ? 1.0f : 0.0f;
        float fcn = 1.0f / (float)gfc.resample_ratio;
        if ((double)fcn > 1.0) {
            fcn = 1.0f;
        }
        if (0 == (filter_l = 31) % 2) {
            --filter_l;
        }
        filter_l = (int)((float)filter_l + intratio);
        int BLACKSIZE = filter_l + 1;
        if (gfc.fill_buffer_resample_init == 0) {
            gfc.inbuf_old[0] = new float[BLACKSIZE];
            gfc.inbuf_old[1] = new float[BLACKSIZE];
            for (i = 0; i <= 2 * bpc; ++i) {
                gfc.blackfilt[i] = new float[BLACKSIZE];
            }
            gfc.itime[0] = 0.0;
            gfc.itime[1] = 0.0;
            for (j = 0; j <= 2 * bpc; ++j) {
                float sum = 0.0f;
                float offset = (float)(j - bpc) / (2.0f * (float)bpc);
                for (i = 0; i <= filter_l; ++i) {
                    float f = this.blackman((float)i - offset, fcn, filter_l);
                    gfc.blackfilt[j][i] = f;
                    sum += f;
                }
                i = 0;
                while (i <= filter_l) {
                    float[] fArray = gfc.blackfilt[j];
                    int n = i++;
                    fArray[n] = fArray[n] / sum;
                }
            }
            gfc.fill_buffer_resample_init = 1;
        }
        float[] inbuf_old = gfc.inbuf_old[ch];
        for (k = 0; k < desired_len && filter_l + (j = (int)Math.floor((time0 = (double)k * gfc.resample_ratio) - gfc.itime[ch])) - filter_l / 2 < len; ++k) {
            float offset = (float)(time0 - gfc.itime[ch] - ((double)j + 0.5 * (double)(filter_l % 2)));
            assert ((double)Math.abs(offset) <= 0.501);
            int joff = (int)Math.floor((double)(offset * 2.0f * (float)bpc + (float)bpc) + 0.5);
            float xvalue = 0.0f;
            for (i = 0; i <= filter_l; ++i) {
                int j2 = i + j - filter_l / 2;
                assert (j2 < len);
                assert (j2 + BLACKSIZE >= 0);
                float y = j2 < 0 ? inbuf_old[BLACKSIZE + j2] : inbuf[in_bufferPos + j2];
                xvalue += y * gfc.blackfilt[joff][i];
            }
            outbuf[outbufPos + k] = xvalue;
        }
        num_used.num_used = Math.min(len, filter_l + j - filter_l / 2);
        int n = ch;
        gfc.itime[n] = gfc.itime[n] + ((double)num_used.num_used - (double)k * gfc.resample_ratio);
        if (num_used.num_used >= BLACKSIZE) {
            for (i = 0; i < BLACKSIZE; ++i) {
                inbuf_old[i] = inbuf[in_bufferPos + num_used.num_used + i - BLACKSIZE];
            }
        } else {
            int n_shift = BLACKSIZE - num_used.num_used;
            for (i = 0; i < n_shift; ++i) {
                inbuf_old[i] = inbuf_old[i + num_used.num_used];
            }
            j = 0;
            while (i < BLACKSIZE) {
                inbuf_old[i] = inbuf[in_bufferPos + j];
                ++i;
                ++j;
            }
            assert (j == num_used.num_used);
        }
        return k;
    }

    private void fill_buffer(float[][] mfbuf, float[][] in_buffer, int in_bufferPos, int nsamples, InOut io) {
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (gfc.resample_ratio < 0.9999 || gfc.resample_ratio > 1.0001) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                NumUsed numUsed = new NumUsed();
                io.n_out = this.fill_buffer_resample(mfbuf[ch], gfc.mf_size, this.gfp.getFrameSize(), in_buffer[ch], in_bufferPos, nsamples, numUsed, ch);
                io.n_in = numUsed.num_used;
            }
        } else {
            io.n_in = io.n_out = Math.min(this.gfp.getFrameSize(), nsamples);
            for (int i = 0; i < io.n_out; ++i) {
                mfbuf[0][gfc.mf_size + i] = in_buffer[0][in_bufferPos + i];
                if (gfc.channels_out != 2) continue;
                mfbuf[1][gfc.mf_size + i] = in_buffer[1][in_bufferPos + i];
            }
        }
    }

    public final int initParams() {
        int i;
        LameInternalFlags gfc = this.gfp.internal_flags;
        gfc.Class_ID = 0L;
        if (gfc.ATH == null) {
            gfc.ATH = new ATH();
        }
        if (gfc.PSY == null) {
            gfc.PSY = new PSY();
        }
        if (gfc.rgdata == null) {
            gfc.rgdata = new ReplayGain();
        }
        gfc.channels_in = this.gfp.getInNumChannels();
        if (gfc.channels_in == 1) {
            this.gfp.setMode(MPEGMode.MONO);
        }
        gfc.channels_out = this.gfp.getMode() == MPEGMode.MONO ? 1 : 2;
        gfc.mode_ext = 2;
        if (this.gfp.getMode() == MPEGMode.MONO) {
            this.gfp.force_ms = false;
        }
        if (this.gfp.getVBR() == VbrMode.vbr_off && this.gfp.VBR_mean_bitrate_kbps != 128 && this.gfp.getBitRate() == 0) {
            this.gfp.setBitRate(this.gfp.VBR_mean_bitrate_kbps);
        }
        if (this.gfp.getVBR() != VbrMode.vbr_off && this.gfp.getVBR() != VbrMode.vbr_mtrh && this.gfp.getVBR() != VbrMode.vbr_mt) {
            this.gfp.free_format = false;
        }
        if (this.gfp.getVBR() == VbrMode.vbr_off && this.gfp.getBitRate() == 0 && BitStream.EQ(this.gfp.compression_ratio, 0.0f)) {
            this.gfp.compression_ratio = 11.025f;
        }
        if (this.gfp.getVBR() == VbrMode.vbr_off && this.gfp.compression_ratio > 0.0f) {
            if (this.gfp.getOutSampleRate() == 0) {
                this.gfp.setOutSampleRate(this.map2MP3Frequency((int)(0.97 * (double)this.gfp.getInSampleRate())));
            }
            this.gfp.setBitRate((int)((float)(this.gfp.getOutSampleRate() * 16 * gfc.channels_out) / (1000.0f * this.gfp.compression_ratio)));
            gfc.samplerate_index = this.SmpFrqIndex(this.gfp.getOutSampleRate());
            if (!this.gfp.free_format) {
                this.gfp.setBitRate(this.FindNearestBitrate(this.gfp.getBitRate(), this.gfp.getMpegVersion(), this.gfp.getOutSampleRate()));
            }
        }
        if (this.gfp.getOutSampleRate() != 0) {
            if (this.gfp.getOutSampleRate() < 16000) {
                this.gfp.VBR_mean_bitrate_kbps = Math.max(this.gfp.VBR_mean_bitrate_kbps, 8);
                this.gfp.VBR_mean_bitrate_kbps = Math.min(this.gfp.VBR_mean_bitrate_kbps, 64);
            } else if (this.gfp.getOutSampleRate() < 32000) {
                this.gfp.VBR_mean_bitrate_kbps = Math.max(this.gfp.VBR_mean_bitrate_kbps, 8);
                this.gfp.VBR_mean_bitrate_kbps = Math.min(this.gfp.VBR_mean_bitrate_kbps, 160);
            } else {
                this.gfp.VBR_mean_bitrate_kbps = Math.max(this.gfp.VBR_mean_bitrate_kbps, 32);
                this.gfp.VBR_mean_bitrate_kbps = Math.min(this.gfp.VBR_mean_bitrate_kbps, 320);
            }
        }
        if (this.gfp.lowpassfreq == 0) {
            double lowpass = 16000.0;
            switch (this.gfp.getVBR()) {
                case vbr_off: {
                    LowPassHighPass lh = new LowPassHighPass();
                    this.optimum_bandwidth(lh, this.gfp.getBitRate());
                    lowpass = lh.lowerlimit;
                    break;
                }
                case vbr_abr: {
                    LowPassHighPass lh = new LowPassHighPass();
                    this.optimum_bandwidth(lh, this.gfp.VBR_mean_bitrate_kbps);
                    lowpass = lh.lowerlimit;
                    break;
                }
                case vbr_rh: {
                    double m;
                    double b;
                    double a;
                    int[] x = new int[]{19500, 19000, 18600, 18000, 17500, 16000, 15600, 14900, 12500, 10000, 3950};
                    if (0 <= this.gfp.getVBRQuality() && this.gfp.getVBRQuality() <= 9) {
                        a = x[this.gfp.getVBRQuality()];
                        b = x[this.gfp.getVBRQuality() + 1];
                        m = this.gfp.VBR_q_frac;
                        lowpass = this.linear_int(a, b, m);
                        break;
                    }
                    lowpass = 19500.0;
                    break;
                }
                default: {
                    double m;
                    double b;
                    double a;
                    int[] x = new int[]{19500, 19000, 18500, 18000, 17500, 16500, 15500, 14500, 12500, 9500, 3950};
                    if (0 <= this.gfp.getVBRQuality() && this.gfp.getVBRQuality() <= 9) {
                        a = x[this.gfp.getVBRQuality()];
                        b = x[this.gfp.getVBRQuality() + 1];
                        m = this.gfp.VBR_q_frac;
                        lowpass = this.linear_int(a, b, m);
                        break;
                    }
                    lowpass = 19500.0;
                }
            }
            if (this.gfp.getMode() == MPEGMode.MONO && (this.gfp.getVBR() == VbrMode.vbr_off || this.gfp.getVBR() == VbrMode.vbr_abr)) {
                lowpass *= 1.5;
            }
            this.gfp.lowpassfreq = (int)lowpass;
        }
        if (this.gfp.getOutSampleRate() == 0) {
            if (2 * this.gfp.lowpassfreq > this.gfp.getInSampleRate()) {
                this.gfp.lowpassfreq = this.gfp.getInSampleRate() / 2;
            }
            this.gfp.setOutSampleRate(this.optimum_samplefreq(this.gfp.lowpassfreq, this.gfp.getInSampleRate()));
        }
        this.gfp.lowpassfreq = Math.min(20500, this.gfp.lowpassfreq);
        this.gfp.lowpassfreq = Math.min(this.gfp.getOutSampleRate() / 2, this.gfp.lowpassfreq);
        if (this.gfp.getVBR() == VbrMode.vbr_off) {
            this.gfp.compression_ratio = (float)(this.gfp.getOutSampleRate() * 16 * gfc.channels_out) / (1000.0f * (float)this.gfp.getBitRate());
        }
        if (this.gfp.getVBR() == VbrMode.vbr_abr) {
            this.gfp.compression_ratio = (float)(this.gfp.getOutSampleRate() * 16 * gfc.channels_out) / (1000.0f * (float)this.gfp.VBR_mean_bitrate_kbps);
        }
        if (!this.gfp.bWriteVbrTag) {
            this.gfp.setFindReplayGain(false);
            this.gfp.decode_on_the_fly = false;
            gfc.findPeakSample = false;
        }
        gfc.findReplayGain = this.gfp.isFindReplayGain();
        gfc.decode_on_the_fly = this.gfp.decode_on_the_fly;
        if (gfc.decode_on_the_fly) {
            gfc.findPeakSample = true;
        }
        if (gfc.findReplayGain && this.ga.InitGainAnalysis(gfc.rgdata, this.gfp.getOutSampleRate()) == 0) {
            this.gfp.internal_flags = null;
            return -6;
        }
        if (gfc.decode_on_the_fly && !this.gfp.decode_only) {
            if (gfc.hip != null) {
                this.mpglib.hip_decode_exit(gfc.hip);
            }
            gfc.hip = this.mpglib.hip_decode_init();
        }
        gfc.mode_gr = this.gfp.getOutSampleRate() <= 24000 ? 1 : 2;
        this.gfp.setFrameSize(576 * gfc.mode_gr);
        this.gfp.setEncoderDelay(576);
        gfc.resample_ratio = (double)this.gfp.getInSampleRate() / (double)this.gfp.getOutSampleRate();
        switch (this.gfp.getVBR()) {
            case vbr_rh: 
            case vbr_mt: 
            case vbr_mtrh: {
                float[] cmp = new float[]{5.7f, 6.5f, 7.3f, 8.2f, 10.0f, 11.9f, 13.0f, 14.0f, 15.0f, 16.5f};
                this.gfp.compression_ratio = cmp[this.gfp.getVBRQuality()];
                break;
            }
            case vbr_abr: {
                this.gfp.compression_ratio = (float)(this.gfp.getOutSampleRate() * 16 * gfc.channels_out) / (1000.0f * (float)this.gfp.VBR_mean_bitrate_kbps);
                break;
            }
            default: {
                this.gfp.compression_ratio = (float)(this.gfp.getOutSampleRate() * 16 * gfc.channels_out) / (1000.0f * (float)this.gfp.getBitRate());
            }
        }
        if (this.gfp.getMode() == MPEGMode.NOT_SET) {
            this.gfp.setMode(MPEGMode.JOINT_STEREO);
        }
        if (this.gfp.highpassfreq > 0) {
            gfc.highpass1 = 2.0f * (float)this.gfp.highpassfreq;
            gfc.highpass2 = this.gfp.highpasswidth >= 0 ? 2.0f * (float)(this.gfp.highpassfreq + this.gfp.highpasswidth) : 2.0f * (float)this.gfp.highpassfreq;
            gfc.highpass1 /= (float)this.gfp.getOutSampleRate();
            gfc.highpass2 /= (float)this.gfp.getOutSampleRate();
        } else {
            gfc.highpass1 = 0.0f;
            gfc.highpass2 = 0.0f;
        }
        if (this.gfp.lowpassfreq > 0) {
            gfc.lowpass2 = 2.0f * (float)this.gfp.lowpassfreq;
            if (this.gfp.lowpasswidth >= 0) {
                gfc.lowpass1 = 2.0f * (float)(this.gfp.lowpassfreq - this.gfp.lowpasswidth);
                if (gfc.lowpass1 < 0.0f) {
                    gfc.lowpass1 = 0.0f;
                }
            } else {
                gfc.lowpass1 = 2.0f * (float)this.gfp.lowpassfreq;
            }
            gfc.lowpass1 /= (float)this.gfp.getOutSampleRate();
            gfc.lowpass2 /= (float)this.gfp.getOutSampleRate();
        } else {
            gfc.lowpass1 = 0.0f;
            gfc.lowpass2 = 0.0f;
        }
        this.lame_init_params_ppflt();
        gfc.samplerate_index = this.SmpFrqIndex(this.gfp.getOutSampleRate());
        if (gfc.samplerate_index < 0) {
            this.gfp.internal_flags = null;
            return -1;
        }
        if (this.gfp.getVBR() == VbrMode.vbr_off) {
            if (this.gfp.free_format) {
                gfc.bitrate_index = 0;
            } else {
                this.gfp.setBitRate(this.FindNearestBitrate(this.gfp.getBitRate(), this.gfp.getMpegVersion(), this.gfp.getOutSampleRate()));
                gfc.bitrate_index = this.BitrateIndex(this.gfp.getBitRate(), this.gfp.getMpegVersion(), this.gfp.getOutSampleRate());
                if (gfc.bitrate_index <= 0) {
                    this.gfp.internal_flags = null;
                    return -1;
                }
            }
        } else {
            gfc.bitrate_index = 1;
        }
        if (this.gfp.analysis) {
            this.gfp.bWriteVbrTag = false;
        }
        if (gfc.pinfo != null) {
            this.gfp.bWriteVbrTag = false;
        }
        this.bs.init_bit_stream_w(gfc);
        int j = gfc.samplerate_index + 3 * this.gfp.getMpegVersion() + 6 * (this.gfp.getOutSampleRate() < 16000 ? 1 : 0);
        for (i = 0; i < 23; ++i) {
            gfc.scalefac_band.l[i] = this.qupvt.sfBandIndex[j].l[i];
        }
        for (i = 0; i < 7; ++i) {
            int start;
            int size = (gfc.scalefac_band.l[22] - gfc.scalefac_band.l[21]) / 6;
            gfc.scalefac_band.psfb21[i] = start = gfc.scalefac_band.l[21] + i * size;
        }
        gfc.scalefac_band.psfb21[6] = 576;
        for (i = 0; i < 14; ++i) {
            gfc.scalefac_band.s[i] = this.qupvt.sfBandIndex[j].s[i];
        }
        for (i = 0; i < 7; ++i) {
            int start;
            int size = (gfc.scalefac_band.s[13] - gfc.scalefac_band.s[12]) / 6;
            gfc.scalefac_band.psfb12[i] = start = gfc.scalefac_band.s[12] + i * size;
        }
        gfc.scalefac_band.psfb12[6] = 192;
        if (this.gfp.getMpegVersion() == 1) {
            gfc.sideinfo_len = gfc.channels_out == 1 ? 21 : 36;
        } else {
            int n = gfc.sideinfo_len = gfc.channels_out == 1 ? 13 : 21;
        }
        if (this.gfp.error_protection) {
            gfc.sideinfo_len += 2;
        }
        this.lame_init_bitstream();
        gfc.Class_ID = -487877L;
        for (int k = 0; k < 19; ++k) {
            gfc.nsPsy.pefirbuf[k] = 700 * gfc.mode_gr * gfc.channels_out;
        }
        if (this.gfp.ATHtype == -1) {
            this.gfp.ATHtype = 4;
        }
        assert (this.gfp.getVBRQuality() <= 9);
        assert (this.gfp.getVBRQuality() >= 0);
        switch (this.gfp.getVBR()) {
            case vbr_mt: {
                this.gfp.setVBR(VbrMode.vbr_mtrh);
            }
            case vbr_mtrh: {
                if (this.gfp.useTemporal == null) {
                    this.gfp.useTemporal = false;
                }
                this.p.apply_preset(this.gfp, 500 - this.gfp.getVBRQuality() * 10, 0);
                if (this.gfp.getQuality() < 0) {
                    this.gfp.setQuality(3);
                }
                if (this.gfp.getQuality() < 5) {
                    this.gfp.setQuality(0);
                }
                if (this.gfp.getQuality() > 5) {
                    this.gfp.setQuality(5);
                }
                gfc.PSY.mask_adjust = this.gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = this.gfp.maskingadjust_short;
                gfc.sfb21_extra = this.gfp.experimentalY ? false : this.gfp.getOutSampleRate() > 44000;
                gfc.iteration_loop = new VBRNewIterationLoop(this.qu);
                break;
            }
            case vbr_rh: {
                this.p.apply_preset(this.gfp, 500 - this.gfp.getVBRQuality() * 10, 0);
                gfc.PSY.mask_adjust = this.gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = this.gfp.maskingadjust_short;
                if (this.gfp.experimentalY) {
                    gfc.sfb21_extra = false;
                } else {
                    boolean bl = gfc.sfb21_extra = this.gfp.getOutSampleRate() > 44000;
                }
                if (this.gfp.getQuality() > 6) {
                    this.gfp.setQuality(6);
                }
                if (this.gfp.getQuality() < 0) {
                    this.gfp.setQuality(3);
                }
                gfc.iteration_loop = new VBROldIterationLoop(this.qu);
                break;
            }
            default: {
                VbrMode vbrmode;
                gfc.sfb21_extra = false;
                if (this.gfp.getQuality() < 0) {
                    this.gfp.setQuality(3);
                }
                if ((vbrmode = this.gfp.getVBR()) == VbrMode.vbr_off) {
                    this.gfp.VBR_mean_bitrate_kbps = this.gfp.getBitRate();
                }
                this.p.apply_preset(this.gfp, this.gfp.VBR_mean_bitrate_kbps, 0);
                this.gfp.setVBR(vbrmode);
                gfc.PSY.mask_adjust = this.gfp.maskingadjust;
                gfc.PSY.mask_adjust_short = this.gfp.maskingadjust_short;
                if (vbrmode == VbrMode.vbr_off) {
                    gfc.iteration_loop = new CBRNewIterationLoop(this.qu);
                    break;
                }
                gfc.iteration_loop = new ABRIterationLoop(this.qu);
                break;
            }
        }
        if (this.gfp.getVBR() != VbrMode.vbr_off) {
            gfc.VBR_min_bitrate = 1;
            gfc.VBR_max_bitrate = 14;
            if (this.gfp.getOutSampleRate() < 16000) {
                gfc.VBR_max_bitrate = 8;
            }
            if (this.gfp.VBR_min_bitrate_kbps != 0) {
                this.gfp.VBR_min_bitrate_kbps = this.FindNearestBitrate(this.gfp.VBR_min_bitrate_kbps, this.gfp.getMpegVersion(), this.gfp.getOutSampleRate());
                gfc.VBR_min_bitrate = this.BitrateIndex(this.gfp.VBR_min_bitrate_kbps, this.gfp.getMpegVersion(), this.gfp.getOutSampleRate());
                if (gfc.VBR_min_bitrate < 0) {
                    return -1;
                }
            }
            if (this.gfp.VBR_max_bitrate_kbps != 0) {
                this.gfp.VBR_max_bitrate_kbps = this.FindNearestBitrate(this.gfp.VBR_max_bitrate_kbps, this.gfp.getMpegVersion(), this.gfp.getOutSampleRate());
                gfc.VBR_max_bitrate = this.BitrateIndex(this.gfp.VBR_max_bitrate_kbps, this.gfp.getMpegVersion(), this.gfp.getOutSampleRate());
                if (gfc.VBR_max_bitrate < 0) {
                    return -1;
                }
            }
            this.gfp.VBR_min_bitrate_kbps = Tables.bitrate_table[this.gfp.getMpegVersion()][gfc.VBR_min_bitrate];
            this.gfp.VBR_max_bitrate_kbps = Tables.bitrate_table[this.gfp.getMpegVersion()][gfc.VBR_max_bitrate];
            this.gfp.VBR_mean_bitrate_kbps = Math.min(Tables.bitrate_table[this.gfp.getMpegVersion()][gfc.VBR_max_bitrate], this.gfp.VBR_mean_bitrate_kbps);
            this.gfp.VBR_mean_bitrate_kbps = Math.max(Tables.bitrate_table[this.gfp.getMpegVersion()][gfc.VBR_min_bitrate], this.gfp.VBR_mean_bitrate_kbps);
        }
        if (this.gfp.tune) {
            gfc.PSY.mask_adjust += this.gfp.tune_value_a;
            gfc.PSY.mask_adjust_short += this.gfp.tune_value_a;
        }
        this.lame_init_qval();
        gfc.ATH.useAdjust = this.gfp.athaa_type < 0 ? 3 : this.gfp.athaa_type;
        gfc.ATH.aaSensitivityP = (float)Math.pow(10.0, (double)this.gfp.athaa_sensitivity / -10.0);
        if (this.gfp.short_blocks == null) {
            this.gfp.short_blocks = ShortBlock.short_block_allowed;
        }
        if (this.gfp.short_blocks == ShortBlock.short_block_allowed && (this.gfp.getMode() == MPEGMode.JOINT_STEREO || this.gfp.getMode() == MPEGMode.STEREO)) {
            this.gfp.short_blocks = ShortBlock.short_block_coupled;
        }
        if (this.gfp.quant_comp < 0) {
            this.gfp.quant_comp = 1;
        }
        if (this.gfp.quant_comp_short < 0) {
            this.gfp.quant_comp_short = 0;
        }
        if (this.gfp.msfix < 0.0f) {
            this.gfp.msfix = 0.0f;
        }
        this.gfp.exp_nspsytune |= 1;
        if (this.gfp.internal_flags.nsPsy.attackthre < 0.0f) {
            this.gfp.internal_flags.nsPsy.attackthre = 4.4f;
        }
        if (this.gfp.internal_flags.nsPsy.attackthre_s < 0.0f) {
            this.gfp.internal_flags.nsPsy.attackthre_s = 25.0f;
        }
        if (this.gfp.scale < 0.0f) {
            this.gfp.scale = 1.0f;
        }
        if (this.gfp.ATHtype < 0) {
            this.gfp.ATHtype = 4;
        }
        if (this.gfp.ATHcurve < 0.0f) {
            this.gfp.ATHcurve = 4.0f;
        }
        if (this.gfp.athaa_loudapprox < 0) {
            this.gfp.athaa_loudapprox = 2;
        }
        if (this.gfp.interChRatio < 0.0f) {
            this.gfp.interChRatio = 0.0f;
        }
        if (this.gfp.useTemporal == null) {
            this.gfp.useTemporal = true;
        }
        gfc.frac_SpF = 0;
        gfc.slot_lag = 0;
        if (this.gfp.getVBR() == VbrMode.vbr_off) {
            gfc.slot_lag = gfc.frac_SpF = (int)((long)(this.gfp.getMpegVersion() + 1) * 72000L * (long)this.gfp.getBitRate() % (long)this.gfp.getOutSampleRate());
        }
        this.qupvt.iteration_init(this.gfp);
        this.psy.psymodel_init(this.gfp);
        return 0;
    }

    public final void lame_print_config() {
        LameInternalFlags gfc = this.gfp.internal_flags;
        double out_samplerate = this.gfp.getOutSampleRate();
        double in_samplerate = (double)this.gfp.getOutSampleRate() * gfc.resample_ratio;
        System.out.println(this.version.getVersion());
        if (this.gfp.getInNumChannels() == 2 && gfc.channels_out == 1) {
            System.out.printf("Autoconverting from stereo to mono. Setting encoding to mono mode.\n", new Object[0]);
        }
        if (BitStream.NEQ((float)gfc.resample_ratio, 1.0f)) {
            System.out.printf("Resampling:  input %g kHz  output %g kHz\n", 0.001 * in_samplerate, 0.001 * out_samplerate);
        }
        if ((double)gfc.highpass2 > 0.0) {
            System.out.printf("Using polyphase highpass filter, transition band: %5.0f Hz - %5.0f Hz\n", 0.5 * (double)gfc.highpass1 * out_samplerate, 0.5 * (double)gfc.highpass2 * out_samplerate);
        }
        if (0.0 < (double)gfc.lowpass1 || 0.0 < (double)gfc.lowpass2) {
            System.out.printf("Using polyphase lowpass filter, transition band: %5.0f Hz - %5.0f Hz\n", 0.5 * (double)gfc.lowpass1 * out_samplerate, 0.5 * (double)gfc.lowpass2 * out_samplerate);
        } else {
            System.out.printf("polyphase lowpass filter disabled\n", new Object[0]);
        }
        if (this.gfp.free_format) {
            System.err.printf("Warning: many decoders cannot handle free format bitstreams\n", new Object[0]);
            if (this.gfp.getBitRate() > 320) {
                System.err.printf("Warning: many decoders cannot handle free format bitrates >320 kbps (see documentation)\n", new Object[0]);
            }
        }
    }

    public final void lame_print_internals() {
        String pc;
        LameInternalFlags gfc = this.gfp.internal_flags;
        System.err.printf("\nmisc:\n\n", new Object[0]);
        System.err.printf("\tscaling: %g\n", Float.valueOf(this.gfp.scale));
        System.err.printf("\tch0 (left) scaling: %g\n", Float.valueOf(this.gfp.scale_left));
        System.err.printf("\tch1 (right) scaling: %g\n", Float.valueOf(this.gfp.scale_right));
        switch (gfc.use_best_huffman) {
            default: {
                pc = "normal";
                break;
            }
            case 1: {
                pc = "best (outside loop)";
                break;
            }
            case 2: {
                pc = "best (inside loop, slow)";
            }
        }
        System.err.printf("\thuffman search: %s\n", pc);
        System.err.printf("\texperimental Y=%d\n", this.gfp.experimentalY);
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\nstream format:\n\n", new Object[0]);
        switch (this.gfp.getMpegVersion()) {
            case 0: {
                pc = "2.5";
                break;
            }
            case 1: {
                pc = "1";
                break;
            }
            case 2: {
                pc = "2";
                break;
            }
            default: {
                pc = "?";
            }
        }
        System.err.printf("\tMPEG-%s Layer 3\n", pc);
        switch (this.gfp.getMode()) {
            case JOINT_STEREO: {
                pc = "joint stereo";
                break;
            }
            case STEREO: {
                pc = "stereo";
                break;
            }
            case DUAL_CHANNEL: {
                pc = "dual channel";
                break;
            }
            case MONO: {
                pc = "mono";
                break;
            }
            case NOT_SET: {
                pc = "not set (error)";
                break;
            }
            default: {
                pc = "unknown (error)";
            }
        }
        System.err.printf("\t%d channel - %s\n", gfc.channels_out, pc);
        switch (this.gfp.getVBR()) {
            case vbr_off: {
                pc = "off";
                break;
            }
            default: {
                pc = "all";
            }
        }
        System.err.printf("\tpadding: %s\n", pc);
        pc = VbrMode.vbr_default == this.gfp.getVBR() ? "(default)" : (this.gfp.free_format ? "(free format)" : "");
        switch (this.gfp.getVBR()) {
            case vbr_off: {
                System.err.printf("\tconstant bitrate - CBR %s\n", pc);
                break;
            }
            case vbr_abr: {
                System.err.printf("\tvariable bitrate - ABR %s\n", pc);
                break;
            }
            case vbr_rh: {
                System.err.printf("\tvariable bitrate - VBR rh %s\n", pc);
                break;
            }
            case vbr_mt: {
                System.err.printf("\tvariable bitrate - VBR mt %s\n", pc);
                break;
            }
            case vbr_mtrh: {
                System.err.printf("\tvariable bitrate - VBR mtrh %s\n", pc);
                break;
            }
            default: {
                System.err.printf("\t ?? oops, some new one ?? \n", new Object[0]);
            }
        }
        if (this.gfp.bWriteVbrTag) {
            System.err.printf("\tusing LAME Tag\n", new Object[0]);
        }
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\npsychoacoustic:\n\n", new Object[0]);
        switch (this.gfp.short_blocks) {
            default: {
                pc = "?";
                break;
            }
            case short_block_allowed: {
                pc = "allowed";
                break;
            }
            case short_block_coupled: {
                pc = "channel coupled";
                break;
            }
            case short_block_dispensed: {
                pc = "dispensed";
                break;
            }
            case short_block_forced: {
                pc = "forced";
            }
        }
        System.err.printf("\tusing short blocks: %s\n", pc);
        System.err.printf("\tsubblock gain: %d\n", gfc.subblock_gain);
        System.err.printf("\tadjust masking: %g dB\n", Float.valueOf(gfc.PSY.mask_adjust));
        System.err.printf("\tadjust masking short: %g dB\n", Float.valueOf(gfc.PSY.mask_adjust_short));
        System.err.printf("\tquantization comparison: %d\n", this.gfp.quant_comp);
        System.err.printf("\t ^ comparison short blocks: %d\n", this.gfp.quant_comp_short);
        System.err.printf("\tnoise shaping: %d\n", gfc.noise_shaping);
        System.err.printf("\t ^ amplification: %d\n", gfc.noise_shaping_amp);
        System.err.printf("\t ^ stopping: %d\n", gfc.noise_shaping_stop);
        pc = "using";
        if (this.gfp.ATHshort) {
            pc = "the only masking for short blocks";
        }
        if (this.gfp.ATHonly) {
            pc = "the only masking";
        }
        if (this.gfp.noATH) {
            pc = "not used";
        }
        System.err.printf("\tATH: %s\n", pc);
        System.err.printf("\t ^ type: %d\n", this.gfp.ATHtype);
        System.err.printf("\t ^ shape: %g%s\n", Float.valueOf(this.gfp.ATHcurve), " (only for type 4)");
        System.err.printf("\t ^ level adjustement: %g\n", Float.valueOf(this.gfp.ATHlower));
        System.err.printf("\t ^ adjust type: %d\n", gfc.ATH.useAdjust);
        System.err.printf("\t ^ adjust sensitivity power: %f\n", Float.valueOf(gfc.ATH.aaSensitivityP));
        System.err.printf("\t ^ adapt threshold type: %d\n", this.gfp.athaa_loudapprox);
        System.err.printf("\texperimental psy tunings by Naoki Shibata\n", new Object[0]);
        System.err.printf("\t   adjust masking bass=%g dB, alto=%g dB, treble=%g dB, sfb21=%g dB\n", 10.0 * Math.log10(gfc.nsPsy.longfact[0]), 10.0 * Math.log10(gfc.nsPsy.longfact[7]), 10.0 * Math.log10(gfc.nsPsy.longfact[14]), 10.0 * Math.log10(gfc.nsPsy.longfact[21]));
        pc = this.gfp.useTemporal != false ? "yes" : "no";
        System.err.printf("\tusing temporal masking effect: %s\n", pc);
        System.err.printf("\tinterchannel masking ratio: %g\n", Float.valueOf(this.gfp.interChRatio));
        System.err.printf("\t...\n", new Object[0]);
        System.err.printf("\n", new Object[0]);
    }

    private int lame_encode_frame(float[] inbuf_l, float[] inbuf_r, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        int ret = this.enc.lame_encode_mp3_frame(this.gfp, inbuf_l, inbuf_r, mp3buf, mp3bufPos, mp3buf_size);
        ++this.gfp.frameNum;
        return ret;
    }

    private void update_inbuffer_size(LameInternalFlags gfc, int nsamples) {
        if (gfc.in_buffer_0 == null || gfc.in_buffer_nsamples < nsamples) {
            gfc.in_buffer_0 = new float[nsamples];
            gfc.in_buffer_1 = new float[nsamples];
            gfc.in_buffer_nsamples = nsamples;
        }
    }

    private int calcNeeded() {
        int mf_needed = 1024 + this.gfp.getFrameSize() - 272;
        mf_needed = Math.max(mf_needed, 512 + this.gfp.getFrameSize() - 32);
        assert (3984 >= mf_needed);
        return mf_needed;
    }

    private int lame_encode_buffer_sample(float[] buffer_l, float[] buffer_r, int nsamples, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        int i;
        LameInternalFlags gfc = this.gfp.internal_flags;
        int mp3size = 0;
        float[][] mfbuf = new float[2][];
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        int mp3out = this.bs.copy_buffer(gfc, mp3buf, mp3bufPos, mp3buf_size, 0);
        if (mp3out < 0) {
            return mp3out;
        }
        mp3bufPos += mp3out;
        mp3size += mp3out;
        in_buffer[0] = buffer_l;
        in_buffer[1] = buffer_r;
        if (BitStream.NEQ(this.gfp.scale, 0.0f) && BitStream.NEQ(this.gfp.scale, 1.0f)) {
            for (i = 0; i < nsamples; ++i) {
                float[] fArray = in_buffer[0];
                int n = i;
                fArray[n] = fArray[n] * this.gfp.scale;
                if (gfc.channels_out != 2) continue;
                float[] fArray2 = in_buffer[1];
                int n2 = i;
                fArray2[n2] = fArray2[n2] * this.gfp.scale;
            }
        }
        if (BitStream.NEQ(this.gfp.scale_left, 0.0f) && BitStream.NEQ(this.gfp.scale_left, 1.0f)) {
            i = 0;
            while (i < nsamples) {
                float[] fArray = in_buffer[0];
                int n = i++;
                fArray[n] = fArray[n] * this.gfp.scale_left;
            }
        }
        if (BitStream.NEQ(this.gfp.scale_right, 0.0f) && BitStream.NEQ(this.gfp.scale_right, 1.0f)) {
            i = 0;
            while (i < nsamples) {
                float[] fArray = in_buffer[1];
                int n = i++;
                fArray[n] = fArray[n] * this.gfp.scale_right;
            }
        }
        if (this.gfp.getInNumChannels() == 2 && gfc.channels_out == 1) {
            for (i = 0; i < nsamples; ++i) {
                in_buffer[0][i] = 0.5f * (in_buffer[0][i] + in_buffer[1][i]);
                in_buffer[1][i] = 0.0f;
            }
        }
        int mf_needed = this.calcNeeded();
        mfbuf[0] = gfc.mfbuf[0];
        mfbuf[1] = gfc.mfbuf[1];
        int in_bufferPos = 0;
        while (nsamples > 0) {
            int ret;
            float[][] in_buffer_ptr = new float[2][];
            int n_in = 0;
            int n_out = 0;
            in_buffer_ptr[0] = in_buffer[0];
            in_buffer_ptr[1] = in_buffer[1];
            InOut inOut = new InOut();
            this.fill_buffer(mfbuf, in_buffer_ptr, in_bufferPos, nsamples, inOut);
            n_in = inOut.n_in;
            n_out = inOut.n_out;
            if (gfc.findReplayGain && !gfc.decode_on_the_fly && this.ga.AnalyzeSamples(gfc.rgdata, mfbuf[0], gfc.mf_size, mfbuf[1], gfc.mf_size, n_out, gfc.channels_out) == 0) {
                return -6;
            }
            nsamples -= n_in;
            in_bufferPos += n_in;
            if (gfc.channels_out == 2) {
                // empty if block
            }
            gfc.mf_size += n_out;
            assert (gfc.mf_size <= 3984);
            if (gfc.mf_samples_to_encode < 1) {
                gfc.mf_samples_to_encode = 1728;
            }
            gfc.mf_samples_to_encode += n_out;
            if (gfc.mf_size < mf_needed) continue;
            int buf_size = mp3buf_size - mp3size;
            if (mp3buf_size == 0) {
                buf_size = 0;
            }
            if ((ret = this.lame_encode_frame(mfbuf[0], mfbuf[1], mp3buf, mp3bufPos, buf_size)) < 0) {
                return ret;
            }
            mp3bufPos += ret;
            mp3size += ret;
            gfc.mf_size -= this.gfp.getFrameSize();
            gfc.mf_samples_to_encode -= this.gfp.getFrameSize();
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                for (i = 0; i < gfc.mf_size; ++i) {
                    mfbuf[ch][i] = mfbuf[ch][i + this.gfp.getFrameSize()];
                }
            }
        }
        assert (nsamples == 0);
        return mp3size;
    }

    private int lame_encode_buffer(short[] buffer_l, short[] buffer_r, int nsamples, byte[] mp3buf, int mp3bufPos, int mp3buf_size) {
        LameInternalFlags gfc = this.gfp.internal_flags;
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        this.update_inbuffer_size(gfc, nsamples);
        in_buffer[0] = gfc.in_buffer_0;
        in_buffer[1] = gfc.in_buffer_1;
        for (int i = 0; i < nsamples; ++i) {
            in_buffer[0][i] = buffer_l[i];
            if (gfc.channels_in <= 1) continue;
            in_buffer[1][i] = buffer_r[i];
        }
        return this.lame_encode_buffer_sample(in_buffer[0], in_buffer[1], nsamples, mp3buf, mp3bufPos, mp3buf_size);
    }

    public int encodeBuffer(float[] buffer_l, float[] buffer_r, int nsamples, byte[] mp3buf) {
        LameInternalFlags gfc = this.gfp.internal_flags;
        float[][] in_buffer = new float[2][];
        if (gfc.Class_ID != -487877L) {
            return -3;
        }
        if (nsamples == 0) {
            return 0;
        }
        this.update_inbuffer_size(gfc, nsamples);
        in_buffer[0] = gfc.in_buffer_0;
        in_buffer[1] = gfc.in_buffer_1;
        for (int i = 0; i < nsamples; ++i) {
            in_buffer[0][i] = buffer_l[i] * 1.5258789E-5f;
            if (gfc.channels_in <= 1) continue;
            in_buffer[1][i] = buffer_r[i] * 1.5258789E-5f;
        }
        return this.lame_encode_buffer_sample(in_buffer[0], in_buffer[1], nsamples, mp3buf, 0, mp3buf.length);
    }

    public final int lame_encode_flush_nogap(byte[] mp3buffer, int mp3buffer_size) {
        LameInternalFlags gfc = this.gfp.internal_flags;
        this.bs.flush_bitstream(this.gfp);
        return this.bs.copy_buffer(gfc, mp3buffer, 0, mp3buffer_size, 1);
    }

    public final void lame_init_bitstream() {
        LameInternalFlags gfc = this.gfp.internal_flags;
        this.gfp.frameNum = 0;
        if (this.gfp.isWriteId3tagAutomatic()) {
            this.id3.id3tag_write_v2(this.gfp);
        }
        gfc.bitrate_stereoMode_Hist = new int[16][5];
        gfc.bitrate_blockType_Hist = new int[16][6];
        gfc.PeakSample = 0.0f;
        if (this.gfp.bWriteVbrTag) {
            this.vbr.InitVbrTag(this.gfp);
        }
    }

    public final int encodeFlush(byte[] mp3buffer) {
        int mp3buffer_size_remaining;
        int frame_num;
        int end_padding;
        LameInternalFlags gfc = this.gfp.internal_flags;
        short[][] buffer = new short[2][1152];
        int imp3 = 0;
        int samples_to_encode = gfc.mf_samples_to_encode - 1152;
        int mf_needed = this.calcNeeded();
        if (gfc.mf_samples_to_encode < 1) {
            return 0;
        }
        int mp3count = 0;
        if (this.gfp.getInSampleRate() != this.gfp.getOutSampleRate()) {
            samples_to_encode = (int)((double)samples_to_encode + 16.0 * (double)this.gfp.getOutSampleRate() / (double)this.gfp.getInSampleRate());
        }
        if ((end_padding = this.gfp.getFrameSize() - samples_to_encode % this.gfp.getFrameSize()) < 576) {
            end_padding += this.gfp.getFrameSize();
        }
        this.gfp.encoder_padding = end_padding;
        int mp3bufferPos = 0;
        for (int frames_left = (samples_to_encode + end_padding) / this.gfp.getFrameSize(); frames_left > 0 && imp3 >= 0; frames_left -= frame_num != this.gfp.frameNum ? 1 : 0) {
            int bunch = mf_needed - gfc.mf_size;
            frame_num = this.gfp.frameNum;
            bunch *= this.gfp.getInSampleRate();
            if ((bunch /= this.gfp.getOutSampleRate()) > 1152) {
                bunch = 1152;
            }
            if (bunch < 1) {
                bunch = 1;
            }
            mp3buffer_size_remaining = mp3buffer.length - mp3count;
            if (mp3buffer.length == 0) {
                mp3buffer_size_remaining = 0;
            }
            imp3 = this.lame_encode_buffer(buffer[0], buffer[1], bunch, mp3buffer, mp3bufferPos, mp3buffer_size_remaining);
            mp3bufferPos += imp3;
            mp3count += imp3;
        }
        gfc.mf_samples_to_encode = 0;
        if (imp3 < 0) {
            return imp3;
        }
        mp3buffer_size_remaining = mp3buffer.length - mp3count;
        if (mp3buffer.length == 0) {
            mp3buffer_size_remaining = 0;
        }
        this.bs.flush_bitstream(this.gfp);
        imp3 = this.bs.copy_buffer(gfc, mp3buffer, mp3bufferPos, mp3buffer_size_remaining, 1);
        if (imp3 < 0) {
            return imp3;
        }
        mp3bufferPos += imp3;
        mp3buffer_size_remaining = mp3buffer.length - (mp3count += imp3);
        if (mp3buffer.length == 0) {
            mp3buffer_size_remaining = 0;
        }
        if (this.gfp.isWriteId3tagAutomatic()) {
            this.id3.id3tag_write_v1(this.gfp);
            imp3 = this.bs.copy_buffer(gfc, mp3buffer, mp3bufferPos, mp3buffer_size_remaining, 0);
            if (imp3 < 0) {
                return imp3;
            }
            mp3count += imp3;
        }
        return mp3count;
    }

    public final int close() {
        int ret = 0;
        if (this.gfp != null && this.gfp.class_id == -487877L) {
            LameInternalFlags gfc = this.gfp.internal_flags;
            this.gfp.class_id = 0L;
            if (null == gfc || gfc.Class_ID != -487877L) {
                ret = -3;
            }
            gfc.Class_ID = 0L;
            this.gfp.internal_flags = null;
            this.gfp.lame_allocated_gfp = 0;
        }
        return ret;
    }

    private void lame_init_old() {
        this.gfp.class_id = -487877L;
        LameInternalFlags gfc = this.gfp.internal_flags = new LameInternalFlags();
        this.gfp.setMode(MPEGMode.NOT_SET);
        this.gfp.original = 1;
        this.gfp.setInSampleRate(44100);
        this.gfp.setInNumChannels(2);
        this.gfp.num_samples = -1;
        this.gfp.bWriteVbrTag = true;
        this.gfp.setQuality(-1);
        this.gfp.short_blocks = null;
        gfc.subblock_gain = -1;
        this.gfp.lowpassfreq = 0;
        this.gfp.highpassfreq = 0;
        this.gfp.lowpasswidth = -1;
        this.gfp.highpasswidth = -1;
        this.gfp.setVBR(VbrMode.vbr_off);
        this.gfp.setVBRQuality(4);
        this.gfp.ATHcurve = -1.0f;
        this.gfp.VBR_mean_bitrate_kbps = 128;
        this.gfp.VBR_min_bitrate_kbps = 0;
        this.gfp.VBR_max_bitrate_kbps = 0;
        this.gfp.VBR_hard_min = 0;
        gfc.VBR_min_bitrate = 1;
        gfc.VBR_max_bitrate = 13;
        this.gfp.quant_comp = -1;
        this.gfp.quant_comp_short = -1;
        this.gfp.msfix = -1.0f;
        gfc.resample_ratio = 1.0;
        gfc.OldValue[0] = 180;
        gfc.OldValue[1] = 180;
        gfc.CurrentStep[0] = 4;
        gfc.CurrentStep[1] = 4;
        gfc.masking_lower = 1.0f;
        gfc.nsPsy.attackthre = -1.0f;
        gfc.nsPsy.attackthre_s = -1.0f;
        this.gfp.scale = -1.0f;
        this.gfp.athaa_type = -1;
        this.gfp.ATHtype = -1;
        this.gfp.athaa_loudapprox = -1;
        this.gfp.athaa_sensitivity = 0.0f;
        this.gfp.useTemporal = null;
        this.gfp.interChRatio = -1.0f;
        gfc.mf_samples_to_encode = 1728;
        this.gfp.encoder_padding = 0;
        gfc.mf_size = 528;
        this.gfp.setFindReplayGain(false);
        this.gfp.decode_on_the_fly = false;
        gfc.decode_on_the_fly = false;
        gfc.findReplayGain = false;
        gfc.findPeakSample = false;
        gfc.RadioGain = 0;
        gfc.AudiophileGain = 0;
        gfc.noclipGainChange = 0;
        gfc.noclipScale = -1.0f;
        this.gfp.preset = 0;
        this.gfp.setWriteId3tagAutomatic(true);
    }

    private final void lame_init() {
        this.lame_init_old();
        this.gfp.lame_allocated_gfp = 1;
    }

    public final void lame_bitrate_kbps(int[] bitrate_kbps) {
        if (null == bitrate_kbps) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (this.gfp.free_format) {
            for (int i = 0; i < 14; ++i) {
                bitrate_kbps[i] = -1;
            }
            bitrate_kbps[0] = this.gfp.getBitRate();
        } else {
            for (int i = 0; i < 14; ++i) {
                bitrate_kbps[i] = Tables.bitrate_table[this.gfp.getMpegVersion()][i + 1];
            }
        }
    }

    public final void lame_bitrate_hist(int[] bitrate_count) {
        if (null == bitrate_count) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (this.gfp.free_format) {
            for (int i = 0; i < 14; ++i) {
                bitrate_count[i] = 0;
            }
            bitrate_count[0] = gfc.bitrate_stereoMode_Hist[0][4];
        } else {
            for (int i = 0; i < 14; ++i) {
                bitrate_count[i] = gfc.bitrate_stereoMode_Hist[i + 1][4];
            }
        }
    }

    public final void lame_stereo_mode_hist(int[] stmode_count) {
        if (null == stmode_count) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            stmode_count[i] = gfc.bitrate_stereoMode_Hist[15][i];
        }
    }

    public final void lame_bitrate_stereo_mode_hist(int[][] bitrate_stmode_count) {
        if (null == bitrate_stmode_count) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (this.gfp.free_format) {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 4; ++i) {
                    bitrate_stmode_count[j][i] = 0;
                }
            }
            for (int i = 0; i < 4; ++i) {
                bitrate_stmode_count[0][i] = gfc.bitrate_stereoMode_Hist[0][i];
            }
        } else {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 4; ++i) {
                    bitrate_stmode_count[j][i] = gfc.bitrate_stereoMode_Hist[j + 1][i];
                }
            }
        }
    }

    public final void lame_block_type_hist(int[] btype_count) {
        if (null == btype_count) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            btype_count[i] = gfc.bitrate_blockType_Hist[15][i];
        }
    }

    public final void lame_bitrate_block_type_hist(int[][] bitrate_btype_count) {
        if (null == bitrate_btype_count) {
            return;
        }
        if (null == this.gfp) {
            return;
        }
        LameInternalFlags gfc = this.gfp.internal_flags;
        if (null == gfc) {
            return;
        }
        if (this.gfp.free_format) {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 6; ++i) {
                    bitrate_btype_count[j][i] = 0;
                }
            }
            for (int i = 0; i < 6; ++i) {
                bitrate_btype_count[0][i] = gfc.bitrate_blockType_Hist[0][i];
            }
        } else {
            for (int j = 0; j < 14; ++j) {
                for (int i = 0; i < 6; ++i) {
                    bitrate_btype_count[j][i] = gfc.bitrate_blockType_Hist[j + 1][i];
                }
            }
        }
    }

    protected static class InOut {
        int n_in;
        int n_out;

        protected InOut() {
        }
    }

    protected static class NumUsed {
        int num_used;

        protected NumUsed() {
        }
    }

    private static class BandPass {
        public int lowpass;

        public BandPass(int bitrate, int lPass) {
            this.lowpass = lPass;
        }
    }

    protected static class LowPassHighPass {
        double lowerlimit;

        protected LowPassHighPass() {
        }
    }
}

