/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import java.nio.charset.Charset;
import java.util.Arrays;
import mp3.BitStream;
import mp3.FrameDataNode;
import mp3.GenreListHandler;
import mp3.ID3TagSpec;
import mp3.LameGlobalFlags;
import mp3.LameInternalFlags;
import mp3.Version;

public class ID3Tag {
    BitStream bits;
    private Version version = new Version();
    private static final int CHANGED_FLAG = 1;
    private static final int ADD_V2_FLAG = 2;
    private static final int V1_ONLY_FLAG = 4;
    private static final int V2_ONLY_FLAG = 8;
    private static final int SPACE_V1_FLAG = 16;
    private static final int PAD_V2_FLAG = 32;
    private static final String[] genre_names = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "Alternative Rock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native US", "Cabaret", "New Wave", "Psychedelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Cappella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};
    private static final int[] genre_alpha_map = new int[]{123, 34, 74, 73, 99, 20, 40, 26, 145, 90, 116, 41, 135, 85, 96, 138, 89, 0, 107, 132, 65, 88, 104, 102, 97, 136, 61, 141, 32, 1, 112, 128, 57, 140, 2, 139, 58, 3, 125, 50, 22, 4, 55, 127, 122, 120, 98, 52, 48, 54, 124, 25, 84, 80, 115, 81, 119, 5, 30, 36, 59, 126, 38, 49, 91, 6, 129, 79, 137, 7, 35, 100, 131, 19, 33, 46, 47, 8, 29, 146, 63, 86, 71, 45, 142, 9, 77, 82, 64, 133, 10, 66, 39, 11, 103, 12, 75, 134, 13, 53, 62, 109, 117, 23, 108, 92, 67, 93, 43, 121, 15, 68, 14, 16, 76, 87, 118, 17, 78, 143, 114, 110, 69, 21, 111, 95, 105, 42, 37, 24, 56, 44, 101, 83, 94, 106, 147, 113, 18, 51, 130, 144, 60, 70, 31, 72, 27, 28};
    private static final int GENRE_INDEX_OTHER = 12;
    private static final int ID_TITLE = ID3Tag.FRAME_ID('T', 'I', 'T', '2');
    private static final int ID_ARTIST = ID3Tag.FRAME_ID('T', 'P', 'E', '1');
    private static final int ID_ALBUM = ID3Tag.FRAME_ID('T', 'A', 'L', 'B');
    private static final int ID_GENRE = ID3Tag.FRAME_ID('T', 'C', 'O', 'N');
    private static final int ID_ENCODER = ID3Tag.FRAME_ID('T', 'S', 'S', 'E');
    private static final int ID_PLAYLENGTH = ID3Tag.FRAME_ID('T', 'L', 'E', 'N');
    private static final int ID_COMMENT = ID3Tag.FRAME_ID('C', 'O', 'M', 'M');
    private static final int ID_DATE = ID3Tag.FRAME_ID('T', 'D', 'A', 'T');
    private static final int ID_TIME = ID3Tag.FRAME_ID('T', 'I', 'M', 'E');
    private static final int ID_TPOS = ID3Tag.FRAME_ID('T', 'P', 'O', 'S');
    private static final int ID_TRACK = ID3Tag.FRAME_ID('T', 'R', 'C', 'K');
    private static final int ID_YEAR = ID3Tag.FRAME_ID('T', 'Y', 'E', 'R');
    private static final int ID_TXXX = ID3Tag.FRAME_ID('T', 'X', 'X', 'X');
    private static final int ID_WXXX = ID3Tag.FRAME_ID('W', 'X', 'X', 'X');
    private static final int ID_SYLT = ID3Tag.FRAME_ID('S', 'Y', 'L', 'T');
    private static final int ID_APIC = ID3Tag.FRAME_ID('A', 'P', 'I', 'C');
    private static final int ID_GEOB = ID3Tag.FRAME_ID('G', 'E', 'O', 'B');
    private static final int ID_PCNT = ID3Tag.FRAME_ID('P', 'C', 'N', 'T');
    private static final int ID_AENC = ID3Tag.FRAME_ID('A', 'E', 'N', 'C');
    private static final int ID_LINK = ID3Tag.FRAME_ID('L', 'I', 'N', 'K');
    private static final int ID_ENCR = ID3Tag.FRAME_ID('E', 'N', 'C', 'R');
    private static final int ID_GRID = ID3Tag.FRAME_ID('G', 'R', 'I', 'D');
    private static final int ID_PRIV = ID3Tag.FRAME_ID('P', 'R', 'I', 'V');
    private static final int GENRE_NUM_UNKNOWN = 255;
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final String mime_jpeg = "image/jpeg";
    private static final String mime_png = "image/png";
    private static final String mime_gif = "image/gif";

    public final void setModules(BitStream bits) {
        this.bits = bits;
    }

    private static int FRAME_ID(char a, char b, char c, char d) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | (d & 0xFF) << 0;
    }

    private void copyV1ToV2(LameGlobalFlags gfp, int frame_id, String s) {
        LameInternalFlags gfc = gfp.internal_flags;
        int flags = gfc.tag_spec.flags;
        this.id3v2_add_latin1(gfp, frame_id, null, null, s);
        gfc.tag_spec.flags = flags;
    }

    private void id3v2AddLameVersion(LameGlobalFlags gfp) {
        this.copyV1ToV2(gfp, ID_ENCODER, this.version.getVersion());
    }

    private void id3v2AddAudioDuration(LameGlobalFlags gfp) {
        if (gfp.num_samples != -1) {
            double max_ulong = 2.147483647E9;
            double ms = gfp.num_samples;
            ms *= 1000.0;
            long playlength_ms = (ms /= (double)gfp.getInSampleRate()) > 2.147483647E9 ? (long)max_ulong : (ms < 0.0 ? 0L : (long)ms);
            String buffer = String.format("%d", playlength_ms);
            this.copyV1ToV2(gfp, ID_PLAYLENGTH, buffer);
        }
    }

    public final void id3tag_genre_list(GenreListHandler handler) {
        if (handler != null) {
            for (int i = 0; i < genre_names.length; ++i) {
                if (i >= genre_alpha_map.length) continue;
                int j = genre_alpha_map[i];
                handler.genre_list_handler(j, genre_names[j]);
            }
        }
    }

    public final void init(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec = new ID3TagSpec();
        gfc.tag_spec.genre_id3v1 = 255;
        gfc.tag_spec.padding_size = 128;
        this.id3v2AddLameVersion(gfp);
    }

    public final void id3tag_add_v2(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec.flags &= 0xFFFFFFFB;
        gfc.tag_spec.flags |= 2;
    }

    public final void id3tag_v1_only(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec.flags &= 0xFFFFFFF5;
        gfc.tag_spec.flags |= 4;
    }

    public final void id3tag_v2_only(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec.flags &= 0xFFFFFFFB;
        gfc.tag_spec.flags |= 8;
    }

    public final void id3tag_space_v1(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec.flags &= 0xFFFFFFF7;
        gfc.tag_spec.flags |= 0x10;
    }

    public final void id3tag_pad_v2(LameGlobalFlags gfp) {
        this.id3tag_set_pad(gfp, 128);
    }

    public final void id3tag_set_pad(LameGlobalFlags gfp, int n) {
        LameInternalFlags gfc = gfp.internal_flags;
        gfc.tag_spec.flags &= 0xFFFFFFFB;
        gfc.tag_spec.flags |= 0x20;
        gfc.tag_spec.flags |= 2;
        gfc.tag_spec.padding_size = n;
    }

    public final boolean id3tag_set_albumart(LameGlobalFlags gfp, byte[] image, int size) {
        MimeType mimetype = MimeType.MIMETYPE_NONE;
        byte[] data = image;
        LameInternalFlags gfc = gfp.internal_flags;
        if (131072 < size) {
            return false;
        }
        if (2 < size && data[0] == -1 && data[1] == -40) {
            mimetype = MimeType.MIMETYPE_JPEG;
        } else if (4 < size && data[0] == 137 && new String(data, 1, 3, ASCII).startsWith("PNG")) {
            mimetype = MimeType.MIMETYPE_PNG;
        } else if (4 < size && new String(data, 1, 3, ASCII).startsWith("GIF8")) {
            mimetype = MimeType.MIMETYPE_GIF;
        } else {
            return false;
        }
        if (gfc.tag_spec.albumart != null) {
            gfc.tag_spec.albumart = null;
            gfc.tag_spec.albumart_size = 0;
            gfc.tag_spec.albumart_mimetype = MimeType.MIMETYPE_NONE;
        }
        if (size < 1) {
            return true;
        }
        gfc.tag_spec.albumart = new byte[size];
        if (gfc.tag_spec.albumart != null) {
            System.arraycopy(image, 0, gfc.tag_spec.albumart, 0, size);
            gfc.tag_spec.albumart_size = size;
            gfc.tag_spec.albumart_mimetype = mimetype;
            gfc.tag_spec.flags |= 1;
            this.id3tag_add_v2(gfp);
        }
        return true;
    }

    private int set_4_byte_value(byte[] bytes, int bytesPos, int value) {
        for (int i = 3; i >= 0; --i) {
            bytes[bytesPos + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return bytesPos + 4;
    }

    private int toID3v2TagId(String s) {
        int x = 0;
        if (s == null) {
            return 0;
        }
        for (int i = 0; i < 4 && i < s.length(); ++i) {
            char c = s.charAt(i);
            int u = 0xFF & c;
            x <<= 8;
            x |= u;
            if (c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c) continue;
            return 0;
        }
        return x;
    }

    private boolean isNumericString(int frame_id) {
        return frame_id == ID_DATE || frame_id == ID_TIME || frame_id == ID_TPOS || frame_id == ID_TRACK || frame_id == ID_YEAR;
    }

    private boolean isMultiFrame(int frame_id) {
        return frame_id == ID_TXXX || frame_id == ID_WXXX || frame_id == ID_COMMENT || frame_id == ID_SYLT || frame_id == ID_APIC || frame_id == ID_GEOB || frame_id == ID_PCNT || frame_id == ID_AENC || frame_id == ID_LINK || frame_id == ID_ENCR || frame_id == ID_GRID || frame_id == ID_PRIV;
    }

    private boolean hasUcs2ByteOrderMarker(char bom) {
        return bom == '\ufffe' || bom == '\ufeff';
    }

    private FrameDataNode findNode(ID3TagSpec tag, int frame_id, FrameDataNode last) {
        FrameDataNode node;
        FrameDataNode frameDataNode = node = last != null ? last.nxt : tag.v2_head;
        while (node != null) {
            if (node.fid == frame_id) {
                return node;
            }
            node = node.nxt;
        }
        return null;
    }

    private void appendNode(ID3TagSpec tag, FrameDataNode node) {
        if (tag.v2_tail == null || tag.v2_head == null) {
            tag.v2_head = node;
            tag.v2_tail = node;
        } else {
            tag.v2_tail.nxt = node;
            tag.v2_tail = node;
        }
    }

    private String setLang(String src) {
        if (src == null || src.length() == 0) {
            return "XXX";
        }
        StringBuilder dst = new StringBuilder();
        if (src != null) {
            dst.append(src.substring(0, 3));
        }
        for (int i = dst.length(); i < 3; ++i) {
            dst.append(' ');
        }
        return dst.toString();
    }

    private boolean isSameLang(String l1, String l2) {
        String d = this.setLang(l2);
        for (int i = 0; i < 3; ++i) {
            int a = Character.toLowerCase(l1.charAt(i));
            int b = Character.toLowerCase(d.charAt(i));
            if (a < 32) {
                a = 32;
            }
            if (b < 32) {
                b = 32;
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    private boolean isSameDescriptor(FrameDataNode node, String dsc) {
        if (node.dsc.enc == 1 && node.dsc.dim > 0) {
            return false;
        }
        for (int i = 0; i < node.dsc.dim; ++i) {
            if (null != dsc && node.dsc.l.charAt(i) == dsc.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameDescriptorUcs2(FrameDataNode node, String dsc) {
        if (node.dsc.enc != 1 && node.dsc.dim > 0) {
            return false;
        }
        for (int i = 0; i < node.dsc.dim; ++i) {
            if (null != dsc && node.dsc.l.charAt(i) == dsc.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void id3v2_add_ucs2(LameGlobalFlags gfp, int frame_id, String lang, String desc, String text) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc != null) {
            FrameDataNode node = this.findNode(gfc.tag_spec, frame_id, null);
            if (this.isMultiFrame(frame_id)) {
                while (!(node == null || this.isSameLang(node.lng, lang) && this.isSameDescriptorUcs2(node, desc))) {
                    node = this.findNode(gfc.tag_spec, frame_id, node);
                }
            }
            if (node == null) {
                node = new FrameDataNode();
                this.appendNode(gfc.tag_spec, node);
            }
            node.fid = frame_id;
            node.lng = this.setLang(lang);
            node.dsc.l = desc;
            node.dsc.dim = desc != null ? desc.length() : 0;
            node.dsc.enc = 1;
            node.txt.l = text;
            node.txt.dim = text != null ? text.length() : 0;
            node.txt.enc = 1;
            gfc.tag_spec.flags |= 3;
        }
    }

    private void id3v2_add_latin1(LameGlobalFlags gfp, int frame_id, String lang, String desc, String text) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc != null) {
            FrameDataNode node = this.findNode(gfc.tag_spec, frame_id, null);
            if (this.isMultiFrame(frame_id)) {
                while (!(node == null || this.isSameLang(node.lng, lang) && this.isSameDescriptor(node, desc))) {
                    node = this.findNode(gfc.tag_spec, frame_id, node);
                }
            }
            if (node == null) {
                node = new FrameDataNode();
                this.appendNode(gfc.tag_spec, node);
            }
            node.fid = frame_id;
            node.lng = this.setLang(lang);
            node.dsc.l = desc;
            node.dsc.dim = desc != null ? desc.length() : 0;
            node.dsc.enc = 0;
            node.txt.l = text;
            node.txt.dim = text != null ? text.length() : 0;
            node.txt.enc = 0;
            gfc.tag_spec.flags |= 3;
        }
    }

    public final int id3tag_set_textinfo_ucs2(LameGlobalFlags gfp, String id, String text) {
        long t_mask = ID3Tag.FRAME_ID('T', '\u0000', '\u0000', '\u0000');
        int frame_id = this.toID3v2TagId(id);
        if (frame_id == 0) {
            return -1;
        }
        if (((long)frame_id & t_mask) == t_mask) {
            if (this.isNumericString(frame_id)) {
                return -2;
            }
            if (text == null) {
                return 0;
            }
            if (!this.hasUcs2ByteOrderMarker(text.charAt(0))) {
                return -3;
            }
            if (gfp != null) {
                this.id3v2_add_ucs2(gfp, frame_id, null, null, text);
                return 0;
            }
        }
        return -255;
    }

    private int id3tag_set_textinfo_latin1(LameGlobalFlags gfp, String id, String text) {
        long t_mask = ID3Tag.FRAME_ID('T', '\u0000', '\u0000', '\u0000');
        int frame_id = this.toID3v2TagId(id);
        if (frame_id == 0) {
            return -1;
        }
        if (((long)frame_id & t_mask) == t_mask) {
            if (text == null) {
                return 0;
            }
            if (gfp != null) {
                this.id3v2_add_latin1(gfp, frame_id, null, null, text);
                return 0;
            }
        }
        return -255;
    }

    public final int id3tag_set_comment(LameGlobalFlags gfp, String lang, String desc, String text, int textPos) {
        if (gfp != null) {
            this.id3v2_add_latin1(gfp, ID_COMMENT, lang, desc, text);
            return 0;
        }
        return -255;
    }

    public final void id3tag_set_title(LameGlobalFlags gfp, String title) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (title != null && title.length() != 0) {
            gfc.tag_spec.title = title;
            gfc.tag_spec.flags |= 1;
            this.copyV1ToV2(gfp, ID_TITLE, title);
        }
    }

    public final void id3tag_set_artist(LameGlobalFlags gfp, String artist) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (artist != null && artist.length() != 0) {
            gfc.tag_spec.artist = artist;
            gfc.tag_spec.flags |= 1;
            this.copyV1ToV2(gfp, ID_ARTIST, artist);
        }
    }

    public final void id3tag_set_album(LameGlobalFlags gfp, String album) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (album != null && album.length() != 0) {
            gfc.tag_spec.album = album;
            gfc.tag_spec.flags |= 1;
            this.copyV1ToV2(gfp, ID_ALBUM, album);
        }
    }

    public final void id3tag_set_year(LameGlobalFlags gfp, String year) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (year != null && year.length() != 0) {
            int num = Integer.valueOf(year);
            if (num < 0) {
                num = 0;
            }
            if (num > 9999) {
                num = 9999;
            }
            if (num != 0) {
                gfc.tag_spec.year = num;
                gfc.tag_spec.flags |= 1;
            }
            this.copyV1ToV2(gfp, ID_YEAR, year);
        }
    }

    public final void id3tag_set_comment(LameGlobalFlags gfp, String comment) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (comment != null && comment.length() != 0) {
            gfc.tag_spec.comment = comment;
            gfc.tag_spec.flags |= 1;
            int flags = gfc.tag_spec.flags;
            this.id3v2_add_latin1(gfp, ID_COMMENT, "XXX", "", comment);
            gfc.tag_spec.flags = flags;
        }
    }

    public final int id3tag_set_track(LameGlobalFlags gfp, String track) {
        LameInternalFlags gfc = gfp.internal_flags;
        int ret = 0;
        if (track != null && track.length() != 0) {
            int trackcount = track.indexOf(47);
            int num = trackcount != -1 ? Integer.parseInt(track.substring(0, trackcount)) : Integer.parseInt(track);
            if (num < 1 || num > 255) {
                num = 0;
                ret = -1;
                gfc.tag_spec.flags |= 3;
            }
            if (num != 0) {
                gfc.tag_spec.track_id3v1 = num;
                gfc.tag_spec.flags |= 1;
            }
            if (trackcount != -1) {
                gfc.tag_spec.flags |= 3;
            }
            this.copyV1ToV2(gfp, ID_TRACK, track);
        }
        return ret;
    }

    private int nextUpperAlpha(String p, int pPos, char x) {
        char c = Character.toUpperCase(p.charAt(pPos));
        while (pPos < p.length()) {
            if ('A' <= c && c <= 'Z' && c != x) {
                return pPos;
            }
            c = Character.toUpperCase(p.charAt(pPos++));
        }
        return pPos;
    }

    private boolean sloppyCompared(String p, String q) {
        int pPos = this.nextUpperAlpha(p, 0, '\u0000');
        int qPos = this.nextUpperAlpha(q, 0, '\u0000');
        char cp = pPos < p.length() ? Character.toUpperCase(p.charAt(pPos)) : (char)'\u0000';
        char cq = Character.toUpperCase(q.charAt(qPos));
        while (cp == cq) {
            if (cp == '\u0000') {
                return true;
            }
            if (p.charAt(1) == '.') {
                while (qPos < q.length() && q.charAt(qPos++) != ' ') {
                }
            }
            pPos = this.nextUpperAlpha(p, pPos, cp);
            qPos = this.nextUpperAlpha(q, qPos, cq);
            cp = pPos < p.length() ? Character.toUpperCase(p.charAt(pPos)) : (char)'\u0000';
            cq = Character.toUpperCase(q.charAt(qPos));
        }
        return false;
    }

    private int sloppySearchGenre(String genre) {
        for (int i = 0; i < genre_names.length; ++i) {
            if (!this.sloppyCompared(genre, genre_names[i])) continue;
            return i;
        }
        return genre_names.length;
    }

    private int searchGenre(String genre) {
        for (int i = 0; i < genre_names.length; ++i) {
            if (!genre_names[i].equals(genre)) continue;
            return i;
        }
        return genre_names.length;
    }

    public final int id3tag_set_genre(LameGlobalFlags gfp, String genre) {
        LameInternalFlags gfc = gfp.internal_flags;
        int ret = 0;
        if (genre != null && genre.length() != 0) {
            int num;
            try {
                num = Integer.parseInt(genre);
                if (num < 0 || num >= genre_names.length) {
                    return -1;
                }
                genre = genre_names[num];
            }
            catch (NumberFormatException e) {
                num = this.searchGenre(genre);
                if (num == genre_names.length) {
                    num = this.sloppySearchGenre(genre);
                }
                if (num == genre_names.length) {
                    num = 12;
                    ret = -2;
                }
                genre = genre_names[num];
            }
            gfc.tag_spec.genre_id3v1 = num;
            gfc.tag_spec.flags |= 1;
            if (ret != 0) {
                gfc.tag_spec.flags |= 2;
            }
            this.copyV1ToV2(gfp, ID_GENRE, genre);
        }
        return ret;
    }

    private int set_frame_custom(byte[] frame, int framePos, char[] fieldvalue) {
        if (fieldvalue != null && fieldvalue[0] != '\u0000') {
            int value = 5;
            int length = new String(fieldvalue, value, fieldvalue.length - value).length();
            frame[framePos++] = (byte)fieldvalue[0];
            frame[framePos++] = (byte)fieldvalue[1];
            frame[framePos++] = (byte)fieldvalue[2];
            frame[framePos++] = (byte)fieldvalue[3];
            framePos = this.set_4_byte_value(frame, value, new String(fieldvalue, value, fieldvalue.length - value).length() + 1);
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            while (length-- != 0) {
                frame[framePos++] = (byte)fieldvalue[value++];
            }
        }
        return framePos;
    }

    private int sizeOfNode(FrameDataNode node) {
        int n = 0;
        if (node != null) {
            n = 10;
            ++n;
            switch (node.txt.enc) {
                default: {
                    n += node.txt.dim;
                    break;
                }
                case 1: {
                    n += node.txt.dim * 2;
                }
            }
        }
        return n;
    }

    private int sizeOfCommentNode(FrameDataNode node) {
        int n = 0;
        if (node != null) {
            n = 10;
            ++n;
            n += 3;
            switch (node.dsc.enc) {
                default: {
                    n += 1 + node.dsc.dim;
                    break;
                }
                case 1: {
                    n += 2 + node.dsc.dim * 2;
                }
            }
            switch (node.txt.enc) {
                default: {
                    n += node.txt.dim;
                    break;
                }
                case 1: {
                    n += node.txt.dim * 2;
                }
            }
        }
        return n;
    }

    private int writeChars(byte[] frame, int framePos, String str, int strPos, int n) {
        while (n-- != 0) {
            frame[framePos++] = (byte)str.charAt(strPos++);
        }
        return framePos;
    }

    private int writeUcs2s(byte[] frame, int framePos, String str, int strPos, int n) {
        while (n-- != 0) {
            frame[framePos++] = (byte)(0xFF & str.charAt(strPos) >> 8);
            frame[framePos++] = (byte)(0xFF & str.charAt(strPos++));
        }
        return framePos;
    }

    private int set_frame_comment(byte[] frame, int framePos, FrameDataNode node) {
        int n = this.sizeOfCommentNode(node);
        if (n > 10) {
            framePos = this.set_4_byte_value(frame, framePos, ID_COMMENT);
            framePos = this.set_4_byte_value(frame, framePos, n - 10);
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            frame[framePos++] = node.txt.enc == 1 ? (byte)1 : 0;
            frame[framePos++] = (byte)node.lng.charAt(0);
            frame[framePos++] = (byte)node.lng.charAt(1);
            frame[framePos++] = (byte)node.lng.charAt(2);
            if (node.dsc.enc != 1) {
                framePos = this.writeChars(frame, framePos, node.dsc.l, 0, node.dsc.dim);
                frame[framePos++] = 0;
            } else {
                framePos = this.writeUcs2s(frame, framePos, node.dsc.l, 0, node.dsc.dim);
                frame[framePos++] = 0;
                frame[framePos++] = 0;
            }
            framePos = node.txt.enc != 1 ? this.writeChars(frame, framePos, node.txt.l, 0, node.txt.dim) : this.writeUcs2s(frame, framePos, node.txt.l, 0, node.txt.dim);
        }
        return framePos;
    }

    private int set_frame_custom2(byte[] frame, int framePos, FrameDataNode node) {
        int n = this.sizeOfNode(node);
        if (n > 10) {
            framePos = this.set_4_byte_value(frame, framePos, node.fid);
            framePos = this.set_4_byte_value(frame, framePos, n - 10);
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            frame[framePos++] = node.txt.enc == 1 ? (byte)1 : 0;
            framePos = node.txt.enc != 1 ? this.writeChars(frame, framePos, node.txt.l, 0, node.txt.dim) : this.writeUcs2s(frame, framePos, node.txt.l, 0, node.txt.dim);
        }
        return framePos;
    }

    private int set_frame_apic(byte[] frame, int framePos, char[] mimetype, byte[] data, int size) {
        if (mimetype != null && data != null && size != 0) {
            framePos = this.set_4_byte_value(frame, framePos, ID3Tag.FRAME_ID('A', 'P', 'I', 'C'));
            framePos = this.set_4_byte_value(frame, framePos, 4 + mimetype.length + size);
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            int mimetypePos = 0;
            while (mimetypePos < mimetype.length) {
                frame[framePos++] = (byte)mimetype[mimetypePos++];
            }
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            frame[framePos++] = 0;
            int dataPos = 0;
            while (size-- != 0) {
                frame[framePos++] = data[dataPos++];
            }
        }
        return framePos;
    }

    public final int id3tag_set_fieldvalue(LameGlobalFlags gfp, String fieldvalue) {
        LameInternalFlags gfc = gfp.internal_flags;
        if (fieldvalue != null && fieldvalue.length() != 0) {
            int frame_id = this.toID3v2TagId(fieldvalue);
            if (fieldvalue.length() < 5 || fieldvalue.charAt(4) != '=') {
                return -1;
            }
            if (frame_id != 0 && this.id3tag_set_textinfo_latin1(gfp, fieldvalue, fieldvalue.substring(5)) != 0) {
                gfc.tag_spec.values.add(fieldvalue);
                ++gfc.tag_spec.num_values;
            }
            gfc.tag_spec.flags |= 1;
        }
        this.id3tag_add_v2(gfp);
        return 0;
    }

    public final int lame_get_id3v2_tag(LameGlobalFlags gfp, byte[] buffer, int size) {
        int comment_length;
        if (gfp == null) {
            return 0;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc == null) {
            return 0;
        }
        if ((gfc.tag_spec.flags & 4) != 0) {
            return 0;
        }
        int title_length = gfc.tag_spec.title != null ? gfc.tag_spec.title.length() : 0;
        int artist_length = gfc.tag_spec.artist != null ? gfc.tag_spec.artist.length() : 0;
        int album_length = gfc.tag_spec.album != null ? gfc.tag_spec.album.length() : 0;
        int n = comment_length = gfc.tag_spec.comment != null ? gfc.tag_spec.comment.length() : 0;
        if ((gfc.tag_spec.flags & 0xA) != 0 || title_length > 30 || artist_length > 30 || album_length > 30 || comment_length > 30 || gfc.tag_spec.track_id3v1 != 0 && comment_length > 28) {
            FrameDataNode node;
            int i;
            String albumart_mime = null;
            this.id3v2AddAudioDuration(gfp);
            int tag_size = 10;
            for (i = 0; i < gfc.tag_spec.num_values; ++i) {
                tag_size += 6 + gfc.tag_spec.values.get(i).length();
            }
            if (gfc.tag_spec.albumart != null && gfc.tag_spec.albumart_size != 0) {
                switch (gfc.tag_spec.albumart_mimetype) {
                    case MIMETYPE_JPEG: {
                        albumart_mime = mime_jpeg;
                        break;
                    }
                    case MIMETYPE_PNG: {
                        albumart_mime = mime_png;
                        break;
                    }
                    case MIMETYPE_GIF: {
                        albumart_mime = mime_gif;
                    }
                }
                if (albumart_mime != null) {
                    tag_size += 14 + albumart_mime.length() + gfc.tag_spec.albumart_size;
                }
            }
            ID3TagSpec tag = gfc.tag_spec;
            if (tag.v2_head != null) {
                node = tag.v2_head;
                while (node != null) {
                    tag_size = node.fid == ID_COMMENT ? (tag_size += this.sizeOfCommentNode(node)) : (tag_size += this.sizeOfNode(node));
                    node = node.nxt;
                }
            }
            if ((gfc.tag_spec.flags & 0x20) != 0) {
                tag_size += gfc.tag_spec.padding_size;
            }
            if (size < tag_size) {
                return tag_size;
            }
            if (buffer == null) {
                return 0;
            }
            int p = 0;
            buffer[p++] = 73;
            buffer[p++] = 68;
            buffer[p++] = 51;
            buffer[p++] = 3;
            buffer[p++] = 0;
            buffer[p++] = 0;
            int adjusted_tag_size = tag_size - 10;
            buffer[p++] = (byte)(adjusted_tag_size >> 21 & 0x7F);
            buffer[p++] = (byte)(adjusted_tag_size >> 14 & 0x7F);
            buffer[p++] = (byte)(adjusted_tag_size >> 7 & 0x7F);
            buffer[p++] = (byte)(adjusted_tag_size & 0x7F);
            tag = gfc.tag_spec;
            if (tag.v2_head != null) {
                node = tag.v2_head;
                while (node != null) {
                    p = node.fid == ID_COMMENT ? this.set_frame_comment(buffer, p, node) : this.set_frame_custom2(buffer, p, node);
                    node = node.nxt;
                }
            }
            for (i = 0; i < gfc.tag_spec.num_values; ++i) {
                p = this.set_frame_custom(buffer, p, gfc.tag_spec.values.get(i).toCharArray());
            }
            if (albumart_mime != null) {
                p = this.set_frame_apic(buffer, p, albumart_mime.toCharArray(), gfc.tag_spec.albumart, gfc.tag_spec.albumart_size);
            }
            Arrays.fill(buffer, p, tag_size, (byte)0);
            return tag_size;
        }
        return 0;
    }

    public final int id3tag_write_v2(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        if ((gfc.tag_spec.flags & 1) != 0 && 0 == (gfc.tag_spec.flags & 4)) {
            byte[] tag = null;
            int n = this.lame_get_id3v2_tag(gfp, null, 0);
            tag = new byte[n];
            int tag_size = this.lame_get_id3v2_tag(gfp, tag, n);
            if (tag_size > n) {
                return -1;
            }
            for (int i = 0; i < tag_size; ++i) {
                this.bits.add_dummy_byte(gfp, tag[i] & 0xFF, 1);
            }
            return tag_size;
        }
        return 0;
    }

    private int set_text_field(byte[] field, int fieldPos, String text, int size, int pad) {
        int textPos = 0;
        while (size-- != 0) {
            if (text != null && textPos < text.length()) {
                field[fieldPos++] = (byte)text.charAt(textPos++);
                continue;
            }
            field[fieldPos++] = (byte)pad;
        }
        return fieldPos;
    }

    public final int lame_get_id3v1_tag(LameGlobalFlags gfp, byte[] buffer, int size) {
        int tag_size = 128;
        if (gfp == null) {
            return 0;
        }
        if (size < tag_size) {
            return tag_size;
        }
        LameInternalFlags gfc = gfp.internal_flags;
        if (gfc == null) {
            return 0;
        }
        if (buffer == null) {
            return 0;
        }
        if ((gfc.tag_spec.flags & 1) != 0 && 0 == (gfc.tag_spec.flags & 8)) {
            int p = 0;
            int pad = (gfc.tag_spec.flags & 0x10) != 0 ? 32 : 0;
            buffer[p++] = 84;
            buffer[p++] = 65;
            buffer[p++] = 71;
            p = this.set_text_field(buffer, p, gfc.tag_spec.title, 30, pad);
            p = this.set_text_field(buffer, p, gfc.tag_spec.artist, 30, pad);
            p = this.set_text_field(buffer, p, gfc.tag_spec.album, 30, pad);
            String year = String.format("%d", gfc.tag_spec.year);
            p = this.set_text_field(buffer, p, gfc.tag_spec.year != 0 ? year : null, 4, pad);
            p = this.set_text_field(buffer, p, gfc.tag_spec.comment, gfc.tag_spec.track_id3v1 != 0 ? 28 : 30, pad);
            if (gfc.tag_spec.track_id3v1 != 0) {
                buffer[p++] = 0;
                buffer[p++] = (byte)gfc.tag_spec.track_id3v1;
            }
            buffer[p++] = (byte)gfc.tag_spec.genre_id3v1;
            return tag_size;
        }
        return 0;
    }

    public final int id3tag_write_v1(LameGlobalFlags gfp) {
        byte[] tag = new byte[128];
        int m = tag.length;
        int n = this.lame_get_id3v1_tag(gfp, tag, m);
        if (n > m) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            this.bits.add_dummy_byte(gfp, tag[i] & 0xFF, 1);
        }
        return n;
    }

    static enum MimeType {
        MIMETYPE_NONE,
        MIMETYPE_JPEG,
        MIMETYPE_PNG,
        MIMETYPE_GIF;

    }
}

