/*
 * Decompiled with CFR 0.152.
 */
package lowlevel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3V2Decoder {
    private String imageMimeType;
    private byte[] imageBytes;
    private String commentLanguage;
    private String comment;
    private String album;
    private String interpret;
    private String albumInterpret;
    private String componist;
    private String cdNumber;
    private String genre;
    private String title;
    private String track;
    private String year;

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public void setImageMimeType(String imageMimeType) {
        this.imageMimeType = imageMimeType;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public String getCommentLanguage() {
        return this.commentLanguage;
    }

    public void setCommentLanguage(String commentLanguage) {
        this.commentLanguage = commentLanguage;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public String getInterpret() {
        return this.interpret;
    }

    public void setInterpret(String interpret) {
        this.interpret = interpret;
    }

    public String getAlbumInterpret() {
        return this.albumInterpret;
    }

    public void setAlbumInterpret(String albumInterpret) {
        this.albumInterpret = albumInterpret;
    }

    public String getComponist() {
        return this.componist;
    }

    public void setComponist(String componist) {
        this.componist = componist;
    }

    public String getCdNumber() {
        return this.cdNumber;
    }

    public void setCdNumber(String cdNumber) {
        this.cdNumber = cdNumber;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public final void read(RandomAccessFile is) throws IOException {
        byte[] type = new byte[4];
        is.readFully(type);
        if (type[0] == 73 && type[1] == 68 && type[2] == 51) {
            byte[] pad = new byte[6];
            is.readFully(pad);
            pad[2] = (byte)(pad[2] & 0x7F);
            pad[3] = (byte)(pad[3] & 0x7F);
            pad[4] = (byte)(pad[4] & 0x7F);
            pad[5] = (byte)(pad[5] & 0x7F);
            int len = (((pad[2] << 7) + pad[3] << 7) + pad[4] << 7) + pad[5];
            this.readTags(is, len);
        }
    }

    private void readTags(RandomAccessFile is, int len) throws IOException {
        while (is.getFilePointer() < (long)len && !this.readTag(is)) {
        }
    }

    private boolean readTag(RandomAccessFile is) throws IOException {
        byte[] type = new byte[4];
        is.readFully(type);
        if (type[0] == 0) {
            return true;
        }
        String entryType = this.getType(type);
        byte[] lenbuf = new byte[4];
        is.readFully(lenbuf);
        is.skipBytes(2);
        if ("APIC".equals(entryType)) {
            this.readImage(is, this.readLength(lenbuf));
        } else if ("COMM".equals(entryType)) {
            is.skipBytes((int)this.readLength(lenbuf));
        } else {
            int enc = is.read();
            String fieldValue = this.readField(is, entryType, (int)this.readLength(lenbuf), enc);
            if (entryType.equals("TALB")) {
                this.setAlbum(fieldValue);
            } else if (entryType.equals("TPE1")) {
                this.setInterpret(fieldValue);
            } else if (entryType.equals("TPE2")) {
                this.setAlbumInterpret(fieldValue);
            } else if (entryType.equals("TCOM")) {
                this.setComponist(fieldValue);
            } else if (entryType.equals("TPOS")) {
                this.setCdNumber(fieldValue);
            } else if (entryType.equals("TCON")) {
                this.setGenre(fieldValue);
            } else if (entryType.equals("TIT2")) {
                this.setTitle(fieldValue);
            } else if (entryType.equals("TRCK")) {
                this.setTrack(fieldValue);
            } else if (entryType.equals("TYER")) {
                this.setYear(fieldValue);
            }
        }
        return false;
    }

    private long readLength(byte[] lenbuf) {
        long val = (lenbuf[0] & 0xFF) << 24;
        val += (long)((lenbuf[1] & 0xFF) << 16);
        val += (long)((lenbuf[2] & 0xFF) << 8);
        return val += (long)(lenbuf[3] & 0xFF);
    }

    private String readField(RandomAccessFile is, String type, int len, int enc) throws IOException {
        byte[] field = new byte[len];
        is.readFully(field, 0, len - 1);
        if (enc == 0) {
            return new String(field, 0, len - 1, "ISO-8859-1");
        }
        if (enc == 1) {
            return new String(field, 0, len - 1, "UTF-16");
        }
        if (enc == 3) {
            return new String(field, 0, len - 1, "UTF-8");
        }
        return "";
    }

    private void readComment(RandomAccessFile is, int len, int enc) throws IOException {
        byte[] lang = new byte[3];
        is.readFully(lang);
        String language = new String(lang);
        this.setCommentLanguage(language);
        is.read();
        String fieldValue = this.readString(is, len, enc);
        fieldValue = this.readString(is, len, enc);
        this.setComment(fieldValue);
    }

    private String readString(RandomAccessFile is, int len, int enc) throws IOException {
        if (enc == 0 || enc == 3) {
            byte[] bytes = new byte[len];
            int pos = 0;
            do {
                int ch = is.read();
                bytes[pos++] = (byte)ch;
            } while (pos < len && bytes[pos - 1] != 0);
            if (enc == 0) {
                return new String(bytes, 0, pos, "ISO-8859-1");
            }
            return new String(bytes, 0, pos, "UTF-8");
        }
        byte[] bytes = new byte[len -= 8];
        int pos = 0;
        do {
            int ch = is.read();
            bytes[pos++] = (byte)ch;
        } while (pos < len && (bytes[pos - 1] != 0 || bytes[pos - 2] != 0));
        return new String(bytes, 0, pos, "UTF-16");
    }

    private void readImage(RandomAccessFile is, long len) throws IOException, FileNotFoundException {
        int ch;
        int c = is.read();
        StringBuilder mime = new StringBuilder();
        do {
            if ((ch = is.read()) <= 0) continue;
            mime.append((char)ch);
        } while (ch > 0);
        this.setImageMimeType(mime.toString());
        is.skipBytes(2);
        byte[] pic = new byte[(int)(len - (long)mime.length() - 4L)];
        is.readFully(pic);
        this.setImageBytes(pic);
    }

    private String getType(byte[] type) {
        return String.valueOf((char)type[0]) + String.valueOf((char)type[1]) + String.valueOf((char)type[2]) + String.valueOf((char)type[3]);
    }

    public static void main(String[] args) {
        try {
            ID3V2Decoder id3v2Decoder = new ID3V2Decoder();
            id3v2Decoder.read(new RandomAccessFile(args[0], "r"));
            System.out.println();
            FileOutputStream os = new FileOutputStream(new File("d:/out.jpg"));
            os.write(id3v2Decoder.getImageBytes());
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

