#include <stdint.h>
#include <stdio.h>
#include <string.h>

uint8_t font[256][8];

int main() {
	char buf[128];
	int ch = 0, y = 0, p, enable = 0;

	while((fgets(buf, sizeof(buf), stdin))) {
		if(*buf && buf[strlen(buf) - 1] == '\n') {
			buf[strlen(buf) - 1] = 0;
		}

		if(1 == sscanf(buf, "ENCODING %d", &p)) {
			ch = p & 255;
			enable = 0;
		} else if(!strcmp(buf, "BITMAP")) {
			y = 0;
			enable = 1;
		} else if(enable && 1 == sscanf(buf, "%x", &p)) {
			font[ch][y] = p;
			y++;
			if(y == 8) enable = 0;
		} else {
			enable = 0;
		}
	}

	for(p = 0; p < 2; p++) {
		for(ch = 0; ch < 128; ch++) {
			for(y = 0; y < 8; y++) {
				if(p) {
					fputc((((font[ch][y] << 1) | font[ch][y]) << 0) & 0xfc, stdout);
					//fputc(((font[ch][y] << 1) & 0xfc) ^ ((y == 7)? 0xfc : 0), stdout);
				} else {
					fputc((font[ch][y] << 1) & 0xfc, stdout);
				}
			}
		}
	}

	return 0;
}
