#!/bin/bash
VERSION=`cat Version`
applicationName="CheeseCutter.app"
backgroundPictureName="background.png"
source="dist"
title="CheeseCutter-${VERSION}"
size=20000
finalDMGName="CheeseCutter_${VERSION}.dmg"

mkdir "${source}"
cp -r "${applicationName}" "${source}"

hdiutil create -srcfolder "${source}" -volname "${title}" -fs HFS+ \
      -fsargs "-c c=64,a=16,e=16" -format UDRW -size ${size}k pack.temp.dmg
device=$(hdiutil attach -readwrite -noverify -noautoopen "pack.temp.dmg" | \
         egrep '^/dev/' | sed 1q | awk '{print $1}')
sleep 5
mkdir /Volumes/"${title}"/.background
cp arch/background.png /Volumes/"${title}"/.background
cp -r tunes README COPYING Changelog /Volumes/"${title}"/

echo '
   tell application "Finder"
     tell disk "'${title}'"
           open
           set current view of container window to icon view
           set toolbar visible of container window to false
           set statusbar visible of container window to false
           set the bounds of container window to {400, 100, 1040, 430}
           set theViewOptions to the icon view options of container window
           set arrangement of theViewOptions to not arranged
           set icon size of theViewOptions to 72
           set background picture of theViewOptions to file ".background:'${backgroundPictureName}'"
           make new alias file at container window to POSIX file "/Applications" with properties {name:"Applications"}
           delay 1
           set position of item "'${applicationName}'" of container window to {100, 200}  
           set position of item "Applications" of container window to {300,200}
           set position of item "tunes" of container window to {200,200}
           set position of item "README" of container window to {400,250}
           set position of item "COPYING" of container window to {500,250}
           set position of item "Changelog" of container window to {600,250}
           update without registering applications
           close
	   open
	   delay 5
           eject
     end tell
   end tell
' | osascript

chmod -Rf go-w /Volumes/"${title}"
sync
sync
hdiutil detach ${device}
hdiutil convert pack.temp.dmg -format UDZO -imagekey zlib-level=9 -o ${finalDMGName}
rm pack.temp.dmg 
