;C64 executable code for HermIRES 'Exe' export (64tass syntax)

bmpdata=$0A00
titleaddr=bmpdata-40
bitmap=$2000
vidram=$0400
zpreg=$fa
srcptr=$fc
tgtptr=$fe
titlePosX=$50
titlePosY=1
titleCol=15
titleSpr=$0c00
charROM=$d800

		*= $0801
		.word ss,2012
		.null $9e,^start;Sys 2064
ss		.word 0

		*= $0810		;INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
start	sei
		lda #$35
		sta 1
		lda #3
		sta $dd00
		sta $d011
		lda bmpdata+$2328 ;border-colour
		sta $d020
		sta $d021
		sta bordercol

		jsr copydata

		jsr wrtitle

		lda #$18
		sta $d018
		lda #$3b
		sta $d011
		lda #8
		sta $d016

rastlp	lda #$f9
		cmp $d012
		bne *-3
		lda $d011
		ora #$20
		and #$FF-8
		sta $d011
		and #$ff-8
		sta $d011
		lda #$ff
		sta $d015

		lda #$fa
		cmp $d012
		bne *-3
		ldx #9
		dex
		bne *-1
		lda $d011
		and #$ff-$20
		sta $d011

		lda #titlePosY-1
		cmp $d012
		bne *-3
		lda #0
		sta $d021

		lda #titleposY+8
		cmp $d012
		bne *-3
		nop
		lda $d011
		ora #8
		and #$ff-$20
		sta $d011
		ldy bordercol
		ldx #21
		dex
		bne *-1
		nop
		sty $d021

		lda #0
		sta $d015

		lda $d012
		bne *-3

		lda #$32
		cmp $d012
		bne *-3
		ldx #10
		dex
		bne *-1
		lda $d011
		ora #$28
		sta $d011

		jmp rastlp
		
;-----------------------------------------
copydata		
		ldy #0
-		lda bmpdata+$1f40,y
		sta vidram,y 
		lda bmpdata+$2040,y
		sta vidram+$100,y 
		lda bmpdata+$2140,y
		sta vidram+$200,y 
		lda bmpdata+$2240,y
		sta vidram+$300,y 
		iny
		bne -

		lda #<(bmpdata+$1F00)
		ldx #>(bmpdata+$1F00)
		sta srcptr+0
		stx srcptr+1
		lda #<(bitmap+$1F00)
		ldx #>(bitmap+$1F00)
		sta tgtptr+0
		stx tgtptr+1
		ldy #0
-		lda (srcptr),y
		sta (tgtptr),y
		iny
		bne -
		dec srcptr+1
		dec tgtptr+1
		lda tgtptr+1
		cmp #>(bitmap)
		bpl -

		ldx #7
-		txa
		asl
		tay
		lda #titlePosY
		sta $d001,y
		lda spcoorX,x
		sta $d000,y
		lda #titleCol
		sta $d027,x
		txa
		clc
		adc #(titlespr/64)
		sta vidram+$3F8,x 
		dex
		bpl -
		lda #0
		sta $d010
		sta $3fff

		rts

wrtitle	ldy #0
-		lda #0
		sta titlespr,y
		sta titlespr+$100,y
		iny
		bne -

		ldx #0
		stx zpreg

titlelp	ldx zpreg
		lda #0
		sta charlop+1
		sta charlop+2
		lda titleaddr,x
		beq endwrti
		asl 			;and multiply by 8 to get character's address
		rol charlop+2
		asl 
		rol charlop+2
		asl 
		rol charlop+2
		sta charlop+1
		lda charlop+2
		clc
		adc #>(charROM)
		sta charlop+2

		lda #<titlespr
		clc
		adc spChrPos,x
		sta tgtptr+0
		ldy #>titlespr
		cpx #12
		bcc +
		iny
+		sty tgtptr+1

		lda #$33		;switch to Char-RAM
		sta 1
		ldy #0
		ldx #0
charlop	lda $1111,x ;copy char byte
		sta (tgtptr),y ;paste char byte to sprite
		iny
		iny
		iny
		inx
		cpx #8
		bne charlop
		lda #$35		;switch to Char-RAM
		sta 1

		inc zpreg
		ldx zpreg
		cpx #24
		bne titlelp

endwrti	rts

spcoorx	.byte titlePosX, titlePosX+24, titlePosX+24*2, titlePosX+24*3, titlePosX+24*4, titlePosX+24*5, titlePosX+24*6, titlePosX+24*7 

spChrPos .byte 0,1,2,$40,$41,$42,$80,$81,$82,$c0,$c1,$c2, 0,1,2,$40,$41,$42,$80,$81,$82,$c0,$c1,$c2
bordercol .byte 0
;===============================================================================
.cerror *>titleaddr,"TOO MUCH CODE BEFORE BITMAP-DATA! CHANGE BMPDATA ADDRESS!"

*=titleaddr
;title	.text "AUTHOR-NAME : PIC. TITLE",0
;
*=bmpdata
;.binary"examples/Pahanilamnlintu-bitmap.prg",2

;==============================================================================
